/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.results.DistinctResultsBlock;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.trace.Tracing;

public class DictionaryBasedDistinctOperator
extends BaseOperator<DistinctResultsBlock> {
    private static final String EXPLAIN_NAME = "DISTINCT_DICTIONARY";
    private final DataSource _dataSource;
    private final QueryContext _queryContext;
    private int _numDocsScanned;

    public DictionaryBasedDistinctOperator(DataSource dataSource, QueryContext queryContext) {
        this._dataSource = dataSource;
        this._queryContext = queryContext;
    }

    @Override
    protected DistinctResultsBlock getNextBlock() {
        DistinctTable distinctTable;
        String column = this._queryContext.getSelectExpressions().get(0).getIdentifier();
        Dictionary dictionary = this._dataSource.getDictionary();
        assert (dictionary != null);
        DataSourceMetadata dataSourceMetadata = this._dataSource.getDataSourceMetadata();
        DataSchema dataSchema = new DataSchema(new String[]{column}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)dataSourceMetadata.getDataType())});
        int limit = this._queryContext.getLimit();
        int dictLength = dictionary.length();
        int numValuesToKeep = Math.min(limit, dictLength);
        boolean nullHandlingEnabled = this._queryContext.isNullHandlingEnabled();
        List<OrderByExpressionContext> orderByExpressions = this._queryContext.getOrderByExpressions();
        if (orderByExpressions == null) {
            distinctTable = new DistinctTable(dataSchema, DictionaryBasedDistinctOperator.iterateOnDictionary(dictionary, numValuesToKeep), nullHandlingEnabled);
            this._numDocsScanned = numValuesToKeep;
        } else if (dictionary.isSorted()) {
            distinctTable = orderByExpressions.get(0).isAsc() ? new DistinctTable(dataSchema, DictionaryBasedDistinctOperator.iterateOnDictionary(dictionary, numValuesToKeep), nullHandlingEnabled) : new DistinctTable(dataSchema, DictionaryBasedDistinctOperator.iterateOnDictionaryDesc(dictionary, numValuesToKeep), nullHandlingEnabled);
            this._numDocsScanned = numValuesToKeep;
        } else {
            distinctTable = new DistinctTable(dataSchema, orderByExpressions, limit, nullHandlingEnabled);
            for (int i = 0; i < dictLength; ++i) {
                distinctTable.addWithOrderBy(new Record(new Object[]{dictionary.getInternal(i)}));
            }
            this._numDocsScanned = dictLength;
        }
        return new DistinctResultsBlock(distinctTable, this._queryContext);
    }

    private static List<Record> iterateOnDictionary(Dictionary dictionary, int length) {
        ArrayList<Record> records = new ArrayList<Record>(length);
        for (int i = 0; i < length; ++i) {
            Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)i);
            records.add(new Record(new Object[]{dictionary.getInternal(i)}));
        }
        return records;
    }

    private static List<Record> iterateOnDictionaryDesc(Dictionary dictionary, int length) {
        ArrayList<Record> records = new ArrayList<Record>(length);
        int dictLength = dictionary.length();
        int i = dictLength - 1;
        int j = 0;
        while (i >= dictLength - length) {
            Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)j);
            records.add(new Record(new Object[]{dictionary.getInternal(i)}));
            --i;
            ++j;
        }
        return records;
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return new ExecutionStatistics(this._numDocsScanned, 0L, this._numDocsScanned, this._dataSource.getDataSourceMetadata().getNumDocs());
    }
}

