/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.data.FieldSpec;

public class EmptySelectionOperator
extends BaseOperator<SelectionResultsBlock> {
    private static final String EXPLAIN_NAME = "SELECT_EMPTY";
    private final BaseProjectOperator<?> _projectOperator;
    private final QueryContext _queryContext;
    private final DataSchema _dataSchema;
    private final ExecutionStatistics _executionStatistics;

    public EmptySelectionOperator(IndexSegment indexSegment, QueryContext queryContext, List<ExpressionContext> expressions, BaseProjectOperator<?> projectOperator) {
        this._projectOperator = projectOperator;
        this._queryContext = queryContext;
        int numExpressions = expressions.size();
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            ExpressionContext expression = expressions.get(i);
            columnNames[i] = expression.toString();
            ColumnContext columnContext = projectOperator.getResultColumnContext(expression);
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)columnContext.getDataType(), (boolean)columnContext.isSingleValue());
        }
        this._dataSchema = new DataSchema(columnNames, columnDataTypes);
        this._executionStatistics = new ExecutionStatistics(0L, 0L, 0L, indexSegment.getSegmentMetadata().getTotalDocs());
    }

    @Override
    protected SelectionResultsBlock getNextBlock() {
        return new SelectionResultsBlock(this._dataSchema, Collections.emptyList(), this._queryContext);
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<BaseProjectOperator<?>> getChildOperators() {
        return Collections.singletonList(this._projectOperator);
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._executionStatistics;
    }
}

