/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.data.table.IntermediateRecord;
import org.apache.pinot.core.data.table.TableResizer;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.blocks.results.GroupByResultsBlock;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.core.query.aggregation.groupby.DefaultGroupByExecutor;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.startree.executor.StarTreeGroupByExecutor;
import org.apache.pinot.core.util.GroupByUtils;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.trace.Tracing;

public class FilteredGroupByOperator
extends BaseOperator<GroupByResultsBlock> {
    private static final String EXPLAIN_NAME = "GROUP_BY_FILTERED";
    private final QueryContext _queryContext;
    private final AggregationFunction[] _aggregationFunctions;
    private final ExpressionContext[] _groupByExpressions;
    private final List<AggregationFunctionUtils.AggregationInfo> _aggregationInfos;
    private final long _numTotalDocs;
    private final DataSchema _dataSchema;
    private long _numDocsScanned;
    private long _numEntriesScannedInFilter;
    private long _numEntriesScannedPostFilter;

    public FilteredGroupByOperator(QueryContext queryContext, List<AggregationFunctionUtils.AggregationInfo> aggregationInfos, long numTotalDocs) {
        int i;
        assert (queryContext.getAggregationFunctions() != null && queryContext.getFilteredAggregationFunctions() != null && queryContext.getGroupByExpressions() != null);
        this._queryContext = queryContext;
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        this._groupByExpressions = queryContext.getGroupByExpressions().toArray(new ExpressionContext[0]);
        this._aggregationInfos = aggregationInfos;
        this._numTotalDocs = numTotalDocs;
        int numGroupByExpressions = this._groupByExpressions.length;
        int numAggregationFunctions = this._aggregationFunctions.length;
        int numColumns = numGroupByExpressions + numAggregationFunctions;
        String[] columnNames = new String[numColumns];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numColumns];
        BaseProjectOperator<?> projectOperator = aggregationInfos.get(0).getProjectOperator();
        for (i = 0; i < numGroupByExpressions; ++i) {
            ExpressionContext groupByExpression = this._groupByExpressions[i];
            columnNames[i] = groupByExpression.toString();
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)projectOperator.getResultColumnContext(groupByExpression).getDataType());
        }
        for (i = 0; i < numAggregationFunctions; ++i) {
            String columnName;
            int index = numGroupByExpressions + i;
            Pair<AggregationFunction, FilterContext> pair = queryContext.getFilteredAggregationFunctions().get(i);
            AggregationFunction aggregationFunction = (AggregationFunction)pair.getLeft();
            columnNames[index] = columnName = AggregationFunctionUtils.getResultColumnName(aggregationFunction, (FilterContext)pair.getRight());
            columnDataTypes[index] = aggregationFunction.getIntermediateResultColumnType();
        }
        this._dataSchema = new DataSchema(columnNames, columnDataTypes);
    }

    @Override
    protected GroupByResultsBlock getNextBlock() {
        int numAggregations = this._aggregationFunctions.length;
        GroupByResultHolder[] groupByResultHolders = new GroupByResultHolder[numAggregations];
        IdentityHashMap<AggregationFunction, Integer> resultHolderIndexMap = new IdentityHashMap<AggregationFunction, Integer>(this._aggregationFunctions.length);
        for (int i = 0; i < numAggregations; ++i) {
            resultHolderIndexMap.put(this._aggregationFunctions[i], i);
        }
        GroupKeyGenerator groupKeyGenerator = null;
        for (AggregationFunctionUtils.AggregationInfo aggregationInfo : this._aggregationInfos) {
            ValueBlock valueBlock;
            DefaultGroupByExecutor groupByExecutor;
            AggregationFunction[] aggregationFunctions = aggregationInfo.getFunctions();
            BaseProjectOperator<?> projectOperator = aggregationInfo.getProjectOperator();
            if (groupKeyGenerator == null) {
                groupByExecutor = aggregationInfo.isUseStarTree() ? new StarTreeGroupByExecutor(this._queryContext, aggregationFunctions, this._groupByExpressions, projectOperator) : new DefaultGroupByExecutor(this._queryContext, aggregationFunctions, this._groupByExpressions, projectOperator);
                groupKeyGenerator = groupByExecutor.getGroupKeyGenerator();
            } else {
                groupByExecutor = aggregationInfo.isUseStarTree() ? new StarTreeGroupByExecutor(this._queryContext, aggregationFunctions, this._groupByExpressions, projectOperator, groupKeyGenerator) : new DefaultGroupByExecutor(this._queryContext, aggregationFunctions, this._groupByExpressions, projectOperator, groupKeyGenerator);
            }
            int numDocsScanned = 0;
            while ((valueBlock = (ValueBlock)projectOperator.nextBlock()) != null) {
                numDocsScanned += valueBlock.getNumDocs();
                groupByExecutor.process(valueBlock);
            }
            this._numDocsScanned += (long)numDocsScanned;
            this._numEntriesScannedInFilter += projectOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
            this._numEntriesScannedPostFilter += (long)numDocsScanned * (long)projectOperator.getNumColumnsProjected();
            GroupByResultHolder[] filterGroupByResults = groupByExecutor.getGroupByResultHolders();
            for (int i = 0; i < aggregationFunctions.length; ++i) {
                groupByResultHolders[((Integer)resultHolderIndexMap.get((Object)aggregationFunctions[i])).intValue()] = filterGroupByResults[i];
            }
        }
        assert (groupKeyGenerator != null);
        for (GroupByResultHolder groupByResultHolder : groupByResultHolders) {
            groupByResultHolder.ensureCapacity(groupKeyGenerator.getNumKeys());
        }
        boolean numGroupsLimitReached = groupKeyGenerator.getNumKeys() >= this._queryContext.getNumGroupsLimit();
        Tracing.activeRecording().setNumGroups(this._queryContext.getNumGroupsLimit(), groupKeyGenerator.getNumKeys());
        int minGroupTrimSize = this._queryContext.getMinSegmentGroupTrimSize();
        if (this._queryContext.getOrderByExpressions() != null && minGroupTrimSize > 0) {
            int trimSize = GroupByUtils.getTableCapacity(this._queryContext.getLimit(), minGroupTrimSize);
            if (groupKeyGenerator.getNumKeys() > trimSize) {
                TableResizer tableResizer = new TableResizer(this._dataSchema, this._queryContext);
                List<IntermediateRecord> intermediateRecords = tableResizer.trimInSegmentResults(groupKeyGenerator, groupByResultHolders, trimSize);
                GroupByResultsBlock resultsBlock = new GroupByResultsBlock(this._dataSchema, intermediateRecords, this._queryContext);
                resultsBlock.setNumGroupsLimitReached(numGroupsLimitReached);
                return resultsBlock;
            }
        }
        AggregationGroupByResult aggGroupByResult = new AggregationGroupByResult(groupKeyGenerator, this._aggregationFunctions, groupByResultHolders);
        GroupByResultsBlock resultsBlock = new GroupByResultsBlock(this._dataSchema, aggGroupByResult, this._queryContext);
        resultsBlock.setNumGroupsLimitReached(numGroupsLimitReached);
        return resultsBlock;
    }

    @Override
    public List<Operator> getChildOperators() {
        return this._aggregationInfos.stream().map(AggregationFunctionUtils.AggregationInfo::getProjectOperator).collect(Collectors.toList());
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return new ExecutionStatistics(this._numDocsScanned, this._numEntriesScannedInFilter, this._numEntriesScannedPostFilter, this._numTotalDocs);
    }

    @Override
    public String toExplainString() {
        int i;
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(groupKeys:");
        if (this._groupByExpressions.length > 0) {
            stringBuilder.append(this._groupByExpressions[0].toString());
            for (i = 1; i < this._groupByExpressions.length; ++i) {
                stringBuilder.append(", ").append(this._groupByExpressions[i].toString());
            }
        }
        stringBuilder.append(", aggregations:");
        if (this._aggregationFunctions.length > 0) {
            stringBuilder.append(this._aggregationFunctions[0].toExplainString());
            for (i = 1; i < this._aggregationFunctions.length; ++i) {
                stringBuilder.append(", ").append(this._aggregationFunctions[i].toExplainString());
            }
        }
        return stringBuilder.append(')').toString();
    }
}

