/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.data.table.IntermediateRecord;
import org.apache.pinot.core.data.table.TableResizer;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.blocks.results.GroupByResultsBlock;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.aggregation.groupby.DefaultGroupByExecutor;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.startree.executor.StarTreeGroupByExecutor;
import org.apache.pinot.core.util.GroupByUtils;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.trace.Tracing;

public class GroupByOperator
extends BaseOperator<GroupByResultsBlock> {
    private static final String EXPLAIN_NAME = "GROUP_BY";
    private final QueryContext _queryContext;
    private final AggregationFunction[] _aggregationFunctions;
    private final ExpressionContext[] _groupByExpressions;
    private final BaseProjectOperator<?> _projectOperator;
    private final boolean _useStarTree;
    private final long _numTotalDocs;
    private final DataSchema _dataSchema;
    private int _numDocsScanned = 0;

    public GroupByOperator(QueryContext queryContext, AggregationFunctionUtils.AggregationInfo aggregationInfo, long numTotalDocs) {
        int i;
        assert (queryContext.getAggregationFunctions() != null && queryContext.getGroupByExpressions() != null);
        this._queryContext = queryContext;
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        this._groupByExpressions = queryContext.getGroupByExpressions().toArray(new ExpressionContext[0]);
        this._projectOperator = aggregationInfo.getProjectOperator();
        this._useStarTree = aggregationInfo.isUseStarTree();
        this._numTotalDocs = numTotalDocs;
        int numGroupByExpressions = this._groupByExpressions.length;
        int numAggregationFunctions = this._aggregationFunctions.length;
        int numColumns = numGroupByExpressions + numAggregationFunctions;
        String[] columnNames = new String[numColumns];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numColumns];
        for (i = 0; i < numGroupByExpressions; ++i) {
            ExpressionContext groupByExpression = this._groupByExpressions[i];
            columnNames[i] = groupByExpression.toString();
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)this._projectOperator.getResultColumnContext(groupByExpression).getDataType());
        }
        for (i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunction aggregationFunction = this._aggregationFunctions[i];
            int index = numGroupByExpressions + i;
            columnNames[index] = aggregationFunction.getResultColumnName();
            columnDataTypes[index] = aggregationFunction.getIntermediateResultColumnType();
        }
        this._dataSchema = new DataSchema(columnNames, columnDataTypes);
    }

    @Override
    protected GroupByResultsBlock getNextBlock() {
        ValueBlock valueBlock;
        DefaultGroupByExecutor groupByExecutor = this._useStarTree ? new StarTreeGroupByExecutor(this._queryContext, this._groupByExpressions, this._projectOperator) : new DefaultGroupByExecutor(this._queryContext, this._groupByExpressions, this._projectOperator);
        while ((valueBlock = (ValueBlock)this._projectOperator.nextBlock()) != null) {
            this._numDocsScanned += valueBlock.getNumDocs();
            groupByExecutor.process(valueBlock);
        }
        boolean numGroupsLimitReached = groupByExecutor.getNumGroups() >= this._queryContext.getNumGroupsLimit();
        Tracing.activeRecording().setNumGroups(this._queryContext.getNumGroupsLimit(), groupByExecutor.getNumGroups());
        int minGroupTrimSize = this._queryContext.getMinSegmentGroupTrimSize();
        if (this._queryContext.getOrderByExpressions() != null && minGroupTrimSize > 0) {
            int trimSize = GroupByUtils.getTableCapacity(this._queryContext.getLimit(), minGroupTrimSize);
            if (groupByExecutor.getNumGroups() > trimSize) {
                TableResizer tableResizer = new TableResizer(this._dataSchema, this._queryContext);
                Collection<IntermediateRecord> intermediateRecords = groupByExecutor.trimGroupByResult(trimSize, tableResizer);
                GroupByResultsBlock resultsBlock = new GroupByResultsBlock(this._dataSchema, intermediateRecords, this._queryContext);
                resultsBlock.setNumGroupsLimitReached(numGroupsLimitReached);
                return resultsBlock;
            }
        }
        GroupByResultsBlock resultsBlock = new GroupByResultsBlock(this._dataSchema, groupByExecutor.getResult(), this._queryContext);
        resultsBlock.setNumGroupsLimitReached(numGroupsLimitReached);
        return resultsBlock;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._projectOperator);
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._projectOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)this._projectOperator.getNumColumnsProjected();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, this._numTotalDocs);
    }

    @Override
    public String toExplainString() {
        int i;
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(groupKeys:");
        if (this._groupByExpressions.length > 0) {
            stringBuilder.append(this._groupByExpressions[0].toString());
            for (i = 1; i < this._groupByExpressions.length; ++i) {
                stringBuilder.append(", ").append(this._groupByExpressions[i].toString());
            }
        }
        stringBuilder.append(", aggregations:");
        if (this._aggregationFunctions.length > 0) {
            stringBuilder.append(this._aggregationFunctions[0].toExplainString());
            for (i = 1; i < this._aggregationFunctions.length; ++i) {
                stringBuilder.append(", ").append(this._aggregationFunctions[i].toExplainString());
            }
        }
        return stringBuilder.append(')').toString();
    }
}

