/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.common.RowBasedBlockValueFetcher;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.BitmapDocIdSetOperator;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.core.operator.ProjectionOperatorUtils;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.core.query.utils.OrderByComparatorFactory;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.RoaringBitmap;

public class SelectionOrderByOperator
extends BaseOperator<SelectionResultsBlock> {
    private static final String EXPLAIN_NAME = "SELECT_ORDERBY";
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;
    private final boolean _nullHandlingEnabled;
    private final List<ExpressionContext> _expressions;
    private final BaseProjectOperator<?> _projectOperator;
    private final List<OrderByExpressionContext> _orderByExpressions;
    private final ColumnContext[] _orderByColumnContexts;
    private final int _numRowsToKeep;
    private final Comparator<Object[]> _comparator;
    private final PriorityQueue<Object[]> _rows;
    private int _numDocsScanned = 0;
    private long _numEntriesScannedPostFilter = 0L;

    public SelectionOrderByOperator(IndexSegment indexSegment, QueryContext queryContext, List<ExpressionContext> expressions, BaseProjectOperator<?> projectOperator) {
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
        this._nullHandlingEnabled = queryContext.isNullHandlingEnabled();
        this._expressions = expressions;
        this._projectOperator = projectOperator;
        this._orderByExpressions = queryContext.getOrderByExpressions();
        assert (this._orderByExpressions != null);
        int numOrderByExpressions = this._orderByExpressions.size();
        this._orderByColumnContexts = new ColumnContext[numOrderByExpressions];
        for (int i = 0; i < numOrderByExpressions; ++i) {
            ExpressionContext expression = this._orderByExpressions.get(i).getExpression();
            this._orderByColumnContexts[i] = this._projectOperator.getResultColumnContext(expression);
        }
        this._numRowsToKeep = queryContext.getOffset() + queryContext.getLimit();
        this._comparator = OrderByComparatorFactory.getComparator(this._orderByExpressions, this._orderByColumnContexts, this._nullHandlingEnabled);
        this._rows = new PriorityQueue<Object[]>(Math.min(this._numRowsToKeep, 10000), this._comparator.reversed());
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(selectList:");
        if (!this._expressions.isEmpty()) {
            stringBuilder.append(this._expressions.get(0));
            for (int i = 1; i < this._expressions.size(); ++i) {
                stringBuilder.append(", ").append(this._expressions.get(i));
            }
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    protected SelectionResultsBlock getNextBlock() {
        if (this._expressions.size() == this._orderByExpressions.size()) {
            return this.computeAllOrdered();
        }
        return this.computePartiallyOrdered();
    }

    private SelectionResultsBlock computeAllOrdered() {
        ValueBlock valueBlock;
        int numExpressions = this._expressions.size();
        BlockValSet[] blockValSets = new BlockValSet[numExpressions];
        int numColumnsProjected = this._projectOperator.getNumColumnsProjected();
        while ((valueBlock = (ValueBlock)this._projectOperator.nextBlock()) != null) {
            for (int i = 0; i < numExpressions; ++i) {
                ExpressionContext expression = this._expressions.get(i);
                blockValSets[i] = valueBlock.getBlockValueSet(expression);
            }
            RowBasedBlockValueFetcher blockValueFetcher = new RowBasedBlockValueFetcher(blockValSets);
            int numDocsFetched = valueBlock.getNumDocs();
            if (this._nullHandlingEnabled) {
                RoaringBitmap[] nullBitmaps = new RoaringBitmap[numExpressions];
                for (int i = 0; i < numExpressions; ++i) {
                    nullBitmaps[i] = blockValSets[i].getNullBitmap();
                }
                for (int rowId = 0; rowId < numDocsFetched; ++rowId) {
                    Object[] row = blockValueFetcher.getRow(rowId);
                    for (int colId = 0; colId < numExpressions; ++colId) {
                        if (nullBitmaps[colId] == null || !nullBitmaps[colId].contains(rowId)) continue;
                        row[colId] = null;
                    }
                    SelectionOperatorUtils.addToPriorityQueue(row, this._rows, this._numRowsToKeep);
                }
            } else {
                for (int i = 0; i < numDocsFetched; ++i) {
                    SelectionOperatorUtils.addToPriorityQueue(blockValueFetcher.getRow(i), this._rows, this._numRowsToKeep);
                }
            }
            this._numDocsScanned += numDocsFetched;
        }
        this._numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)numColumnsProjected;
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            columnNames[i] = this._expressions.get(i).toString();
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)this._orderByColumnContexts[i].getDataType(), (boolean)this._orderByColumnContexts[i].isSingleValue());
        }
        DataSchema dataSchema = new DataSchema(columnNames, columnDataTypes);
        return new SelectionResultsBlock(dataSchema, this.getSortedRows(), this._comparator, this._queryContext);
    }

    private SelectionResultsBlock computePartiallyOrdered() {
        int i;
        Object docIds;
        ValueBlock valueBlock;
        int numExpressions = this._expressions.size();
        int numOrderByExpressions = this._orderByExpressions.size();
        BlockValSet[] blockValSets = new BlockValSet[numOrderByExpressions];
        int numColumnsProjected = this._projectOperator.getNumColumnsProjected();
        while ((valueBlock = (ValueBlock)this._projectOperator.nextBlock()) != null) {
            for (int i2 = 0; i2 < numOrderByExpressions; ++i2) {
                ExpressionContext expression = this._orderByExpressions.get(i2).getExpression();
                blockValSets[i2] = valueBlock.getBlockValueSet(expression);
            }
            RowBasedBlockValueFetcher blockValueFetcher = new RowBasedBlockValueFetcher(blockValSets);
            int numDocsFetched = valueBlock.getNumDocs();
            docIds = valueBlock.getDocIds();
            if (this._nullHandlingEnabled) {
                RoaringBitmap[] nullBitmaps = new RoaringBitmap[numOrderByExpressions];
                for (int i3 = 0; i3 < numOrderByExpressions; ++i3) {
                    nullBitmaps[i3] = blockValSets[i3].getNullBitmap();
                }
                for (int rowId = 0; rowId < numDocsFetched; ++rowId) {
                    Object[] row = new Object[numExpressions];
                    blockValueFetcher.getRow(rowId, row, 0);
                    row[numOrderByExpressions] = docIds[rowId];
                    for (int colId = 0; colId < numOrderByExpressions; ++colId) {
                        if (nullBitmaps[colId] == null || !nullBitmaps[colId].contains(rowId)) continue;
                        row[colId] = null;
                    }
                    SelectionOperatorUtils.addToPriorityQueue(row, this._rows, this._numRowsToKeep);
                }
            } else {
                for (int i4 = 0; i4 < numDocsFetched; ++i4) {
                    Object[] row = new Object[numExpressions];
                    blockValueFetcher.getRow(i4, row, 0);
                    row[numOrderByExpressions] = docIds[i4];
                    SelectionOperatorUtils.addToPriorityQueue(row, this._rows, this._numRowsToKeep);
                }
            }
            this._numDocsScanned += numDocsFetched;
        }
        this._numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)numColumnsProjected;
        int numRows = this._rows.size();
        ArrayList<Object[]> rowList = new ArrayList<Object[]>(numRows);
        docIds = new RoaringBitmap();
        for (Object[] row : this._rows) {
            rowList.add(row);
            int docId = (Integer)row[numOrderByExpressions];
            docIds.add(docId);
        }
        rowList.sort(Comparator.comparingInt(o -> (Integer)o[numOrderByExpressions]));
        List<ExpressionContext> nonOrderByExpressions = this._expressions.subList(numOrderByExpressions, numExpressions);
        HashSet columns = new HashSet();
        for (ExpressionContext expressionContext : nonOrderByExpressions) {
            expressionContext.getColumns(columns);
        }
        int numColumns = columns.size();
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        for (String column : columns) {
            dataSourceMap.put(column, this._indexSegment.getDataSource(column));
        }
        ProjectionOperator projectionOperator = ProjectionOperatorUtils.getProjectionOperator(dataSourceMap, new BitmapDocIdSetOperator((ImmutableBitmapDataProvider)docIds, numRows));
        TransformOperator transformOperator = new TransformOperator(this._queryContext, projectionOperator, nonOrderByExpressions);
        int numNonOrderByExpressions = nonOrderByExpressions.size();
        blockValSets = new BlockValSet[numNonOrderByExpressions];
        int rowBaseId = 0;
        while ((valueBlock = (ValueBlock)transformOperator.nextBlock()) != null) {
            for (int i5 = 0; i5 < numNonOrderByExpressions; ++i5) {
                ExpressionContext expression = nonOrderByExpressions.get(i5);
                blockValSets[i5] = valueBlock.getBlockValueSet(expression);
            }
            RowBasedBlockValueFetcher blockValueFetcher = new RowBasedBlockValueFetcher(blockValSets);
            int numDocsFetched = valueBlock.getNumDocs();
            for (i = 0; i < numDocsFetched; ++i) {
                blockValueFetcher.getRow(i, (Object[])rowList.get(rowBaseId + i), numOrderByExpressions);
            }
            if (this._nullHandlingEnabled) {
                int i6;
                RoaringBitmap[] nullBitmaps = new RoaringBitmap[numNonOrderByExpressions];
                for (i6 = 0; i6 < numNonOrderByExpressions; ++i6) {
                    nullBitmaps[i6] = blockValSets[i6].getNullBitmap();
                }
                for (i6 = 0; i6 < numDocsFetched; ++i6) {
                    Object[] values = (Object[])rowList.get(rowBaseId + i6);
                    for (int colId = 0; colId < numNonOrderByExpressions; ++colId) {
                        if (nullBitmaps[colId] == null || !nullBitmaps[colId].contains(i6)) continue;
                        int valueColId = numOrderByExpressions + colId;
                        values[valueColId] = null;
                    }
                }
            }
            this._numEntriesScannedPostFilter += (long)numDocsFetched * (long)numColumns;
            rowBaseId += numDocsFetched;
        }
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (i = 0; i < numExpressions; ++i) {
            columnNames[i] = this._expressions.get(i).toString();
        }
        for (i = 0; i < numOrderByExpressions; ++i) {
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)this._orderByColumnContexts[i].getDataType(), (boolean)this._orderByColumnContexts[i].isSingleValue());
        }
        for (i = 0; i < numNonOrderByExpressions; ++i) {
            ColumnContext columnContext = transformOperator.getResultColumnContext(nonOrderByExpressions.get(i));
            columnDataTypes[numOrderByExpressions + i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)columnContext.getDataType(), (boolean)columnContext.isSingleValue());
        }
        DataSchema dataSchema = new DataSchema(columnNames, columnDataTypes);
        return new SelectionResultsBlock(dataSchema, this.getSortedRows(), this._comparator, this._queryContext);
    }

    private List<Object[]> getSortedRows() {
        int numRows = this._rows.size();
        Object[][] sortedRows = new Object[numRows][];
        for (int i = numRows - 1; i >= 0; --i) {
            sortedRows[i] = this._rows.poll();
        }
        return Arrays.asList(sortedRows);
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._projectOperator);
    }

    @Override
    public IndexSegment getIndexSegment() {
        return this._indexSegment;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._projectOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, this._numEntriesScannedPostFilter, numTotalDocs);
    }
}

