/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.query.LinearSelectionOrderByOperator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;

public class SelectionPartiallyOrderedByAscOperator
extends LinearSelectionOrderByOperator {
    private static final String EXPLAIN_NAME = "SELECT_PARTIAL_ORDER_BY_ASC";
    private int _numDocsScanned = 0;

    public SelectionPartiallyOrderedByAscOperator(IndexSegment indexSegment, QueryContext queryContext, List<ExpressionContext> expressions, BaseProjectOperator<?> projectOperator, int numSortedExpressions) {
        super(indexSegment, queryContext, expressions, projectOperator, numSortedExpressions);
        Preconditions.checkArgument((boolean)queryContext.getOrderByExpressions().stream().filter(expr -> expr.getExpression().getType() == ExpressionContext.Type.IDENTIFIER).findFirst().orElseThrow(() -> new IllegalArgumentException("The query is not order by identifiers")).isAsc(), (String)"%s can only be used when the first column in order by is ASC", (Object)EXPLAIN_NAME);
    }

    @Override
    protected List<Object[]> fetch(Supplier<LinearSelectionOrderByOperator.ListBuilder> listBuilderSupplier) {
        ValueBlock valueBlock;
        int numExpressions = this._expressions.size();
        BlockValSet[] blockValSets = new BlockValSet[numExpressions];
        LinearSelectionOrderByOperator.ListBuilder listBuilder = listBuilderSupplier.get();
        while ((valueBlock = (ValueBlock)this._projectOperator.nextBlock()) != null) {
            IntFunction<Object[]> rowFetcher = this.fetchBlock(valueBlock, blockValSets);
            int numDocsFetched = valueBlock.getNumDocs();
            this._numDocsScanned += numDocsFetched;
            for (int i = 0; i < numDocsFetched; ++i) {
                if (!listBuilder.add(rowFetcher.apply(i))) continue;
                return listBuilder.build();
            }
        }
        return listBuilder.build();
    }

    @Override
    public int getNumDocsScanned() {
        return this._numDocsScanned;
    }

    @Override
    protected String getExplainName() {
        return EXPLAIN_NAME;
    }
}

