/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.streaming;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.AcquireReleaseColumnsSegmentOperator;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.blocks.results.ExceptionResultsBlock;
import org.apache.pinot.core.operator.blocks.results.MetadataResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.operator.combine.CombineOperatorUtils;
import org.apache.pinot.core.operator.combine.merger.ResultsBlockMerger;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStreamingCombineOperator<T extends BaseResultsBlock>
extends BaseCombineOperator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseStreamingCombineOperator.class);
    public static final MetadataResultsBlock LAST_RESULTS_BLOCK = new MetadataResultsBlock();
    protected final BlockingQueue<BaseResultsBlock> _blockingQueue;
    protected final Object _querySatisfiedTracker;
    protected boolean _querySatisfied;
    protected int _numOperatorsFinished;

    public BaseStreamingCombineOperator(ResultsBlockMerger<T> resultsBlockMerger, List<Operator> operators, QueryContext queryContext, ExecutorService executorService) {
        super(resultsBlockMerger, operators, queryContext, executorService);
        Integer maxStreamingPendingBlocks = QueryOptionsUtils.getMaxStreamingPendingBlocks(queryContext.getQueryOptions());
        this._blockingQueue = new ArrayBlockingQueue<BaseResultsBlock>(maxStreamingPendingBlocks != null ? maxStreamingPendingBlocks : 100);
        this._querySatisfiedTracker = this.createQuerySatisfiedTracker();
    }

    @Override
    protected BaseResultsBlock getNextBlock() {
        long endTimeMs = this._queryContext.getEndTimeMs();
        while (!this._querySatisfied && this._numOperatorsFinished < this._numOperators) {
            try {
                BaseResultsBlock resultsBlock = this._blockingQueue.poll(endTimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                if (resultsBlock == null) {
                    LOGGER.error("Timed out while polling results block (query: {})", (Object)this._queryContext);
                    return new ExceptionResultsBlock((Throwable)QueryException.getException((ProcessingException)QueryException.EXECUTION_TIMEOUT_ERROR, (Throwable)new TimeoutException("Timed out while polling results block")));
                }
                if (resultsBlock.getProcessingExceptions() != null) {
                    return resultsBlock;
                }
                if (resultsBlock == LAST_RESULTS_BLOCK) {
                    ++this._numOperatorsFinished;
                    continue;
                }
                this._querySatisfied = this.isQuerySatisfied(resultsBlock, this._querySatisfiedTracker);
                return resultsBlock;
            }
            catch (InterruptedException e) {
                throw new EarlyTerminationException("Interrupted while streaming results blocks", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while streaming results blocks (query: {})", (Object)this._queryContext, (Object)e);
                return new ExceptionResultsBlock((Throwable)QueryException.getException((ProcessingException)QueryException.INTERNAL_ERROR, (Throwable)e));
            }
        }
        MetadataResultsBlock finalBlock = new MetadataResultsBlock();
        int numServerThreads = Math.min(this._numTasks, ResourceManager.DEFAULT_QUERY_WORKER_THREADS);
        CombineOperatorUtils.setExecutionStatistics(finalBlock, this._operators, this._totalWorkerThreadCpuTimeNs.get(), numServerThreads);
        return finalBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processSegments() {
        int operatorId;
        Object tracker = this.createQuerySatisfiedTracker();
        while (this._processingException.get() == null && (operatorId = this._nextOperatorId.getAndIncrement()) < this._numOperators) {
            Operator operator = (Operator)this._operators.get(operatorId);
            try {
                BaseResultsBlock resultsBlock;
                if (operator instanceof AcquireReleaseColumnsSegmentOperator) {
                    ((AcquireReleaseColumnsSegmentOperator)operator).acquire();
                }
                if (this.isChildOperatorSingleBlock()) {
                    resultsBlock = (BaseResultsBlock)operator.nextBlock();
                    this.addResultsBlock(resultsBlock);
                    if (this.isQuerySatisfied(resultsBlock, tracker)) {
                        this._nextOperatorId.set(this._numOperators);
                        return;
                    }
                } else {
                    while ((resultsBlock = (BaseResultsBlock)operator.nextBlock()) != null) {
                        this.addResultsBlock(resultsBlock);
                        if (!this.isQuerySatisfied(resultsBlock, tracker)) continue;
                        this._nextOperatorId.set(this._numOperators);
                        return;
                    }
                }
            }
            finally {
                if (operator instanceof AcquireReleaseColumnsSegmentOperator) {
                    ((AcquireReleaseColumnsSegmentOperator)operator).release();
                }
            }
            this.addResultsBlock(LAST_RESULTS_BLOCK);
        }
    }

    private void addResultsBlock(BaseResultsBlock resultsBlock) {
        try {
            if (!this._blockingQueue.offer(resultsBlock, this._queryContext.getEndTimeMs() - System.currentTimeMillis(), TimeUnit.MILLISECONDS)) {
                throw new EarlyTerminationException("Timed out waiting to add results block");
            }
        }
        catch (InterruptedException e) {
            throw new EarlyTerminationException("Interrupted waiting to add results block");
        }
    }

    @Override
    protected void onProcessSegmentsException(Throwable t) {
        this._processingException.compareAndSet(null, t);
        this._blockingQueue.clear();
        this._blockingQueue.offer(new ExceptionResultsBlock(t));
    }

    @Override
    protected void onProcessSegmentsFinish() {
    }

    protected boolean isChildOperatorSingleBlock() {
        return true;
    }

    protected Object createQuerySatisfiedTracker() {
        return null;
    }

    protected boolean isQuerySatisfied(T resultsBlock, Object tracker) {
        return this._resultsBlockMerger.isQuerySatisfied(resultsBlock);
    }

    public void start() {
        this.startProcess();
    }

    public void stop() {
        this.stopProcess();
    }
}

