/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.streaming;

import java.util.List;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.core.operator.InstanceResponseOperator;
import org.apache.pinot.core.operator.blocks.InstanceResponseBlock;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.blocks.results.ExceptionResultsBlock;
import org.apache.pinot.core.operator.blocks.results.MetadataResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.operator.streaming.BaseStreamingCombineOperator;
import org.apache.pinot.core.query.executor.ResultsBlockStreamer;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.FetchContext;
import org.apache.pinot.segment.spi.SegmentContext;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.apache.pinot.spi.exception.QueryCancelledException;
import org.apache.pinot.spi.trace.Tracing;

public class StreamingInstanceResponseOperator
extends InstanceResponseOperator {
    private static final String EXPLAIN_NAME = "STREAMING_INSTANCE_RESPONSE";
    private final BaseStreamingCombineOperator<?> _streamingCombineOperator;
    private final ResultsBlockStreamer _streamer;

    public StreamingInstanceResponseOperator(BaseCombineOperator<?> combinedOperator, List<SegmentContext> segmentContexts, List<FetchContext> fetchContexts, ResultsBlockStreamer streamer, QueryContext queryContext) {
        super(combinedOperator, segmentContexts, fetchContexts, queryContext);
        this._streamingCombineOperator = combinedOperator instanceof BaseStreamingCombineOperator ? (BaseStreamingCombineOperator)combinedOperator : null;
        this._streamer = streamer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InstanceResponseBlock getNextBlock() {
        try {
            BaseResultsBlock resultsBlock;
            this.prefetchAll();
            if (this._streamingCombineOperator != null) {
                this._streamingCombineOperator.start();
                resultsBlock = this.getBaseBlock();
                while (!(resultsBlock instanceof MetadataResultsBlock)) {
                    if (resultsBlock instanceof ExceptionResultsBlock) {
                        InstanceResponseBlock instanceResponseBlock = new InstanceResponseBlock(resultsBlock);
                        return instanceResponseBlock;
                    }
                    if (resultsBlock.getNumRows() > 0) {
                        this._streamer.send(resultsBlock);
                    }
                    resultsBlock = this.getBaseBlock();
                }
                InstanceResponseBlock instanceResponseBlock = this.buildInstanceResponseBlock(resultsBlock);
                return instanceResponseBlock;
            }
            resultsBlock = this.getBaseBlock();
            if (resultsBlock instanceof ExceptionResultsBlock) {
                InstanceResponseBlock instanceResponseBlock = new InstanceResponseBlock(resultsBlock);
                return instanceResponseBlock;
            }
            if (resultsBlock.getNumRows() > 0) {
                this._streamer.send(resultsBlock);
            }
            InstanceResponseBlock instanceResponseBlock = this.buildInstanceResponseBlock(resultsBlock).toMetadataOnlyResponseBlock();
            return instanceResponseBlock;
        }
        catch (EarlyTerminationException e) {
            Exception killedErrorMsg = Tracing.getThreadAccountant().getErrorStatus();
            InstanceResponseBlock instanceResponseBlock = new InstanceResponseBlock(new ExceptionResultsBlock(new QueryCancelledException("Cancelled while streaming results" + (String)(killedErrorMsg == null ? "" : " " + killedErrorMsg), (Throwable)e)));
            return instanceResponseBlock;
        }
        catch (Exception e) {
            InstanceResponseBlock instanceResponseBlock = new InstanceResponseBlock(new ExceptionResultsBlock(QueryException.INTERNAL_ERROR, e));
            return instanceResponseBlock;
        }
        finally {
            if (this._streamingCombineOperator != null) {
                this._streamingCombineOperator.stop();
            }
            this.releaseAll();
        }
    }

    @Override
    protected BaseResultsBlock getCombinedResults() {
        return (BaseResultsBlock)this._combineOperator.nextBlock();
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }
}

