/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.streaming;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.operator.combine.merger.SelectionOnlyResultsBlockMerger;
import org.apache.pinot.core.operator.streaming.BaseStreamingCombineOperator;
import org.apache.pinot.core.query.request.context.QueryContext;

public class StreamingSelectionOnlyCombineOperator
extends BaseStreamingCombineOperator<SelectionResultsBlock> {
    private static final String EXPLAIN_NAME = "STREAMING_COMBINE_SELECT";
    private final int _limit;

    public StreamingSelectionOnlyCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService) {
        super(new SelectionOnlyResultsBlockMerger(queryContext), operators, queryContext, executorService);
        this._limit = queryContext.getLimit();
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    protected boolean isChildOperatorSingleBlock() {
        return false;
    }

    @Override
    protected Object createQuerySatisfiedTracker() {
        return new AtomicLong();
    }

    @Override
    protected boolean isQuerySatisfied(SelectionResultsBlock resultsBlock, Object tracker) {
        return ((AtomicLong)tracker).addAndGet(resultsBlock.getNumRows()) >= (long)this._limit;
    }
}

