/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunctionFactory;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.spi.trace.Tracing;

public class TransformOperator
extends BaseProjectOperator<TransformBlock> {
    private static final String EXPLAIN_NAME = "TRANSFORM";
    private final BaseProjectOperator<?> _projectOperator;
    private final Map<ExpressionContext, TransformFunction> _transformFunctionMap;

    public TransformOperator(QueryContext queryContext, BaseProjectOperator<?> projectOperator, Collection<ExpressionContext> expressions) {
        this._projectOperator = projectOperator;
        this._transformFunctionMap = new HashMap<ExpressionContext, TransformFunction>(HashUtil.getHashMapCapacity((int)expressions.size()));
        for (ExpressionContext expression : expressions) {
            TransformFunction transformFunction = TransformFunctionFactory.get(expression, projectOperator.getSourceColumnContextMap(), queryContext);
            this._transformFunctionMap.put(expression, transformFunction);
        }
    }

    @Override
    public Map<String, ColumnContext> getSourceColumnContextMap() {
        return this._projectOperator.getSourceColumnContextMap();
    }

    @Override
    public ColumnContext getResultColumnContext(ExpressionContext expression) {
        return ColumnContext.fromTransformFunction(this._transformFunctionMap.get(expression));
    }

    @Override
    protected TransformBlock getNextBlock() {
        ValueBlock sourceBlock = (ValueBlock)this._projectOperator.nextBlock();
        if (sourceBlock == null) {
            return null;
        }
        Tracing.activeRecording().setNumChildren(this._transformFunctionMap.size());
        return new TransformBlock(sourceBlock, this._transformFunctionMap);
    }

    @Override
    public String toExplainString() {
        List expressions = this._transformFunctionMap.keySet().stream().map(ExpressionContext::toString).sorted().collect(Collectors.toList());
        return this.getExplainName() + "(" + StringUtils.join(expressions, (String)", ") + ")";
    }

    protected String getExplainName() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<BaseProjectOperator<?>> getChildOperators() {
        return Collections.singletonList(this._projectOperator);
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._projectOperator.getExecutionStatistics();
    }
}

