/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;

public class ArrayLengthTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "arrayLength";
    private TransformFunction _argument;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Exactly 1 argument is required for ARRAYLENGTH transform function");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The argument of ARRAYLENGTH transform function must be a multi-valued column or a transform function");
        }
        this._argument = firstArgument;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return INT_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initIntValuesSV(length);
        switch (this._argument.getResultMetadata().getDataType().getStoredType()) {
            case INT: {
                int[][] intValuesMV = this._argument.transformToIntValuesMV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    this._intValuesSV[i] = intValuesMV[i].length;
                }
                break;
            }
            case LONG: {
                long[][] longValuesMV = this._argument.transformToLongValuesMV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    this._intValuesSV[i] = longValuesMV[i].length;
                }
                break;
            }
            case FLOAT: {
                float[][] floatValuesMV = this._argument.transformToFloatValuesMV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    this._intValuesSV[i] = floatValuesMV[i].length;
                }
                break;
            }
            case DOUBLE: {
                double[][] doubleValuesMV = this._argument.transformToDoubleValuesMV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    this._intValuesSV[i] = doubleValuesMV[i].length;
                }
                break;
            }
            case STRING: {
                String[][] stringValuesMV = this._argument.transformToStringValuesMV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    this._intValuesSV[i] = stringValuesMV[i].length;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._intValuesSV;
    }
}

