/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.LiteralContext;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class ArrayLiteralTransformFunction
implements TransformFunction {
    public static final String FUNCTION_NAME = "arrayValueConstructor";
    private final FieldSpec.DataType _dataType;
    private final int[] _intArrayLiteral;
    private final long[] _longArrayLiteral;
    private final float[] _floatArrayLiteral;
    private final double[] _doubleArrayLiteral;
    private final String[] _stringArrayLiteral;
    private int[][] _intArrayResult;
    private long[][] _longArrayResult;
    private float[][] _floatArrayResult;
    private double[][] _doubleArrayResult;
    private String[][] _stringArrayResult;

    public ArrayLiteralTransformFunction(LiteralContext literalContext) {
        this._dataType = literalContext.getType();
        Object value = literalContext.getValue();
        if (value == null) {
            this._intArrayLiteral = new int[0];
            this._longArrayLiteral = new long[0];
            this._floatArrayLiteral = new float[0];
            this._doubleArrayLiteral = new double[0];
            this._stringArrayLiteral = new String[0];
            return;
        }
        switch (this._dataType) {
            case INT: {
                this._intArrayLiteral = (int[])value;
                this._longArrayLiteral = null;
                this._floatArrayLiteral = null;
                this._doubleArrayLiteral = null;
                this._stringArrayLiteral = null;
                break;
            }
            case LONG: {
                this._longArrayLiteral = (long[])value;
                this._intArrayLiteral = null;
                this._floatArrayLiteral = null;
                this._doubleArrayLiteral = null;
                this._stringArrayLiteral = null;
                break;
            }
            case FLOAT: {
                this._floatArrayLiteral = (float[])value;
                this._intArrayLiteral = null;
                this._longArrayLiteral = null;
                this._doubleArrayLiteral = null;
                this._stringArrayLiteral = null;
                break;
            }
            case DOUBLE: {
                this._doubleArrayLiteral = (double[])value;
                this._intArrayLiteral = null;
                this._longArrayLiteral = null;
                this._floatArrayLiteral = null;
                this._stringArrayLiteral = null;
                break;
            }
            case STRING: {
                this._stringArrayLiteral = (String[])value;
                this._intArrayLiteral = null;
                this._longArrayLiteral = null;
                this._floatArrayLiteral = null;
                this._doubleArrayLiteral = null;
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for ArrayLiteralTransformFunction: " + this._dataType + ", literal context: " + literalContext);
            }
        }
    }

    public ArrayLiteralTransformFunction(List<ExpressionContext> literalContexts) {
        Preconditions.checkNotNull(literalContexts);
        if (literalContexts.isEmpty()) {
            this._dataType = FieldSpec.DataType.UNKNOWN;
            this._intArrayLiteral = new int[0];
            this._longArrayLiteral = new long[0];
            this._floatArrayLiteral = new float[0];
            this._doubleArrayLiteral = new double[0];
            this._stringArrayLiteral = new String[0];
            return;
        }
        for (ExpressionContext literalContext : literalContexts) {
            Preconditions.checkState((literalContext.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (String)"ArrayLiteralTransformFunction only takes literals as arguments, found: %s", (Object)literalContext);
        }
        this._dataType = literalContexts.get(0).getLiteral().getType();
        switch (this._dataType) {
            case INT: {
                this._intArrayLiteral = new int[literalContexts.size()];
                for (int i = 0; i < this._intArrayLiteral.length; ++i) {
                    this._intArrayLiteral[i] = literalContexts.get(i).getLiteral().getIntValue();
                }
                this._longArrayLiteral = null;
                this._floatArrayLiteral = null;
                this._doubleArrayLiteral = null;
                this._stringArrayLiteral = null;
                break;
            }
            case LONG: {
                this._longArrayLiteral = new long[literalContexts.size()];
                for (int i = 0; i < this._longArrayLiteral.length; ++i) {
                    this._longArrayLiteral[i] = literalContexts.get(i).getLiteral().getLongValue();
                }
                this._intArrayLiteral = null;
                this._floatArrayLiteral = null;
                this._doubleArrayLiteral = null;
                this._stringArrayLiteral = null;
                break;
            }
            case FLOAT: {
                this._floatArrayLiteral = new float[literalContexts.size()];
                for (int i = 0; i < this._floatArrayLiteral.length; ++i) {
                    this._floatArrayLiteral[i] = literalContexts.get(i).getLiteral().getFloatValue();
                }
                this._intArrayLiteral = null;
                this._longArrayLiteral = null;
                this._doubleArrayLiteral = null;
                this._stringArrayLiteral = null;
                break;
            }
            case DOUBLE: {
                this._doubleArrayLiteral = new double[literalContexts.size()];
                for (int i = 0; i < this._doubleArrayLiteral.length; ++i) {
                    this._doubleArrayLiteral[i] = literalContexts.get(i).getLiteral().getDoubleValue();
                }
                this._intArrayLiteral = null;
                this._longArrayLiteral = null;
                this._floatArrayLiteral = null;
                this._stringArrayLiteral = null;
                break;
            }
            case STRING: {
                this._stringArrayLiteral = new String[literalContexts.size()];
                for (int i = 0; i < this._stringArrayLiteral.length; ++i) {
                    this._stringArrayLiteral[i] = literalContexts.get(i).getLiteral().getStringValue();
                }
                this._intArrayLiteral = null;
                this._longArrayLiteral = null;
                this._floatArrayLiteral = null;
                this._doubleArrayLiteral = null;
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for ArrayLiteralTransformFunction: " + this._dataType + ", literal contexts: " + Arrays.toString(literalContexts.toArray()));
            }
        }
    }

    public int[] getIntArrayLiteral() {
        return this._intArrayLiteral;
    }

    public long[] getLongArrayLiteral() {
        return this._longArrayLiteral;
    }

    public float[] getFloatArrayLiteral() {
        return this._floatArrayLiteral;
    }

    public double[] getDoubleArrayLiteral() {
        return this._doubleArrayLiteral;
    }

    public String[] getStringArrayLiteral() {
        return this._stringArrayLiteral;
    }

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return new TransformResultMetadata(this._dataType, false, false);
    }

    @Override
    public Dictionary getDictionary() {
        return null;
    }

    @Override
    public int[] transformToDictIdsSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] transformToDictIdsMV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[] transformToFloatValuesSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[][] transformToBytesValuesSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] transformToIntValuesMV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        Object intArrayResult = this._intArrayResult;
        if (intArrayResult == null || ((int[][])intArrayResult).length < numDocs) {
            intArrayResult = new int[numDocs][];
            int[] intArrayLiteral = this._intArrayLiteral;
            if (intArrayLiteral == null) {
                switch (this._dataType) {
                    case LONG: {
                        intArrayLiteral = new int[this._longArrayLiteral.length];
                        for (int i = 0; i < this._longArrayLiteral.length; ++i) {
                            intArrayLiteral[i] = (int)this._longArrayLiteral[i];
                        }
                        break;
                    }
                    case FLOAT: {
                        intArrayLiteral = new int[this._floatArrayLiteral.length];
                        for (int i = 0; i < this._floatArrayLiteral.length; ++i) {
                            intArrayLiteral[i] = (int)this._floatArrayLiteral[i];
                        }
                        break;
                    }
                    case DOUBLE: {
                        intArrayLiteral = new int[this._doubleArrayLiteral.length];
                        for (int i = 0; i < this._doubleArrayLiteral.length; ++i) {
                            intArrayLiteral[i] = (int)this._doubleArrayLiteral[i];
                        }
                        break;
                    }
                    case STRING: {
                        intArrayLiteral = new int[this._stringArrayLiteral.length];
                        for (int i = 0; i < this._stringArrayLiteral.length; ++i) {
                            intArrayLiteral[i] = Integer.parseInt(this._stringArrayLiteral[i]);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unable to convert data type: " + this._dataType + " to int array");
                    }
                }
            }
            Arrays.fill((Object[])intArrayResult, intArrayLiteral);
            this._intArrayResult = intArrayResult;
        }
        return intArrayResult;
    }

    @Override
    public long[][] transformToLongValuesMV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        Object longArrayResult = this._longArrayResult;
        if (longArrayResult == null || ((long[][])longArrayResult).length < numDocs) {
            longArrayResult = new long[numDocs][];
            long[] longArrayLiteral = this._longArrayLiteral;
            if (longArrayLiteral == null) {
                switch (this._dataType) {
                    case INT: {
                        longArrayLiteral = new long[this._intArrayLiteral.length];
                        for (int i = 0; i < this._intArrayLiteral.length; ++i) {
                            longArrayLiteral[i] = this._intArrayLiteral[i];
                        }
                        break;
                    }
                    case FLOAT: {
                        longArrayLiteral = new long[this._floatArrayLiteral.length];
                        for (int i = 0; i < this._floatArrayLiteral.length; ++i) {
                            longArrayLiteral[i] = (long)this._floatArrayLiteral[i];
                        }
                        break;
                    }
                    case DOUBLE: {
                        longArrayLiteral = new long[this._doubleArrayLiteral.length];
                        for (int i = 0; i < this._doubleArrayLiteral.length; ++i) {
                            longArrayLiteral[i] = (long)this._doubleArrayLiteral[i];
                        }
                        break;
                    }
                    case STRING: {
                        longArrayLiteral = new long[this._stringArrayLiteral.length];
                        for (int i = 0; i < this._stringArrayLiteral.length; ++i) {
                            longArrayLiteral[i] = Long.parseLong(this._stringArrayLiteral[i]);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unable to convert data type: " + this._dataType + " to long array");
                    }
                }
            }
            Arrays.fill((Object[])longArrayResult, longArrayLiteral);
            this._longArrayResult = longArrayResult;
        }
        return longArrayResult;
    }

    @Override
    public float[][] transformToFloatValuesMV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        Object floatArrayResult = this._floatArrayResult;
        if (floatArrayResult == null || ((float[][])floatArrayResult).length < numDocs) {
            floatArrayResult = new float[numDocs][];
            float[] floatArrayLiteral = this._floatArrayLiteral;
            if (floatArrayLiteral == null) {
                switch (this._dataType) {
                    case INT: {
                        floatArrayLiteral = new float[this._intArrayLiteral.length];
                        for (int i = 0; i < this._intArrayLiteral.length; ++i) {
                            floatArrayLiteral[i] = this._intArrayLiteral[i];
                        }
                        break;
                    }
                    case LONG: {
                        floatArrayLiteral = new float[this._longArrayLiteral.length];
                        for (int i = 0; i < this._longArrayLiteral.length; ++i) {
                            floatArrayLiteral[i] = this._longArrayLiteral[i];
                        }
                        break;
                    }
                    case DOUBLE: {
                        floatArrayLiteral = new float[this._doubleArrayLiteral.length];
                        for (int i = 0; i < this._doubleArrayLiteral.length; ++i) {
                            floatArrayLiteral[i] = (float)this._doubleArrayLiteral[i];
                        }
                        break;
                    }
                    case STRING: {
                        floatArrayLiteral = new float[this._stringArrayLiteral.length];
                        for (int i = 0; i < this._stringArrayLiteral.length; ++i) {
                            floatArrayLiteral[i] = Float.parseFloat(this._stringArrayLiteral[i]);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unable to convert data type: " + this._dataType + " to float array");
                    }
                }
            }
            Arrays.fill((Object[])floatArrayResult, floatArrayLiteral);
            this._floatArrayResult = floatArrayResult;
        }
        return floatArrayResult;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        Object doubleArrayResult = this._doubleArrayResult;
        if (doubleArrayResult == null || ((double[][])doubleArrayResult).length < numDocs) {
            doubleArrayResult = new double[numDocs][];
            double[] doubleArrayLiteral = this._doubleArrayLiteral;
            if (doubleArrayLiteral == null) {
                switch (this._dataType) {
                    case INT: {
                        doubleArrayLiteral = new double[this._intArrayLiteral.length];
                        for (int i = 0; i < this._intArrayLiteral.length; ++i) {
                            doubleArrayLiteral[i] = this._intArrayLiteral[i];
                        }
                        break;
                    }
                    case LONG: {
                        doubleArrayLiteral = new double[this._longArrayLiteral.length];
                        for (int i = 0; i < this._longArrayLiteral.length; ++i) {
                            doubleArrayLiteral[i] = this._longArrayLiteral[i];
                        }
                        break;
                    }
                    case FLOAT: {
                        doubleArrayLiteral = new double[this._floatArrayLiteral.length];
                        for (int i = 0; i < this._floatArrayLiteral.length; ++i) {
                            doubleArrayLiteral[i] = this._floatArrayLiteral[i];
                        }
                        break;
                    }
                    case STRING: {
                        doubleArrayLiteral = new double[this._stringArrayLiteral.length];
                        for (int i = 0; i < this._stringArrayLiteral.length; ++i) {
                            doubleArrayLiteral[i] = Double.parseDouble(this._stringArrayLiteral[i]);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unable to convert data type: " + this._dataType + " to double array");
                    }
                }
            }
            Arrays.fill((Object[])doubleArrayResult, doubleArrayLiteral);
            this._doubleArrayResult = doubleArrayResult;
        }
        return doubleArrayResult;
    }

    @Override
    public String[][] transformToStringValuesMV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        String[][] stringArrayResult = this._stringArrayResult;
        if (stringArrayResult == null || stringArrayResult.length < numDocs) {
            stringArrayResult = new String[numDocs][];
            String[] stringArrayLiteral = this._stringArrayLiteral;
            if (stringArrayLiteral == null) {
                switch (this._dataType) {
                    case INT: {
                        stringArrayLiteral = new String[this._intArrayLiteral.length];
                        for (int i = 0; i < this._intArrayLiteral.length; ++i) {
                            stringArrayLiteral[i] = Integer.toString(this._intArrayLiteral[i]);
                        }
                        break;
                    }
                    case LONG: {
                        stringArrayLiteral = new String[this._longArrayLiteral.length];
                        for (int i = 0; i < this._longArrayLiteral.length; ++i) {
                            stringArrayLiteral[i] = Long.toString(this._longArrayLiteral[i]);
                        }
                        break;
                    }
                    case FLOAT: {
                        stringArrayLiteral = new String[this._floatArrayLiteral.length];
                        for (int i = 0; i < this._floatArrayLiteral.length; ++i) {
                            stringArrayLiteral[i] = Float.toString(this._floatArrayLiteral[i]);
                        }
                        break;
                    }
                    case DOUBLE: {
                        stringArrayLiteral = new String[this._doubleArrayLiteral.length];
                        for (int i = 0; i < this._doubleArrayLiteral.length; ++i) {
                            stringArrayLiteral[i] = Double.toString(this._doubleArrayLiteral[i]);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unable to convert data type: " + this._dataType + " to string array");
                    }
                }
            }
            Arrays.fill((Object[])stringArrayResult, stringArrayLiteral);
            this._stringArrayResult = stringArrayResult;
        }
        return stringArrayResult;
    }

    @Override
    public byte[][][] transformToBytesValuesMV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RoaringBitmap getNullBitmap(ValueBlock valueBlock) {
        if (this._dataType != FieldSpec.DataType.UNKNOWN) {
            return null;
        }
        int length = valueBlock.getNumDocs();
        RoaringBitmap bitmap = new RoaringBitmap();
        bitmap.add(0L, (long)length);
        return bitmap;
    }
}

