/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.spi.data.FieldSpec;

public class ArrayMaxTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "arrayMax";
    private TransformFunction _argument;
    private TransformResultMetadata _resultMetadata;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Exactly 1 argument is required for ArrayMax transform function");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The argument of ArrayMax transform function must be a multi-valued column or a transform function");
        }
        this._resultMetadata = new TransformResultMetadata(firstArgument.getResultMetadata().getDataType(), true, false);
        this._argument = firstArgument;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        if (this._argument.getResultMetadata().getDataType().getStoredType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesSV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initIntValuesSV(length);
        int[][] intValuesMV = this._argument.transformToIntValuesMV(valueBlock);
        for (int i = 0; i < length; ++i) {
            int maxRes = Integer.MIN_VALUE;
            for (int value : intValuesMV[i]) {
                maxRes = Math.max(maxRes, value);
            }
            this._intValuesSV[i] = maxRes;
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        if (this._argument.getResultMetadata().getDataType().getStoredType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesSV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initLongValuesSV(length);
        long[][] longValuesMV = this._argument.transformToLongValuesMV(valueBlock);
        for (int i = 0; i < length; ++i) {
            long maxRes = Long.MIN_VALUE;
            for (long value : longValuesMV[i]) {
                maxRes = Math.max(maxRes, value);
            }
            this._longValuesSV[i] = maxRes;
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ValueBlock valueBlock) {
        if (this._argument.getResultMetadata().getDataType().getStoredType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesSV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initFloatValuesSV(length);
        float[][] floatValuesMV = this._argument.transformToFloatValuesMV(valueBlock);
        for (int i = 0; i < length; ++i) {
            float maxRes = Float.NEGATIVE_INFINITY;
            for (float value : floatValuesMV[i]) {
                maxRes = Math.max(maxRes, value);
            }
            this._floatValuesSV[i] = maxRes;
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        if (this._argument.getResultMetadata().getDataType().getStoredType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesSV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initDoubleValuesSV(length);
        double[][] doubleValuesMV = this._argument.transformToDoubleValuesMV(valueBlock);
        for (int i = 0; i < length; ++i) {
            double maxRes = Double.NEGATIVE_INFINITY;
            for (double value : doubleValuesMV[i]) {
                maxRes = Math.max(maxRes, value);
            }
            this._doubleValuesSV[i] = maxRes;
        }
        return this._doubleValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        if (this._argument.getResultMetadata().getDataType().getStoredType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesSV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initStringValuesSV(length);
        String[][] stringValuesMV = this._argument.transformToStringValuesMV(valueBlock);
        for (int i = 0; i < length; ++i) {
            String maxRes = null;
            for (String value : stringValuesMV[i]) {
                if (StringUtils.compare(maxRes, (String)value) >= 0) continue;
                maxRes = value;
            }
            this._stringValuesSV[i] = maxRes;
        }
        return this._stringValuesSV;
    }
}

