/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.roaringbitmap.RoaringBitmap;

public abstract class BaseBooleanAssertionTransformFunction
extends BaseTransformFunction {
    private TransformFunction _transformFunction;

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0, (Object)("Exact 1 argument is required for " + this.getName()));
        this._transformFunction = arguments.get(0);
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BOOLEAN_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initIntValuesSV(length);
        Arrays.fill(this._intValuesSV, 0);
        int[] intValuesSV = this._transformFunction.transformToIntValuesSV(valueBlock);
        RoaringBitmap nullBitmap = null;
        if (this._nullHandlingEnabled) {
            nullBitmap = this._transformFunction.getNullBitmap(valueBlock);
        }
        if (nullBitmap != null) {
            for (int docId = 0; docId < length; ++docId) {
                if (nullBitmap.contains(docId)) {
                    if (!this.returnsTrueWhenValueIsNull()) continue;
                    this._intValuesSV[docId] = 1;
                    continue;
                }
                if (!this.valueEvaluatesToTrue(intValuesSV[docId])) continue;
                this._intValuesSV[docId] = 1;
            }
        } else {
            for (int docId = 0; docId < length; ++docId) {
                if (!this.valueEvaluatesToTrue(intValuesSV[docId])) continue;
                this._intValuesSV[docId] = 1;
            }
        }
        return this._intValuesSV;
    }

    protected abstract boolean returnsTrueWhenValueIsNull();

    protected abstract boolean valueEvaluatesToTrue(int var1);

    @Override
    public RoaringBitmap getNullBitmap(ValueBlock valueBlock) {
        return null;
    }
}

