/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ArrayCopyUtils;
import org.apache.pinot.spi.utils.CommonConstants;
import org.roaringbitmap.RoaringBitmap;

public abstract class BaseTransformFunction
implements TransformFunction {
    protected static final TransformResultMetadata INT_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.INT, true, false);
    protected static final TransformResultMetadata LONG_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.LONG, true, false);
    protected static final TransformResultMetadata FLOAT_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.FLOAT, true, false);
    protected static final TransformResultMetadata DOUBLE_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.DOUBLE, true, false);
    protected static final TransformResultMetadata BIG_DECIMAL_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.BIG_DECIMAL, true, false);
    protected static final TransformResultMetadata BOOLEAN_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.BOOLEAN, true, false);
    protected static final TransformResultMetadata TIMESTAMP_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.TIMESTAMP, true, false);
    protected static final TransformResultMetadata STRING_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.STRING, true, false);
    protected static final TransformResultMetadata JSON_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.JSON, true, false);
    protected static final TransformResultMetadata BYTES_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.BYTES, true, false);
    protected static final TransformResultMetadata INT_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.INT, false, false);
    protected static final TransformResultMetadata LONG_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.LONG, false, false);
    protected static final TransformResultMetadata FLOAT_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.FLOAT, false, false);
    protected static final TransformResultMetadata DOUBLE_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.DOUBLE, false, false);
    protected static final TransformResultMetadata BIG_DECIMAL_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.BIG_DECIMAL, false, false);
    protected static final TransformResultMetadata BOOLEAN_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.BOOLEAN, false, false);
    protected static final TransformResultMetadata TIMESTAMP_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.TIMESTAMP, false, false);
    protected static final TransformResultMetadata STRING_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.STRING, false, false);
    protected static final TransformResultMetadata JSON_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.JSON, false, false);
    protected static final TransformResultMetadata BYTES_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.BYTES, false, false);
    protected static final TransformResultMetadata UNKNOWN_METADATA = new TransformResultMetadata(FieldSpec.DataType.UNKNOWN, true, false);
    protected int[] _intValuesSV;
    protected long[] _longValuesSV;
    protected float[] _floatValuesSV;
    protected double[] _doubleValuesSV;
    protected BigDecimal[] _bigDecimalValuesSV;
    protected String[] _stringValuesSV;
    protected byte[][] _bytesValuesSV;
    protected int[][] _intValuesMV;
    protected long[][] _longValuesMV;
    protected float[][] _floatValuesMV;
    protected double[][] _doubleValuesMV;
    protected String[][] _stringValuesMV;
    protected byte[][][] _bytesValuesMV;
    protected List<TransformFunction> _arguments;
    protected boolean _nullHandlingEnabled;

    protected void fillResultUnknown(int length) {
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = 0;
        }
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        this._arguments = arguments;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap, boolean nullHandlingEnabled) {
        this.init(arguments, columnContextMap);
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    @Override
    public Dictionary getDictionary() {
        return null;
    }

    @Override
    public int[] transformToDictIdsSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] transformToDictIdsMV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    protected void initIntValuesSV(int length) {
        if (this._intValuesSV == null || this._intValuesSV.length < length) {
            this._intValuesSV = new int[length];
        }
    }

    protected void initZeroFillingIntValuesSV(int length) {
        if (this._intValuesSV == null || this._intValuesSV.length < length) {
            this._intValuesSV = new int[length];
        } else {
            Arrays.fill(this._intValuesSV, 0, length, 0);
        }
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initIntValuesSV(length);
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(valueBlock);
            dictionary.readIntValues(dictIds, length, this._intValuesSV);
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(valueBlock);
                    ArrayCopyUtils.copy((long[])longValues, (int[])this._intValuesSV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(valueBlock);
                    ArrayCopyUtils.copy((float[])floatValues, (int[])this._intValuesSV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(valueBlock);
                    ArrayCopyUtils.copy((double[])doubleValues, (int[])this._intValuesSV, (int)length);
                    break;
                }
                case BIG_DECIMAL: {
                    BigDecimal[] bigDecimalValues = this.transformToBigDecimalValuesSV(valueBlock);
                    ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (int[])this._intValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(valueBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (int[])this._intValuesSV, (int)length);
                    break;
                }
                case UNKNOWN: {
                    for (int i = 0; i < length; ++i) {
                        this._intValuesSV[i] = 0;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read SV %s as INT", resultDataType));
                }
            }
        }
        return this._intValuesSV;
    }

    protected void initLongValuesSV(int length) {
        if (this._longValuesSV == null || this._longValuesSV.length < length) {
            this._longValuesSV = new long[length];
        }
    }

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initLongValuesSV(length);
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(valueBlock);
            dictionary.readLongValues(dictIds, length, this._longValuesSV);
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(valueBlock);
                    ArrayCopyUtils.copy((int[])intValues, (long[])this._longValuesSV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(valueBlock);
                    ArrayCopyUtils.copy((float[])floatValues, (long[])this._longValuesSV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(valueBlock);
                    ArrayCopyUtils.copy((double[])doubleValues, (long[])this._longValuesSV, (int)length);
                    break;
                }
                case BIG_DECIMAL: {
                    BigDecimal[] bigDecimalValues = this.transformToBigDecimalValuesSV(valueBlock);
                    ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (long[])this._longValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(valueBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (long[])this._longValuesSV, (int)length);
                    break;
                }
                case UNKNOWN: {
                    for (int i = 0; i < length; ++i) {
                        this._longValuesSV[i] = 0L;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read SV %s as LONG", resultDataType));
                }
            }
        }
        return this._longValuesSV;
    }

    protected void initFloatValuesSV(int length) {
        if (this._floatValuesSV == null || this._floatValuesSV.length < length) {
            this._floatValuesSV = new float[length];
        }
    }

    @Override
    public float[] transformToFloatValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initFloatValuesSV(length);
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(valueBlock);
            dictionary.readFloatValues(dictIds, length, this._floatValuesSV);
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(valueBlock);
                    ArrayCopyUtils.copy((int[])intValues, (float[])this._floatValuesSV, (int)length);
                    break;
                }
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(valueBlock);
                    ArrayCopyUtils.copy((long[])longValues, (float[])this._floatValuesSV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(valueBlock);
                    ArrayCopyUtils.copy((double[])doubleValues, (float[])this._floatValuesSV, (int)length);
                    break;
                }
                case BIG_DECIMAL: {
                    BigDecimal[] bigDecimalValues = this.transformToBigDecimalValuesSV(valueBlock);
                    ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (float[])this._floatValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(valueBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (float[])this._floatValuesSV, (int)length);
                    break;
                }
                case UNKNOWN: {
                    for (int i = 0; i < length; ++i) {
                        this._floatValuesSV[i] = 0.0f;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read SV %s as FLOAT", resultDataType));
                }
            }
        }
        return this._floatValuesSV;
    }

    protected void initDoubleValuesSV(int length) {
        if (this._doubleValuesSV == null || this._doubleValuesSV.length < length) {
            this._doubleValuesSV = new double[length];
        }
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initDoubleValuesSV(length);
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(valueBlock);
            dictionary.readDoubleValues(dictIds, length, this._doubleValuesSV);
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(valueBlock);
                    ArrayCopyUtils.copy((int[])intValues, (double[])this._doubleValuesSV, (int)length);
                    break;
                }
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(valueBlock);
                    ArrayCopyUtils.copy((long[])longValues, (double[])this._doubleValuesSV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(valueBlock);
                    ArrayCopyUtils.copy((float[])floatValues, (double[])this._doubleValuesSV, (int)length);
                    break;
                }
                case BIG_DECIMAL: {
                    BigDecimal[] bigDecimalValues = this.transformToBigDecimalValuesSV(valueBlock);
                    ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (double[])this._doubleValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(valueBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (double[])this._doubleValuesSV, (int)length);
                    break;
                }
                case UNKNOWN: {
                    for (int i = 0; i < length; ++i) {
                        this._doubleValuesSV[i] = 0.0;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read SV %s as DOUBLE", resultDataType));
                }
            }
        }
        return this._doubleValuesSV;
    }

    protected void initBigDecimalValuesSV(int length) {
        if (this._bigDecimalValuesSV == null || this._bigDecimalValuesSV.length < length) {
            this._bigDecimalValuesSV = new BigDecimal[length];
        }
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initBigDecimalValuesSV(length);
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(valueBlock);
            dictionary.readBigDecimalValues(dictIds, length, this._bigDecimalValuesSV);
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(valueBlock);
                    ArrayCopyUtils.copy((int[])intValues, (BigDecimal[])this._bigDecimalValuesSV, (int)length);
                    break;
                }
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(valueBlock);
                    ArrayCopyUtils.copy((long[])longValues, (BigDecimal[])this._bigDecimalValuesSV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(valueBlock);
                    ArrayCopyUtils.copy((float[])floatValues, (BigDecimal[])this._bigDecimalValuesSV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(valueBlock);
                    ArrayCopyUtils.copy((double[])doubleValues, (BigDecimal[])this._bigDecimalValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(valueBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (BigDecimal[])this._bigDecimalValuesSV, (int)length);
                    break;
                }
                case BYTES: {
                    byte[][] bytesValues = this.transformToBytesValuesSV(valueBlock);
                    ArrayCopyUtils.copy((byte[][])bytesValues, (BigDecimal[])this._bigDecimalValuesSV, (int)length);
                    break;
                }
                case UNKNOWN: {
                    for (int i = 0; i < length; ++i) {
                        this._bigDecimalValuesSV[i] = CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read SV %s as BIG_DECIMAL", resultDataType));
                }
            }
        }
        return this._bigDecimalValuesSV;
    }

    protected void initStringValuesSV(int length) {
        if (this._stringValuesSV == null || this._stringValuesSV.length < length) {
            this._stringValuesSV = new String[length];
        }
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initStringValuesSV(length);
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(valueBlock);
            dictionary.readStringValues(dictIds, length, this._stringValuesSV);
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(valueBlock);
                    ArrayCopyUtils.copy((int[])intValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(valueBlock);
                    ArrayCopyUtils.copy((long[])longValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(valueBlock);
                    ArrayCopyUtils.copy((float[])floatValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(valueBlock);
                    ArrayCopyUtils.copy((double[])doubleValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                case BIG_DECIMAL: {
                    BigDecimal[] bigDecimalValues = this.transformToBigDecimalValuesSV(valueBlock);
                    ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                case BYTES: {
                    byte[][] bytesValues = this.transformToBytesValuesSV(valueBlock);
                    ArrayCopyUtils.copy((byte[][])bytesValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                case UNKNOWN: {
                    for (int i = 0; i < length; ++i) {
                        this._stringValuesSV[i] = "";
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read SV %s as STRING", resultDataType));
                }
            }
        }
        return this._stringValuesSV;
    }

    protected void initBytesValuesSV(int length) {
        if (this._bytesValuesSV == null || this._bytesValuesSV.length < length) {
            this._bytesValuesSV = new byte[length][];
        }
    }

    @Override
    public byte[][] transformToBytesValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initBytesValuesSV(length);
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(valueBlock);
            dictionary.readBytesValues(dictIds, length, this._bytesValuesSV);
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case BIG_DECIMAL: {
                    BigDecimal[] bigDecimalValues = this.transformToBigDecimalValuesSV(valueBlock);
                    ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (byte[][])this._bytesValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(valueBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (byte[][])this._bytesValuesSV, (int)length);
                    break;
                }
                case UNKNOWN: {
                    for (int i = 0; i < length; ++i) {
                        this._bytesValuesSV[i] = CommonConstants.NullValuePlaceHolder.BYTES;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read SV %s as BYTES", resultDataType));
                }
            }
        }
        return this._bytesValuesSV;
    }

    protected void initIntValuesMV(int length) {
        if (this._intValuesMV == null || this._intValuesMV.length < length) {
            this._intValuesMV = new int[length][];
        }
    }

    @Override
    public int[][] transformToIntValuesMV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initIntValuesMV(length);
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(valueBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                int[] intValues = new int[numValues];
                dictionary.readIntValues(dictIds, numValues, intValues);
                this._intValuesMV[i] = intValues;
            }
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(valueBlock);
                    ArrayCopyUtils.copy((long[][])longValuesMV, (int[][])this._intValuesMV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(valueBlock);
                    ArrayCopyUtils.copy((float[][])floatValuesMV, (int[][])this._intValuesMV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(valueBlock);
                    ArrayCopyUtils.copy((double[][])doubleValuesMV, (int[][])this._intValuesMV, (int)length);
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(valueBlock);
                    ArrayCopyUtils.copy((String[][])stringValuesMV, (int[][])this._intValuesMV, (int)length);
                    break;
                }
                case UNKNOWN: {
                    for (int i = 0; i < length; ++i) {
                        this._intValuesMV[i] = CommonConstants.NullValuePlaceHolder.INT_ARRAY;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read MV %s as INT", resultDataType));
                }
            }
        }
        return this._intValuesMV;
    }

    protected void initLongValuesMV(int length) {
        if (this._longValuesMV == null || this._longValuesMV.length < length) {
            this._longValuesMV = new long[length][];
        }
    }

    @Override
    public long[][] transformToLongValuesMV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initLongValuesMV(length);
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(valueBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                long[] longValues = new long[numValues];
                dictionary.readLongValues(dictIds, numValues, longValues);
                this._longValuesMV[i] = longValues;
            }
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(valueBlock);
                    ArrayCopyUtils.copy((int[][])intValuesMV, (long[][])this._longValuesMV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(valueBlock);
                    ArrayCopyUtils.copy((float[][])floatValuesMV, (long[][])this._longValuesMV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(valueBlock);
                    ArrayCopyUtils.copy((double[][])doubleValuesMV, (long[][])this._longValuesMV, (int)length);
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(valueBlock);
                    ArrayCopyUtils.copy((String[][])stringValuesMV, (long[][])this._longValuesMV, (int)length);
                    break;
                }
                case UNKNOWN: {
                    for (int i = 0; i < length; ++i) {
                        this._longValuesMV[i] = CommonConstants.NullValuePlaceHolder.LONG_ARRAY;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read MV %s as LONG", resultDataType));
                }
            }
        }
        return this._longValuesMV;
    }

    protected void initFloatValuesMV(int length) {
        if (this._floatValuesMV == null || this._floatValuesMV.length < length) {
            this._floatValuesMV = new float[length][];
        }
    }

    @Override
    public float[][] transformToFloatValuesMV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initFloatValuesMV(length);
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(valueBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                float[] floatValues = new float[numValues];
                dictionary.readFloatValues(dictIds, numValues, floatValues);
                this._floatValuesMV[i] = floatValues;
            }
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(valueBlock);
                    ArrayCopyUtils.copy((int[][])intValuesMV, (float[][])this._floatValuesMV, (int)length);
                    break;
                }
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(valueBlock);
                    ArrayCopyUtils.copy((long[][])longValuesMV, (float[][])this._floatValuesMV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(valueBlock);
                    ArrayCopyUtils.copy((double[][])doubleValuesMV, (float[][])this._floatValuesMV, (int)length);
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(valueBlock);
                    ArrayCopyUtils.copy((String[][])stringValuesMV, (float[][])this._floatValuesMV, (int)length);
                    break;
                }
                case UNKNOWN: {
                    for (int i = 0; i < length; ++i) {
                        this._floatValuesMV[i] = CommonConstants.NullValuePlaceHolder.FLOAT_ARRAY;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read MV %s as FLOAT", resultDataType));
                }
            }
        }
        return this._floatValuesMV;
    }

    protected void initDoubleValuesMV(int length) {
        if (this._doubleValuesMV == null || this._doubleValuesMV.length < length) {
            this._doubleValuesMV = new double[length][];
        }
    }

    @Override
    public double[][] transformToDoubleValuesMV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initDoubleValuesMV(length);
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(valueBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                double[] doubleValues = new double[numValues];
                dictionary.readDoubleValues(dictIds, numValues, doubleValues);
                this._doubleValuesMV[i] = doubleValues;
            }
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(valueBlock);
                    ArrayCopyUtils.copy((int[][])intValuesMV, (double[][])this._doubleValuesMV, (int)length);
                    break;
                }
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(valueBlock);
                    ArrayCopyUtils.copy((long[][])longValuesMV, (double[][])this._doubleValuesMV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(valueBlock);
                    ArrayCopyUtils.copy((float[][])floatValuesMV, (double[][])this._doubleValuesMV, (int)length);
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(valueBlock);
                    ArrayCopyUtils.copy((String[][])stringValuesMV, (double[][])this._doubleValuesMV, (int)length);
                    break;
                }
                case UNKNOWN: {
                    for (int i = 0; i < length; ++i) {
                        this._doubleValuesMV[i] = CommonConstants.NullValuePlaceHolder.DOUBLE_ARRAY;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read MV %s as DOUBLE", resultDataType));
                }
            }
        }
        return this._doubleValuesMV;
    }

    protected void initStringValuesMV(int length) {
        if (this._stringValuesMV == null || this._stringValuesMV.length < length) {
            this._stringValuesMV = new String[length][];
        }
    }

    @Override
    public String[][] transformToStringValuesMV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initStringValuesMV(length);
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(valueBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                String[] stringValues = new String[numValues];
                dictionary.readStringValues(dictIds, numValues, stringValues);
                this._stringValuesMV[i] = stringValues;
            }
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(valueBlock);
                    ArrayCopyUtils.copy((int[][])intValuesMV, (String[][])this._stringValuesMV, (int)length);
                    break;
                }
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(valueBlock);
                    ArrayCopyUtils.copy((long[][])longValuesMV, (String[][])this._stringValuesMV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(valueBlock);
                    ArrayCopyUtils.copy((float[][])floatValuesMV, (String[][])this._stringValuesMV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(valueBlock);
                    ArrayCopyUtils.copy((double[][])doubleValuesMV, (String[][])this._stringValuesMV, (int)length);
                    break;
                }
                case UNKNOWN: {
                    for (int i = 0; i < length; ++i) {
                        this._stringValuesMV[i] = CommonConstants.NullValuePlaceHolder.STRING_ARRAY;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read MV %s as STRING", resultDataType));
                }
            }
        }
        return this._stringValuesMV;
    }

    protected void initBytesValuesMV(int length) {
        if (this._bytesValuesMV == null || this._bytesValuesMV.length < length) {
            this._bytesValuesMV = new byte[length][][];
        }
    }

    @Override
    public byte[][][] transformToBytesValuesMV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initBytesValuesMV(length);
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(valueBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                byte[][] bytesValues = new byte[numValues][];
                dictionary.readBytesValues(dictIds, numValues, (byte[][])bytesValues);
                this._bytesValuesMV[i] = bytesValues;
            }
        } else {
            assert (this.getResultMetadata().getDataType().getStoredType() == FieldSpec.DataType.STRING);
            String[][] stringValuesMV = this.transformToStringValuesMV(valueBlock);
            ArrayCopyUtils.copy((String[][])stringValuesMV, (byte[][][])this._bytesValuesMV, (int)length);
        }
        return this._bytesValuesMV;
    }

    @Override
    @Nullable
    public RoaringBitmap getNullBitmap(ValueBlock valueBlock) {
        RoaringBitmap bitmap = new RoaringBitmap();
        for (TransformFunction arg : this._arguments) {
            RoaringBitmap argBitmap = arg.getNullBitmap(valueBlock);
            if (argBitmap == null) continue;
            bitmap.or(argBitmap);
        }
        if (bitmap.isEmpty()) {
            return null;
        }
        return bitmap;
    }
}

