/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ArrayCopyUtils;

public class CastTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "cast";
    private TransformFunction _transformFunction;
    private FieldSpec.DataType _sourceDataType;
    private TransformResultMetadata _resultMetadata;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Exactly 2 arguments are required for CAST transform function");
        }
        this._transformFunction = arguments.get(0);
        TransformResultMetadata sourceMetadata = this._transformFunction.getResultMetadata();
        this._sourceDataType = sourceMetadata.getDataType();
        boolean sourceSV = sourceMetadata.isSingleValue();
        TransformFunction castFormatTransformFunction = arguments.get(1);
        if (castFormatTransformFunction instanceof LiteralTransformFunction) {
            String targetType;
            switch (targetType = ((LiteralTransformFunction)castFormatTransformFunction).getStringLiteral().toUpperCase()) {
                case "INT": 
                case "INTEGER": {
                    this._resultMetadata = sourceSV ? INT_SV_NO_DICTIONARY_METADATA : INT_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "LONG": {
                    this._resultMetadata = sourceSV ? LONG_SV_NO_DICTIONARY_METADATA : LONG_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "FLOAT": {
                    this._resultMetadata = sourceSV ? FLOAT_SV_NO_DICTIONARY_METADATA : FLOAT_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "DOUBLE": {
                    this._resultMetadata = sourceSV ? DOUBLE_SV_NO_DICTIONARY_METADATA : DOUBLE_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "DECIMAL": 
                case "BIGDECIMAL": 
                case "BIG_DECIMAL": {
                    Preconditions.checkState((boolean)sourceSV, (Object)"Cannot cast from MV to BIG_DECIMAL");
                    this._resultMetadata = BIG_DECIMAL_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "BOOL": 
                case "BOOLEAN": {
                    this._resultMetadata = sourceSV ? BOOLEAN_SV_NO_DICTIONARY_METADATA : BOOLEAN_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "TIMESTAMP": {
                    this._resultMetadata = sourceSV ? TIMESTAMP_SV_NO_DICTIONARY_METADATA : TIMESTAMP_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "STRING": 
                case "VARCHAR": {
                    this._resultMetadata = sourceSV ? STRING_SV_NO_DICTIONARY_METADATA : STRING_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "INT_ARRAY": 
                case "INTEGER_ARRAY": {
                    this._resultMetadata = INT_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "LONG_ARRAY": {
                    this._resultMetadata = LONG_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "FLOAT_ARRAY": {
                    this._resultMetadata = FLOAT_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "DOUBLE_ARRAY": {
                    this._resultMetadata = DOUBLE_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "STRING_ARRAY": 
                case "VARCHAR_ARRAY": {
                    this._resultMetadata = STRING_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "JSON": {
                    this._resultMetadata = sourceSV ? JSON_SV_NO_DICTIONARY_METADATA : JSON_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unable to cast expression to type - " + targetType);
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid cast to type - " + castFormatTransformFunction.getName());
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        switch (this._resultMetadata.getDataType()) {
            case INT: {
                return this._transformFunction.transformToIntValuesSV(valueBlock);
            }
            case BOOLEAN: {
                return this.transformToBooleanValuesSV(valueBlock);
            }
        }
        return super.transformToIntValuesSV(valueBlock);
    }

    private int[] transformToBooleanValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initIntValuesSV(length);
        switch (this._sourceDataType.getStoredType()) {
            case INT: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(valueBlock);
                ArrayCopyUtils.copyToBoolean((int[])intValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            case LONG: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(valueBlock);
                ArrayCopyUtils.copyToBoolean((long[])longValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            case FLOAT: {
                float[] floatValues = this._transformFunction.transformToFloatValuesSV(valueBlock);
                ArrayCopyUtils.copyToBoolean((float[])floatValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(valueBlock);
                ArrayCopyUtils.copyToBoolean((double[])doubleValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] bigDecimalValues = this._transformFunction.transformToBigDecimalValuesSV(valueBlock);
                ArrayCopyUtils.copyToBoolean((BigDecimal[])bigDecimalValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            case STRING: {
                String[] stringValues = this._transformFunction.transformToStringValuesSV(valueBlock);
                ArrayCopyUtils.copyToBoolean((String[])stringValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Cannot cast from SV %s to BOOLEAN", this._sourceDataType));
            }
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        switch (this._resultMetadata.getDataType()) {
            case LONG: {
                return this._transformFunction.transformToLongValuesSV(valueBlock);
            }
            case TIMESTAMP: {
                return this.transformToTimestampValuesSV(valueBlock);
            }
        }
        return super.transformToLongValuesSV(valueBlock);
    }

    private long[] transformToTimestampValuesSV(ValueBlock valueBlock) {
        if (this._sourceDataType.getStoredType() == FieldSpec.DataType.STRING) {
            int length = valueBlock.getNumDocs();
            this.initLongValuesSV(length);
            String[] stringValues = this._transformFunction.transformToStringValuesSV(valueBlock);
            ArrayCopyUtils.copyToTimestamp((String[])stringValues, (long[])this._longValuesSV, (int)length);
            return this._longValuesSV;
        }
        return this._transformFunction.transformToLongValuesSV(valueBlock);
    }

    @Override
    public float[] transformToFloatValuesSV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() == FieldSpec.DataType.FLOAT) {
            return this._transformFunction.transformToFloatValuesSV(valueBlock);
        }
        return super.transformToFloatValuesSV(valueBlock);
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() == FieldSpec.DataType.DOUBLE) {
            return this._transformFunction.transformToDoubleValuesSV(valueBlock);
        }
        return super.transformToDoubleValuesSV(valueBlock);
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() == FieldSpec.DataType.BIG_DECIMAL) {
            return this._transformFunction.transformToBigDecimalValuesSV(valueBlock);
        }
        return super.transformToBigDecimalValuesSV(valueBlock);
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        FieldSpec.DataType resultDataType = this._resultMetadata.getDataType();
        if (resultDataType.getStoredType() == FieldSpec.DataType.STRING) {
            switch (this._sourceDataType) {
                case BOOLEAN: {
                    int length = valueBlock.getNumDocs();
                    this.initStringValuesSV(length);
                    int[] intValues = this._transformFunction.transformToIntValuesSV(valueBlock);
                    ArrayCopyUtils.copyFromBoolean((int[])intValues, (String[])this._stringValuesSV, (int)length);
                    return this._stringValuesSV;
                }
                case TIMESTAMP: {
                    int length = valueBlock.getNumDocs();
                    this.initStringValuesSV(length);
                    long[] longValues = this._transformFunction.transformToLongValuesSV(valueBlock);
                    ArrayCopyUtils.copyFromTimestamp((long[])longValues, (String[])this._stringValuesSV, (int)length);
                    return this._stringValuesSV;
                }
            }
            return this._transformFunction.transformToStringValuesSV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initStringValuesSV(length);
        switch (resultDataType) {
            case INT: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(valueBlock);
                ArrayCopyUtils.copy((int[])intValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case LONG: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(valueBlock);
                ArrayCopyUtils.copy((long[])longValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case FLOAT: {
                float[] floatValues = this._transformFunction.transformToFloatValuesSV(valueBlock);
                ArrayCopyUtils.copy((float[])floatValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(valueBlock);
                ArrayCopyUtils.copy((double[])doubleValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] bigDecimalValues = this._transformFunction.transformToBigDecimalValuesSV(valueBlock);
                ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case BOOLEAN: {
                int[] intValues = this.transformToBooleanValuesSV(valueBlock);
                ArrayCopyUtils.copyFromBoolean((int[])intValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case TIMESTAMP: {
                long[] longValues = this.transformToTimestampValuesSV(valueBlock);
                ArrayCopyUtils.copyFromTimestamp((long[])longValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case BYTES: {
                byte[][] bytesValues = this.transformToBytesValuesSV(valueBlock);
                ArrayCopyUtils.copy((byte[][])bytesValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Cannot cast from SV %s to STRING", resultDataType));
            }
        }
        return this._stringValuesSV;
    }

    @Override
    public int[][] transformToIntValuesMV(ValueBlock valueBlock) {
        switch (this._resultMetadata.getDataType()) {
            case INT: {
                return this._transformFunction.transformToIntValuesMV(valueBlock);
            }
            case BOOLEAN: {
                return this.transformToBooleanValuesMV(valueBlock);
            }
        }
        return super.transformToIntValuesMV(valueBlock);
    }

    private int[][] transformToBooleanValuesMV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initIntValuesMV(length);
        switch (this._sourceDataType.getStoredType()) {
            case INT: {
                int[][] intValuesMV = this._transformFunction.transformToIntValuesMV(valueBlock);
                ArrayCopyUtils.copyToBoolean((int[][])intValuesMV, (int[][])this._intValuesMV, (int)length);
                break;
            }
            case LONG: {
                long[][] longValuesMV = this._transformFunction.transformToLongValuesMV(valueBlock);
                ArrayCopyUtils.copyToBoolean((long[][])longValuesMV, (int[][])this._intValuesMV, (int)length);
                break;
            }
            case FLOAT: {
                float[][] floatValuesMV = this._transformFunction.transformToFloatValuesMV(valueBlock);
                ArrayCopyUtils.copyToBoolean((float[][])floatValuesMV, (int[][])this._intValuesMV, (int)length);
                break;
            }
            case DOUBLE: {
                double[][] doubleValuesMV = this._transformFunction.transformToDoubleValuesMV(valueBlock);
                ArrayCopyUtils.copyToBoolean((double[][])doubleValuesMV, (int[][])this._intValuesMV, (int)length);
                break;
            }
            case STRING: {
                String[][] stringValuesMV = this._transformFunction.transformToStringValuesMV(valueBlock);
                ArrayCopyUtils.copyToBoolean((String[][])stringValuesMV, (int[][])this._intValuesMV, (int)length);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Cannot cast from MV %s to BOOLEAN", this._sourceDataType));
            }
        }
        return this._intValuesMV;
    }

    @Override
    public long[][] transformToLongValuesMV(ValueBlock valueBlock) {
        switch (this._resultMetadata.getDataType()) {
            case LONG: {
                return this._transformFunction.transformToLongValuesMV(valueBlock);
            }
            case TIMESTAMP: {
                return this.transformToTimestampValuesMV(valueBlock);
            }
        }
        return super.transformToLongValuesMV(valueBlock);
    }

    private long[][] transformToTimestampValuesMV(ValueBlock valueBlock) {
        if (this._sourceDataType.getStoredType() == FieldSpec.DataType.STRING) {
            int length = valueBlock.getNumDocs();
            this.initLongValuesMV(length);
            String[][] stringValuesMV = this._transformFunction.transformToStringValuesMV(valueBlock);
            ArrayCopyUtils.copyToTimestamp((String[][])stringValuesMV, (long[][])this._longValuesMV, (int)length);
            return this._longValuesMV;
        }
        return this._transformFunction.transformToLongValuesMV(valueBlock);
    }

    @Override
    public float[][] transformToFloatValuesMV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() == FieldSpec.DataType.FLOAT) {
            return this._transformFunction.transformToFloatValuesMV(valueBlock);
        }
        return super.transformToFloatValuesMV(valueBlock);
    }

    @Override
    public double[][] transformToDoubleValuesMV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() == FieldSpec.DataType.DOUBLE) {
            return this._transformFunction.transformToDoubleValuesMV(valueBlock);
        }
        return super.transformToDoubleValuesMV(valueBlock);
    }

    @Override
    public String[][] transformToStringValuesMV(ValueBlock valueBlock) {
        FieldSpec.DataType resultDataType = this._resultMetadata.getDataType();
        if (resultDataType.getStoredType() == FieldSpec.DataType.STRING) {
            switch (this._sourceDataType) {
                case BOOLEAN: {
                    int length = valueBlock.getNumDocs();
                    this.initStringValuesMV(length);
                    int[][] intValuesMV = this._transformFunction.transformToIntValuesMV(valueBlock);
                    ArrayCopyUtils.copyFromBoolean((int[][])intValuesMV, (String[][])this._stringValuesMV, (int)length);
                    return this._stringValuesMV;
                }
                case TIMESTAMP: {
                    int length = valueBlock.getNumDocs();
                    this.initStringValuesMV(length);
                    long[][] longValuesMV = this._transformFunction.transformToLongValuesMV(valueBlock);
                    ArrayCopyUtils.copyFromTimestamp((long[][])longValuesMV, (String[][])this._stringValuesMV, (int)length);
                    return this._stringValuesMV;
                }
            }
            return this._transformFunction.transformToStringValuesMV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initStringValuesMV(length);
        switch (resultDataType) {
            case INT: {
                int[][] intValuesMV = this._transformFunction.transformToIntValuesMV(valueBlock);
                ArrayCopyUtils.copy((int[][])intValuesMV, (String[][])this._stringValuesMV, (int)length);
                break;
            }
            case LONG: {
                long[][] longValuesMV = this._transformFunction.transformToLongValuesMV(valueBlock);
                ArrayCopyUtils.copy((long[][])longValuesMV, (String[][])this._stringValuesMV, (int)length);
                break;
            }
            case FLOAT: {
                float[][] floatValuesMV = this._transformFunction.transformToFloatValuesMV(valueBlock);
                ArrayCopyUtils.copy((float[][])floatValuesMV, (String[][])this._stringValuesMV, (int)length);
                break;
            }
            case DOUBLE: {
                double[][] doubleValuesMV = this._transformFunction.transformToDoubleValuesMV(valueBlock);
                ArrayCopyUtils.copy((double[][])doubleValuesMV, (String[][])this._stringValuesMV, (int)length);
                break;
            }
            case BOOLEAN: {
                int[][] intValuesMV = this.transformToBooleanValuesMV(valueBlock);
                ArrayCopyUtils.copyFromBoolean((int[][])intValuesMV, (String[][])this._stringValuesMV, (int)length);
                break;
            }
            case TIMESTAMP: {
                long[][] longValuesMV = this.transformToTimestampValuesMV(valueBlock);
                ArrayCopyUtils.copyFromTimestamp((long[][])longValuesMV, (String[][])this._stringValuesMV, (int)length);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Cannot cast from MV %s to STRING", resultDataType));
            }
        }
        return this._stringValuesMV;
    }
}

