/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.operator.transform.transformer.datetimehop.BaseDateTimeWindowHopTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetimehop.DateTimeWindowHopTransformerFactory;
import org.apache.pinot.core.operator.transform.transformer.datetimehop.EpochToEpochWindowHopTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetimehop.EpochToSDFHopWindowTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetimehop.SDFToEpochWindowHopTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetimehop.SDFToSDFWindowHopTransformer;
import org.roaringbitmap.RoaringBitmap;

public class DateTimeConversionHopTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "dateTimeConvertWindowHop";
    private TransformFunction _mainTransformFunction;
    private TransformResultMetadata _resultMetadata;
    private BaseDateTimeWindowHopTransformer<?, ?> _dateTimeTransformer;

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        if (arguments.size() != 5) {
            throw new IllegalArgumentException("Exactly 5 arguments are required for DATE_TIME_CONVERT_HOP function");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || !firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The first argument of DATE_TIME_CONVERT_HOP transform function must be a single-valued column or a transform function");
        }
        this._mainTransformFunction = firstArgument;
        this._dateTimeTransformer = DateTimeWindowHopTransformerFactory.getDateTimeTransformer(((LiteralTransformFunction)arguments.get(1)).getStringLiteral(), ((LiteralTransformFunction)arguments.get(2)).getStringLiteral(), ((LiteralTransformFunction)arguments.get(3)).getStringLiteral(), ((LiteralTransformFunction)arguments.get(4)).getStringLiteral());
        this._resultMetadata = this._dateTimeTransformer instanceof EpochToEpochWindowHopTransformer || this._dateTimeTransformer instanceof SDFToEpochWindowHopTransformer ? LONG_MV_NO_DICTIONARY_METADATA : STRING_MV_NO_DICTIONARY_METADATA;
    }

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public long[][] transformToLongValuesMV(ValueBlock valueBlock) {
        if (this._resultMetadata != LONG_MV_NO_DICTIONARY_METADATA) {
            return super.transformToLongValuesMV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initLongValuesMV(length);
        if (this._dateTimeTransformer instanceof EpochToEpochWindowHopTransformer) {
            EpochToEpochWindowHopTransformer dateTimeTransformer = (EpochToEpochWindowHopTransformer)this._dateTimeTransformer;
            dateTimeTransformer.transform(this._mainTransformFunction.transformToLongValuesSV(valueBlock), this._longValuesMV, length);
        } else if (this._dateTimeTransformer instanceof SDFToEpochWindowHopTransformer) {
            SDFToEpochWindowHopTransformer dateTimeTransformer = (SDFToEpochWindowHopTransformer)this._dateTimeTransformer;
            dateTimeTransformer.transform(this._mainTransformFunction.transformToStringValuesSV(valueBlock), this._longValuesMV, length);
        }
        return this._longValuesMV;
    }

    @Override
    public String[][] transformToStringValuesMV(ValueBlock valueBlock) {
        if (this._resultMetadata != STRING_MV_NO_DICTIONARY_METADATA) {
            return super.transformToStringValuesMV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initStringValuesMV(length);
        if (this._dateTimeTransformer instanceof EpochToSDFHopWindowTransformer) {
            EpochToSDFHopWindowTransformer dateTimeTransformer = (EpochToSDFHopWindowTransformer)this._dateTimeTransformer;
            dateTimeTransformer.transform(this._mainTransformFunction.transformToLongValuesSV(valueBlock), this._stringValuesMV, length);
        } else if (this._dateTimeTransformer instanceof SDFToSDFWindowHopTransformer) {
            SDFToSDFWindowHopTransformer dateTimeTransformer = (SDFToSDFWindowHopTransformer)this._dateTimeTransformer;
            dateTimeTransformer.transform(this._mainTransformFunction.transformToStringValuesSV(valueBlock), this._stringValuesMV, length);
        }
        return this._stringValuesMV;
    }

    @Override
    public RoaringBitmap getNullBitmap(ValueBlock valueBlock) {
        return this._mainTransformFunction.getNullBitmap(valueBlock);
    }
}

