/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import javax.annotation.Nullable;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BinaryOperatorTransformFunction;
import org.roaringbitmap.RoaringBitmap;

public class DistinctFromTransformFunction
extends BinaryOperatorTransformFunction {
    private final int _distinctResult;
    private final int _notDistinctResult;

    private static boolean isEmpty(RoaringBitmap bitmap) {
        return bitmap == null || bitmap.isEmpty();
    }

    protected DistinctFromTransformFunction(boolean distinct) {
        super(distinct ? TransformFunctionType.NOT_EQUALS : TransformFunctionType.EQUALS);
        this._distinctResult = distinct ? 1 : 0;
        this._notDistinctResult = distinct ? 0 : 1;
    }

    @Override
    public String getName() {
        if (this._distinctResult == 1) {
            return TransformFunctionType.IS_DISTINCT_FROM.getName();
        }
        return TransformFunctionType.IS_NOT_DISTINCT_FROM.getName();
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BOOLEAN_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        this._intValuesSV = super.transformToIntValuesSV(valueBlock);
        RoaringBitmap leftNull = this._leftTransformFunction.getNullBitmap(valueBlock);
        RoaringBitmap rightNull = this._rightTransformFunction.getNullBitmap(valueBlock);
        if (DistinctFromTransformFunction.isEmpty(leftNull) && DistinctFromTransformFunction.isEmpty(rightNull)) {
            return this._intValuesSV;
        }
        if (DistinctFromTransformFunction.isEmpty(leftNull)) {
            rightNull.forEach(i -> {
                this._intValuesSV[i] = this._distinctResult;
            });
            return this._intValuesSV;
        }
        if (DistinctFromTransformFunction.isEmpty(rightNull)) {
            leftNull.forEach(i -> {
                this._intValuesSV[i] = this._distinctResult;
            });
            return this._intValuesSV;
        }
        RoaringBitmap xorNull = RoaringBitmap.xor((RoaringBitmap)leftNull, (RoaringBitmap)rightNull);
        xorNull.forEach(i -> {
            this._intValuesSV[i] = this._distinctResult;
        });
        RoaringBitmap andNull = RoaringBitmap.and((RoaringBitmap)leftNull, (RoaringBitmap)rightNull);
        andNull.forEach(i -> {
            this._intValuesSV[i] = this._notDistinctResult;
        });
        return this._intValuesSV;
    }

    @Override
    @Nullable
    public RoaringBitmap getNullBitmap(ValueBlock valueBlock) {
        return null;
    }
}

