/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.JsonPathCache;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.IdentifierTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.JsonUtils;
import org.roaringbitmap.RoaringBitmap;

public class JsonExtractIndexTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "jsonExtractIndex";
    private TransformFunction _jsonFieldTransformFunction;
    private String _jsonPathString;
    private TransformResultMetadata _resultMetadata;
    private JsonIndexReader _jsonIndexReader;
    private Object _defaultValue;
    private Map<String, RoaringBitmap> _valueToMatchingDocsMap;
    private boolean _isSingleValue;
    private String _filterJsonPath;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        FieldSpec.DataType dataType;
        if (arguments.size() < 3 || arguments.size() > 5) {
            throw new IllegalArgumentException("Expected 3/4/5 arguments for transform function: jsonExtractIndex(jsonFieldName, 'jsonPath', 'resultsType', ['defaultValue'], ['jsonFilterExpression'])");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof IdentifierTransformFunction) {
            String columnName = ((IdentifierTransformFunction)firstArgument).getColumnName();
            this._jsonIndexReader = columnContextMap.get(columnName).getDataSource().getJsonIndex();
            if (this._jsonIndexReader == null) {
                throw new IllegalStateException("jsonExtractIndex can only be applied on a column with JSON index");
            }
        } else {
            throw new IllegalArgumentException("jsonExtractIndex can only be applied to a raw column");
        }
        this._jsonFieldTransformFunction = firstArgument;
        TransformFunction secondArgument = arguments.get(1);
        if (!(secondArgument instanceof LiteralTransformFunction)) {
            throw new IllegalArgumentException("JSON path argument must be a literal");
        }
        this._jsonPathString = ((LiteralTransformFunction)secondArgument).getStringLiteral();
        try {
            JsonPathCache.INSTANCE.getOrCompute(this._jsonPathString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("JSON path argument is not a valid JSON path");
        }
        TransformFunction thirdArgument = arguments.get(2);
        if (!(thirdArgument instanceof LiteralTransformFunction)) {
            throw new IllegalArgumentException("Result type argument must be a literal");
        }
        String resultsType = ((LiteralTransformFunction)thirdArgument).getStringLiteral().toUpperCase();
        boolean bl = this._isSingleValue = !resultsType.endsWith("_ARRAY");
        if (this._isSingleValue && this._jsonPathString.contains("[*]")) {
            throw new IllegalArgumentException("[*] syntax in json path is unsupported for singleValue field json_extract_index");
        }
        FieldSpec.DataType dataType2 = dataType = this._isSingleValue ? FieldSpec.DataType.valueOf((String)resultsType) : FieldSpec.DataType.valueOf((String)resultsType.substring(0, resultsType.length() - 6));
        if (arguments.size() >= 4) {
            TransformFunction fourthArgument = arguments.get(3);
            if (!(fourthArgument instanceof LiteralTransformFunction)) {
                throw new IllegalArgumentException("Default value must be a literal");
            }
            if (this._isSingleValue) {
                this._defaultValue = dataType.convert(((LiteralTransformFunction)fourthArgument).getStringLiteral());
            } else {
                try {
                    JsonNode mvArray = JsonUtils.stringToJsonNode((String)((LiteralTransformFunction)fourthArgument).getStringLiteral());
                    if (!mvArray.isArray()) {
                        throw new IllegalArgumentException("Default value must be a valid JSON array");
                    }
                    Object[] defaultValues = new Object[mvArray.size()];
                    for (int i = 0; i < mvArray.size(); ++i) {
                        defaultValues[i] = dataType.convert(mvArray.get(i).asText());
                    }
                    this._defaultValue = defaultValues;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Default value must be a valid JSON array");
                }
            }
        }
        if (arguments.size() == 5) {
            TransformFunction fifthArgument = arguments.get(4);
            if (!(fifthArgument instanceof LiteralTransformFunction)) {
                throw new IllegalArgumentException("JSON path filter argument must be a literal");
            }
            this._filterJsonPath = ((LiteralTransformFunction)fifthArgument).getStringLiteral();
        }
        this._resultMetadata = new TransformResultMetadata(dataType, this._isSingleValue, false);
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        int[] inputDocIds = valueBlock.getDocIds();
        this.initIntValuesSV(numDocs);
        String[] valuesFromIndex = this._jsonIndexReader.getValuesSV(valueBlock.getDocIds(), valueBlock.getNumDocs(), this.getValueToMatchingDocsMap(), false);
        for (int i = 0; i < numDocs; ++i) {
            String value = valuesFromIndex[i];
            if (value == null) {
                if (this._defaultValue != null) {
                    this._intValuesSV[i] = (Integer)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], for docId [%s]", this._jsonPathString, inputDocIds[i]));
            }
            this._intValuesSV[i] = Integer.parseInt(value);
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        int[] inputDocIds = valueBlock.getDocIds();
        this.initLongValuesSV(numDocs);
        String[] valuesFromIndex = this._jsonIndexReader.getValuesSV(valueBlock.getDocIds(), valueBlock.getNumDocs(), this.getValueToMatchingDocsMap(), false);
        for (int i = 0; i < numDocs; ++i) {
            String value = valuesFromIndex[i];
            if (value == null) {
                if (this._defaultValue != null) {
                    this._longValuesSV[i] = (Long)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], for docId [%s]", this._jsonPathString, inputDocIds[i]));
            }
            this._longValuesSV[i] = Long.parseLong(value);
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        int[] inputDocIds = valueBlock.getDocIds();
        this.initFloatValuesSV(numDocs);
        String[] valuesFromIndex = this._jsonIndexReader.getValuesSV(valueBlock.getDocIds(), valueBlock.getNumDocs(), this.getValueToMatchingDocsMap(), false);
        for (int i = 0; i < numDocs; ++i) {
            String value = valuesFromIndex[i];
            if (value == null) {
                if (this._defaultValue != null) {
                    this._floatValuesSV[i] = ((Float)this._defaultValue).floatValue();
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], for docId [%s]", this._jsonPathString, inputDocIds[i]));
            }
            this._floatValuesSV[i] = Float.parseFloat(value);
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        int[] inputDocIds = valueBlock.getDocIds();
        this.initDoubleValuesSV(numDocs);
        String[] valuesFromIndex = this._jsonIndexReader.getValuesSV(valueBlock.getDocIds(), valueBlock.getNumDocs(), this.getValueToMatchingDocsMap(), false);
        for (int i = 0; i < numDocs; ++i) {
            String value = valuesFromIndex[i];
            if (value == null) {
                if (this._defaultValue != null) {
                    this._doubleValuesSV[i] = (Double)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], for docId [%s]", this._jsonPathString, inputDocIds[i]));
            }
            this._doubleValuesSV[i] = Double.parseDouble(value);
        }
        return this._doubleValuesSV;
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        int[] inputDocIds = valueBlock.getDocIds();
        this.initBigDecimalValuesSV(numDocs);
        String[] valuesFromIndex = this._jsonIndexReader.getValuesSV(valueBlock.getDocIds(), valueBlock.getNumDocs(), this.getValueToMatchingDocsMap(), false);
        for (int i = 0; i < numDocs; ++i) {
            String value = valuesFromIndex[i];
            if (value == null) {
                if (this._defaultValue != null) {
                    this._bigDecimalValuesSV[i] = (BigDecimal)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], for docId [%s]", this._jsonPathString, inputDocIds[i]));
            }
            this._bigDecimalValuesSV[i] = new BigDecimal(value);
        }
        return this._bigDecimalValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        int[] inputDocIds = valueBlock.getDocIds();
        this.initStringValuesSV(numDocs);
        String[] valuesFromIndex = this._jsonIndexReader.getValuesSV(valueBlock.getDocIds(), valueBlock.getNumDocs(), this.getValueToMatchingDocsMap(), false);
        for (int i = 0; i < numDocs; ++i) {
            String value = valuesFromIndex[i];
            if (value == null) {
                if (this._defaultValue != null) {
                    this._stringValuesSV[i] = (String)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], for docId [%s]", this._jsonPathString, inputDocIds[i]));
            }
            this._stringValuesSV[i] = value;
        }
        return this._stringValuesSV;
    }

    @Override
    public int[][] transformToIntValuesMV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initIntValuesMV(numDocs);
        String[][] valuesFromIndex = this._jsonIndexReader.getValuesMV(valueBlock.getDocIds(), valueBlock.getNumDocs(), this.getValueToMatchingDocsMap());
        for (int i = 0; i < numDocs; ++i) {
            int j;
            String[] value = valuesFromIndex[i];
            if (value.length == 0) {
                if (this._defaultValue != null) {
                    this._intValuesMV[i] = new int[((Object[])this._defaultValue).length];
                    for (j = 0; j < this._intValuesMV[i].length; ++j) {
                        this._intValuesMV[i][j] = (Integer)((Object[])this._defaultValue)[j];
                    }
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], for docId [%s]", this._jsonPathString, valueBlock.getDocIds()[i]));
            }
            this._intValuesMV[i] = new int[value.length];
            for (j = 0; j < value.length; ++j) {
                this._intValuesMV[i][j] = Integer.parseInt(value[j]);
            }
        }
        return this._intValuesMV;
    }

    @Override
    public long[][] transformToLongValuesMV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initLongValuesMV(numDocs);
        String[][] valuesFromIndex = this._jsonIndexReader.getValuesMV(valueBlock.getDocIds(), valueBlock.getNumDocs(), this.getValueToMatchingDocsMap());
        for (int i = 0; i < numDocs; ++i) {
            int j;
            String[] value = valuesFromIndex[i];
            if (value.length == 0) {
                if (this._defaultValue != null) {
                    this._longValuesMV[i] = new long[((Object[])this._defaultValue).length];
                    for (j = 0; j < this._longValuesMV[i].length; ++j) {
                        this._longValuesMV[i][j] = (Long)((Object[])this._defaultValue)[j];
                    }
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], for docId [%s]", this._jsonPathString, valueBlock.getDocIds()[i]));
            }
            this._longValuesMV[i] = new long[value.length];
            for (j = 0; j < value.length; ++j) {
                this._longValuesMV[i][j] = Long.parseLong(value[j]);
            }
        }
        return this._longValuesMV;
    }

    @Override
    public float[][] transformToFloatValuesMV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initFloatValuesMV(numDocs);
        String[][] valuesFromIndex = this._jsonIndexReader.getValuesMV(valueBlock.getDocIds(), valueBlock.getNumDocs(), this.getValueToMatchingDocsMap());
        for (int i = 0; i < numDocs; ++i) {
            int j;
            String[] value = valuesFromIndex[i];
            if (value.length == 0) {
                if (this._defaultValue != null) {
                    this._floatValuesMV[i] = new float[((Object[])this._defaultValue).length];
                    for (j = 0; j < this._floatValuesMV[i].length; ++j) {
                        this._floatValuesMV[i][j] = ((Float)((Object[])this._defaultValue)[j]).floatValue();
                    }
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], for docId [%s]", this._jsonPathString, valueBlock.getDocIds()[i]));
            }
            this._floatValuesMV[i] = new float[value.length];
            for (j = 0; j < value.length; ++j) {
                this._floatValuesMV[i][j] = Float.parseFloat(value[j]);
            }
        }
        return this._floatValuesMV;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initDoubleValuesMV(numDocs);
        String[][] valuesFromIndex = this._jsonIndexReader.getValuesMV(valueBlock.getDocIds(), valueBlock.getNumDocs(), this.getValueToMatchingDocsMap());
        for (int i = 0; i < numDocs; ++i) {
            int j;
            String[] value = valuesFromIndex[i];
            if (value.length == 0) {
                if (this._defaultValue != null) {
                    this._doubleValuesMV[i] = new double[((Object[])this._defaultValue).length];
                    for (j = 0; j < this._doubleValuesMV[i].length; ++j) {
                        this._doubleValuesMV[i][j] = (Double)((Object[])this._defaultValue)[j];
                    }
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], for docId [%s]", this._jsonPathString, valueBlock.getDocIds()[i]));
            }
            this._doubleValuesMV[i] = new double[value.length];
            for (j = 0; j < value.length; ++j) {
                this._doubleValuesMV[i][j] = Double.parseDouble(value[j]);
            }
        }
        return this._doubleValuesMV;
    }

    @Override
    public String[][] transformToStringValuesMV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initStringValuesMV(numDocs);
        String[][] valuesFromIndex = this._jsonIndexReader.getValuesMV(valueBlock.getDocIds(), valueBlock.getNumDocs(), this.getValueToMatchingDocsMap());
        for (int i = 0; i < numDocs; ++i) {
            String[] value = valuesFromIndex[i];
            if (value.length == 0) {
                if (this._defaultValue != null) {
                    this._stringValuesMV[i] = new String[((Object[])this._defaultValue).length];
                    for (int j = 0; j < this._stringValuesMV[i].length; ++j) {
                        this._stringValuesMV[i][j] = (String)((Object[])this._defaultValue)[j];
                    }
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], for docId [%s]", this._jsonPathString, valueBlock.getDocIds()[i]));
            }
            this._stringValuesMV[i] = new String[value.length];
            System.arraycopy(value, 0, this._stringValuesMV[i], 0, value.length);
        }
        return this._stringValuesMV;
    }

    private Map<String, RoaringBitmap> getValueToMatchingDocsMap() {
        if (this._valueToMatchingDocsMap == null) {
            this._valueToMatchingDocsMap = this._jsonIndexReader.getMatchingFlattenedDocsMap(this._jsonPathString, this._filterJsonPath);
            if (this._isSingleValue) {
                this._jsonIndexReader.convertFlattenedDocIdsToDocIds(this._valueToMatchingDocsMap);
            }
        }
        return this._valueToMatchingDocsMap;
    }
}

