/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.JsonPathCache;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.PushDownTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.evaluator.TransformEvaluator;
import org.apache.pinot.segment.spi.evaluator.json.JsonPathEvaluator;
import org.apache.pinot.segment.spi.evaluator.json.JsonPathEvaluators;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.JsonUtils;

public class JsonExtractScalarTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "jsonExtractScalar";
    private static final ObjectMapper OBJECT_MAPPER_WITH_BIG_DECIMAL = new ObjectMapper().configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    private static final ParseContext JSON_PARSER_CONTEXT_WITH_BIG_DECIMAL = JsonPath.using((Configuration)new Configuration.ConfigurationBuilder().jsonProvider((JsonProvider)new JacksonJsonProvider(OBJECT_MAPPER_WITH_BIG_DECIMAL)).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build());
    private static final ParseContext JSON_PARSER_CONTEXT = JsonPath.using((Configuration)new Configuration.ConfigurationBuilder().jsonProvider((JsonProvider)new JacksonJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build());
    private TransformFunction _jsonFieldTransformFunction;
    private String _jsonPathString;
    private JsonPath _jsonPath;
    private Object _defaultValue;
    private JsonPathEvaluator _jsonPathEvaluator;
    private TransformResultMetadata _resultMetadata;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        FieldSpec.DataType dataType;
        super.init(arguments, columnContextMap);
        if (arguments.size() < 3 || arguments.size() > 4) {
            throw new IllegalArgumentException("Expected 3/4 arguments for transform function: jsonExtractScalar(jsonFieldName, 'jsonPath', 'resultsType', ['defaultValue'])");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || !firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The first argument of jsonExtractScalar transform function must be a single-valued column or a transform function");
        }
        this._jsonFieldTransformFunction = firstArgument;
        this._jsonPathString = ((LiteralTransformFunction)arguments.get(1)).getStringLiteral();
        String resultsType = ((LiteralTransformFunction)arguments.get(2)).getStringLiteral().toUpperCase();
        boolean isSingleValue = !resultsType.endsWith("_ARRAY");
        try {
            dataType = FieldSpec.DataType.valueOf((String)(isSingleValue ? resultsType : resultsType.substring(0, resultsType.length() - 6)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Unsupported results type: %s for jsonExtractScalar function. Supported types are: INT/LONG/FLOAT/DOUBLE/BOOLEAN/BIG_DECIMAL/TIMESTAMP/STRING/INT_ARRAY/LONG_ARRAY/FLOAT_ARRAY/DOUBLE_ARRAY/STRING_ARRAY", resultsType));
        }
        if (arguments.size() == 4) {
            this._defaultValue = dataType.convert(((LiteralTransformFunction)arguments.get(3)).getStringLiteral());
        }
        this._resultMetadata = new TransformResultMetadata(dataType, isSingleValue, false);
        try {
            this._jsonPathEvaluator = JsonPathEvaluators.create((String)this._jsonPathString, (Object)this._defaultValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid json path: " + this._jsonPathString, e);
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        this.initIntValuesSV(valueBlock.getNumDocs());
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction && valueBlock instanceof ProjectionBlock) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToIntValuesSV((ProjectionBlock)valueBlock, (TransformEvaluator)this._jsonPathEvaluator, this._intValuesSV);
            return this._intValuesSV;
        }
        return this.transformTransformedValuesToIntValuesSV(valueBlock);
    }

    private int[] transformTransformedValuesToIntValuesSV(ValueBlock valueBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(valueBlock);
        int numDocs = valueBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._intValuesSV[i] = (Integer)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPathString, jsonStrings[i]));
            }
            this._intValuesSV[i] = result instanceof Number ? ((Number)result).intValue() : Integer.parseInt(result.toString());
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        this.initLongValuesSV(valueBlock.getNumDocs());
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction && valueBlock instanceof ProjectionBlock) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToLongValuesSV((ProjectionBlock)valueBlock, (TransformEvaluator)this._jsonPathEvaluator, this._longValuesSV);
            return this._longValuesSV;
        }
        return this.transformTransformedValuesToLongValuesSV(valueBlock);
    }

    private long[] transformTransformedValuesToLongValuesSV(ValueBlock valueBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(valueBlock);
        int numDocs = valueBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._longValuesSV[i] = (Long)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPathString, jsonStrings[i]));
            }
            this._longValuesSV[i] = result instanceof Number ? ((Number)result).longValue() : (long)Double.parseDouble(result.toString());
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ValueBlock valueBlock) {
        this.initFloatValuesSV(valueBlock.getNumDocs());
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction && valueBlock instanceof ProjectionBlock) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToFloatValuesSV((ProjectionBlock)valueBlock, (TransformEvaluator)this._jsonPathEvaluator, this._floatValuesSV);
            return this._floatValuesSV;
        }
        return this.transformTransformedValuesToFloatValuesSV(valueBlock);
    }

    private float[] transformTransformedValuesToFloatValuesSV(ValueBlock valueBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(valueBlock);
        int numDocs = valueBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._floatValuesSV[i] = ((Float)this._defaultValue).floatValue();
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPathString, jsonStrings[i]));
            }
            this._floatValuesSV[i] = result instanceof Number ? ((Number)result).floatValue() : Float.parseFloat(result.toString());
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        this.initDoubleValuesSV(valueBlock.getNumDocs());
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction && valueBlock instanceof ProjectionBlock) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToDoubleValuesSV((ProjectionBlock)valueBlock, (TransformEvaluator)this._jsonPathEvaluator, this._doubleValuesSV);
            return this._doubleValuesSV;
        }
        return this.transformTransformedValuesToDoubleValuesSV(valueBlock);
    }

    private double[] transformTransformedValuesToDoubleValuesSV(ValueBlock valueBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(valueBlock);
        int numDocs = valueBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._doubleValuesSV[i] = (Double)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPathString, jsonStrings[i]));
            }
            this._doubleValuesSV[i] = result instanceof Number ? ((Number)result).doubleValue() : Double.parseDouble(result.toString());
        }
        return this._doubleValuesSV;
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ValueBlock valueBlock) {
        this.initBigDecimalValuesSV(valueBlock.getNumDocs());
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction && valueBlock instanceof ProjectionBlock) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToBigDecimalValuesSV((ProjectionBlock)valueBlock, (TransformEvaluator)this._jsonPathEvaluator, this._bigDecimalValuesSV);
            return this._bigDecimalValuesSV;
        }
        return this.transformTransformedValuesToBigDecimalValuesSV(valueBlock);
    }

    private BigDecimal[] transformTransformedValuesToBigDecimalValuesSV(ValueBlock valueBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(valueBlock);
        int numDocs = valueBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT_WITH_BIG_DECIMAL.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._bigDecimalValuesSV[i] = (BigDecimal)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPathString, jsonStrings[i]));
            }
            this._bigDecimalValuesSV[i] = result instanceof Number ? (BigDecimal)result : new BigDecimal(result.toString());
        }
        return this._bigDecimalValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        this.initStringValuesSV(valueBlock.getNumDocs());
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction && valueBlock instanceof ProjectionBlock) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToStringValuesSV((ProjectionBlock)valueBlock, (TransformEvaluator)this._jsonPathEvaluator, this._stringValuesSV);
            return this._stringValuesSV;
        }
        return this.transformTransformedValuesToStringValuesSV(valueBlock);
    }

    private String[] transformTransformedValuesToStringValuesSV(ValueBlock valueBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(valueBlock);
        int numDocs = valueBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT_WITH_BIG_DECIMAL.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._stringValuesSV[i] = (String)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPathString, jsonStrings[i]));
            }
            this._stringValuesSV[i] = result instanceof String ? (String)result : JsonUtils.objectToJsonNode((Object)result).toString();
        }
        return this._stringValuesSV;
    }

    @Override
    public int[][] transformToIntValuesMV(ValueBlock valueBlock) {
        this.initIntValuesMV(valueBlock.getNumDocs());
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction && valueBlock instanceof ProjectionBlock) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToIntValuesMV((ProjectionBlock)valueBlock, (TransformEvaluator)this._jsonPathEvaluator, this._intValuesMV);
            return this._intValuesMV;
        }
        return this.transformTransformedValuesToIntValuesMV(valueBlock);
    }

    private int[][] transformTransformedValuesToIntValuesMV(ValueBlock valueBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(valueBlock);
        int numDocs = valueBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            List result = null;
            try {
                result = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._intValuesMV[i] = new int[0];
                continue;
            }
            int numValues = result.size();
            int[] values = new int[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (Integer)result.get(j);
            }
            this._intValuesMV[i] = values;
        }
        return this._intValuesMV;
    }

    @Override
    public long[][] transformToLongValuesMV(ValueBlock valueBlock) {
        this.initLongValuesMV(valueBlock.getNumDocs());
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction && valueBlock instanceof ProjectionBlock) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToLongValuesMV((ProjectionBlock)valueBlock, (TransformEvaluator)this._jsonPathEvaluator, this._longValuesMV);
            return this._longValuesMV;
        }
        return this.transformTransformedValuesToLongValuesMV(valueBlock);
    }

    private long[][] transformTransformedValuesToLongValuesMV(ValueBlock valueBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(valueBlock);
        int length = valueBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._longValuesMV[i] = new long[0];
                continue;
            }
            int numValues = result.size();
            long[] values = new long[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (Long)result.get(j);
            }
            this._longValuesMV[i] = values;
        }
        return this._longValuesMV;
    }

    @Override
    public float[][] transformToFloatValuesMV(ValueBlock valueBlock) {
        this.initFloatValuesMV(valueBlock.getNumDocs());
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction && valueBlock instanceof ProjectionBlock) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToFloatValuesMV((ProjectionBlock)valueBlock, (TransformEvaluator)this._jsonPathEvaluator, this._floatValuesMV);
            return this._floatValuesMV;
        }
        return this.transformTransformedValuesToFloatValuesMV(valueBlock);
    }

    private float[][] transformTransformedValuesToFloatValuesMV(ValueBlock valueBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(valueBlock);
        int length = valueBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._floatValuesMV[i] = new float[0];
                continue;
            }
            int numValues = result.size();
            float[] values = new float[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = ((Float)result.get(j)).floatValue();
            }
            this._floatValuesMV[i] = values;
        }
        return this._floatValuesMV;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ValueBlock valueBlock) {
        this.initDoubleValuesMV(valueBlock.getNumDocs());
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction && valueBlock instanceof ProjectionBlock) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToDoubleValuesMV((ProjectionBlock)valueBlock, (TransformEvaluator)this._jsonPathEvaluator, this._doubleValuesMV);
            return this._doubleValuesMV;
        }
        return this.transformTransformedToDoubleValuesMV(valueBlock);
    }

    private double[][] transformTransformedToDoubleValuesMV(ValueBlock valueBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(valueBlock);
        int length = valueBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._doubleValuesMV[i] = new double[0];
                continue;
            }
            int numValues = result.size();
            double[] values = new double[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (Double)result.get(j);
            }
            this._doubleValuesMV[i] = values;
        }
        return this._doubleValuesMV;
    }

    @Override
    public String[][] transformToStringValuesMV(ValueBlock valueBlock) {
        this.initStringValuesMV(valueBlock.getNumDocs());
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction && valueBlock instanceof ProjectionBlock) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToStringValuesMV((ProjectionBlock)valueBlock, (TransformEvaluator)this._jsonPathEvaluator, this._stringValuesMV);
            return this._stringValuesMV;
        }
        return this.transformTransformedValuesToStringValuesMV(valueBlock);
    }

    private String[][] transformTransformedValuesToStringValuesMV(ValueBlock valueBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(valueBlock);
        int length = valueBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._stringValuesMV[i] = new String[0];
                continue;
            }
            int numValues = result.size();
            String[] values = new String[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (String)result.get(j);
            }
            this._stringValuesMV[i] = values;
        }
        return this._stringValuesMV;
    }

    private void ensureJsonPathCompiled() {
        if (this._jsonPath == null) {
            this._jsonPath = JsonPathCache.INSTANCE.getOrCompute(this._jsonPathString);
        }
    }
}

