/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.LiteralContext;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.roaringbitmap.RoaringBitmap;

public class LiteralTransformFunction
implements TransformFunction {
    public static final String FUNCTION_NAME = "literal";
    private final LiteralContext _literalContext;
    private int[] _intResult;
    private long[] _longResult;
    private float[] _floatResult;
    private double[] _doubleResult;
    private BigDecimal[] _bigDecimalResult;
    private String[] _stringResult;
    private byte[][] _bytesResult;

    public LiteralTransformFunction(LiteralContext literalContext) {
        this._literalContext = literalContext;
    }

    public boolean getBooleanLiteral() {
        return this._literalContext.getBooleanValue();
    }

    public int getIntLiteral() {
        return this._literalContext.getIntValue();
    }

    public long getLongLiteral() {
        return this._literalContext.getLongValue();
    }

    public float getFloatLiteral() {
        return this._literalContext.getFloatValue();
    }

    public double getDoubleLiteral() {
        return this._literalContext.getDoubleValue();
    }

    public BigDecimal getBigDecimalLiteral() {
        return this._literalContext.getBigDecimalValue();
    }

    public String getStringLiteral() {
        return this._literalContext.getStringValue();
    }

    public byte[] getBytesLiteral() {
        return this._literalContext.getBytesValue();
    }

    public boolean isNull() {
        return this._literalContext.isNull();
    }

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return new TransformResultMetadata(this._literalContext.getType(), true, false);
    }

    @Override
    public Dictionary getDictionary() {
        return null;
    }

    @Override
    public int[] transformToDictIdsSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] transformToDictIdsMV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        int[] intResult = this._intResult;
        if (intResult == null || intResult.length < numDocs) {
            int intValue = this.getIntLiteral();
            intResult = new int[numDocs];
            if (intValue != 0) {
                Arrays.fill(intResult, intValue);
            }
            this._intResult = intResult;
        }
        return intResult;
    }

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        long[] longResult = this._longResult;
        if (longResult == null || longResult.length < numDocs) {
            long longValue = this.getLongLiteral();
            longResult = new long[numDocs];
            if (longValue != 0L) {
                Arrays.fill(longResult, longValue);
            }
            this._longResult = longResult;
        }
        return longResult;
    }

    @Override
    public float[] transformToFloatValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        float[] floatResult = this._floatResult;
        if (floatResult == null || floatResult.length < numDocs) {
            float floatValue = this.getFloatLiteral();
            floatResult = new float[numDocs];
            if (floatValue != 0.0f) {
                Arrays.fill(floatResult, floatValue);
            }
            this._floatResult = floatResult;
        }
        return floatResult;
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        double[] doubleResult = this._doubleResult;
        if (doubleResult == null || doubleResult.length < numDocs) {
            double doubleValue = this.getDoubleLiteral();
            doubleResult = new double[numDocs];
            if (doubleValue != 0.0) {
                Arrays.fill(doubleResult, doubleValue);
            }
            this._doubleResult = doubleResult;
        }
        return doubleResult;
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        Object[] bigDecimalResult = this._bigDecimalResult;
        if (bigDecimalResult == null || bigDecimalResult.length < numDocs) {
            bigDecimalResult = new BigDecimal[numDocs];
            Arrays.fill(bigDecimalResult, this.getBigDecimalLiteral());
            this._bigDecimalResult = bigDecimalResult;
        }
        return bigDecimalResult;
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        Object[] stringResult = this._stringResult;
        if (stringResult == null || stringResult.length < numDocs) {
            stringResult = new String[numDocs];
            Arrays.fill(stringResult, this.getStringLiteral());
            this._stringResult = stringResult;
        }
        return stringResult;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        Object bytesResult = this._bytesResult;
        if (bytesResult == null || ((byte[][])bytesResult).length < numDocs) {
            bytesResult = new byte[numDocs][];
            Arrays.fill((Object[])bytesResult, this.getBytesLiteral());
            this._bytesResult = bytesResult;
        }
        return bytesResult;
    }

    @Override
    public int[][] transformToIntValuesMV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[][] transformToLongValuesMV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[][] transformToFloatValuesMV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[][] transformToDoubleValuesMV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[][] transformToStringValuesMV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[][][] transformToBytesValuesMV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public RoaringBitmap getNullBitmap(ValueBlock valueBlock) {
        if (!this.isNull()) {
            return null;
        }
        int length = valueBlock.getNumDocs();
        RoaringBitmap bitmap = new RoaringBitmap();
        bitmap.add(0L, (long)length);
        return bitmap;
    }
}

