/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.spi.data.FieldSpec;
import org.glassfish.jersey.internal.guava.Preconditions;
import org.roaringbitmap.RoaringBitmap;

public abstract class LogicalOperatorTransformFunction
extends BaseTransformFunction {
    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        int numArguments = arguments.size();
        if (numArguments <= 1) {
            throw new IllegalArgumentException("Expect more than 1 argument for logical operator [" + this.getName() + "], args [" + Arrays.toString(arguments.toArray()) + "].");
        }
        for (int i = 0; i < numArguments; ++i) {
            TransformResultMetadata argumentMetadata = arguments.get(i).getResultMetadata();
            FieldSpec.DataType storedType = argumentMetadata.getDataType().getStoredType();
            Preconditions.checkState((argumentMetadata.isSingleValue() && storedType.isNumeric() || storedType.isUnknown() ? 1 : 0) != 0, (Object)"Unsupported argument type. Expecting single-valued boolean/number");
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BOOLEAN_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initIntValuesSV(numDocs);
        System.arraycopy(((TransformFunction)this._arguments.get(0)).transformToIntValuesSV(valueBlock), 0, this._intValuesSV, 0, numDocs);
        int numArguments = this._arguments.size();
        for (int i = 1; i < numArguments; ++i) {
            TransformFunction transformFunction = (TransformFunction)this._arguments.get(i);
            int[] results = transformFunction.transformToIntValuesSV(valueBlock);
            for (int j = 0; j < numDocs; ++j) {
                this._intValuesSV[j] = this.getLogicalFuncResult(this._intValuesSV[j], results[j]);
            }
        }
        return this._intValuesSV;
    }

    @Override
    @Nullable
    public RoaringBitmap getNullBitmap(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        int numArguments = this._arguments.size();
        RoaringBitmap nullBitmap = new RoaringBitmap();
        boolean[] supersedesNull = new boolean[numDocs];
        for (int i = 0; i < numArguments; ++i) {
            int[] intValues = ((TransformFunction)this._arguments.get(i)).transformToIntValuesSV(valueBlock);
            RoaringBitmap argumentNullBitmap = ((TransformFunction)this._arguments.get(i)).getNullBitmap(valueBlock);
            for (int docId = 0; docId < numDocs; ++docId) {
                if (argumentNullBitmap != null && argumentNullBitmap.contains(docId) || !this.valueSupersedesNull(intValues[docId])) continue;
                supersedesNull[docId] = true;
                nullBitmap.remove(docId);
            }
            if (argumentNullBitmap == null) continue;
            Iterator iterator = argumentNullBitmap.iterator();
            while (iterator.hasNext()) {
                int docId = (Integer)iterator.next();
                if (supersedesNull[docId]) continue;
                nullBitmap.add(docId);
            }
        }
        return nullBitmap.isEmpty() ? null : nullBitmap;
    }

    abstract int getLogicalFuncResult(int var1, int var2);

    abstract boolean valueSupersedesNull(int var1);
}

