/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.index.reader.Dictionary;

public class MapValueTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "mapValue";
    private TransformFunction _keyColumnFunction;
    private int _keyDictId;
    private TransformFunction _valueColumnFunction;
    private Dictionary _valueColumnDictionary;
    private TransformResultMetadata _resultMetadata;
    private int[] _dictIds;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        Preconditions.checkArgument((arguments.size() == 3 ? 1 : 0) != 0, (Object)"3 arguments are required for MAP_VALUE transform function: keyColumn, keyValue, valueColumn, e.g. MAP_VALUE(key, 'myKey', value)");
        this._keyColumnFunction = arguments.get(0);
        TransformResultMetadata keyColumnMetadata = this._keyColumnFunction.getResultMetadata();
        Dictionary keyColumnDictionary = this._keyColumnFunction.getDictionary();
        Preconditions.checkState((!keyColumnMetadata.isSingleValue() && keyColumnDictionary != null ? 1 : 0) != 0, (Object)"Key column must be dictionary-encoded multi-value column");
        TransformFunction keyValueFunction = arguments.get(1);
        Preconditions.checkState((boolean)(keyValueFunction instanceof LiteralTransformFunction), (Object)"Key value must be a literal (number or string)");
        String keyValue = ((LiteralTransformFunction)keyValueFunction).getStringLiteral();
        this._keyDictId = keyColumnDictionary.indexOf(keyValue);
        this._valueColumnFunction = arguments.get(2);
        TransformResultMetadata valueColumnMetadata = this._valueColumnFunction.getResultMetadata();
        this._valueColumnDictionary = this._valueColumnFunction.getDictionary();
        Preconditions.checkState((!valueColumnMetadata.isSingleValue() && this._valueColumnDictionary != null ? 1 : 0) != 0, (Object)"Value column must be dictionary-encoded multi-value column");
        this._resultMetadata = new TransformResultMetadata(valueColumnMetadata.getDataType(), true, true);
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public Dictionary getDictionary() {
        return this._valueColumnDictionary;
    }

    @Override
    public int[] transformToDictIdsSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        if (this._dictIds == null || this._dictIds.length < length) {
            this._dictIds = new int[length];
        }
        int[][] keyDictIdsMV = this._keyColumnFunction.transformToDictIdsMV(valueBlock);
        int[][] valueDictIdsMV = this._valueColumnFunction.transformToDictIdsMV(valueBlock);
        for (int i = 0; i < length; ++i) {
            int[] keyDictIds = keyDictIdsMV[i];
            int valueDictId = -1;
            int numValues = keyDictIds.length;
            for (int j = 0; j < numValues; ++j) {
                if (keyDictIds[j] != this._keyDictId) continue;
                valueDictId = valueDictIdsMV[i][j];
                break;
            }
            this._dictIds[i] = valueDictId;
        }
        return this._dictIds;
    }
}

