/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;

public class ModuloTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "mod";
    private double _firstLiteral;
    private TransformFunction _firstTransformFunction;
    private double _secondLiteral;
    private TransformFunction _secondTransformFunction;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Exactly 2 arguments are required for MOD transform function");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction) {
            this._firstLiteral = ((LiteralTransformFunction)firstArgument).getDoubleLiteral();
        } else {
            if (!firstArgument.getResultMetadata().isSingleValue()) {
                throw new IllegalArgumentException("First argument of MOD transform function must be single-valued");
            }
            this._firstTransformFunction = firstArgument;
        }
        TransformFunction secondArgument = arguments.get(1);
        if (secondArgument instanceof LiteralTransformFunction) {
            this._secondLiteral = ((LiteralTransformFunction)secondArgument).getDoubleLiteral();
        } else {
            if (!secondArgument.getResultMetadata().isSingleValue()) {
                throw new IllegalArgumentException("Second argument of MOD transform function must be single-valued");
            }
            this._secondTransformFunction = secondArgument;
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        double[] values;
        int length = valueBlock.getNumDocs();
        this.initDoubleValuesSV(length);
        if (this._firstTransformFunction == null) {
            Arrays.fill(this._doubleValuesSV, 0, length, this._firstLiteral);
        } else {
            values = this._firstTransformFunction.transformToDoubleValuesSV(valueBlock);
            System.arraycopy(values, 0, this._doubleValuesSV, 0, length);
        }
        if (this._secondTransformFunction == null) {
            int i = 0;
            while (i < length) {
                int n = i++;
                this._doubleValuesSV[n] = this._doubleValuesSV[n] % this._secondLiteral;
            }
        } else {
            values = this._secondTransformFunction.transformToDoubleValuesSV(valueBlock);
            for (int i = 0; i < length; ++i) {
                int n = i;
                this._doubleValuesSV[n] = this._doubleValuesSV[n] % values[i];
            }
        }
        return this._doubleValuesSV;
    }
}

