/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ArrayCopyUtils;

public class MultiplicationTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "mult";
    private final List<TransformFunction> _transformFunctions = new ArrayList<TransformFunction>();
    private FieldSpec.DataType _resultDataType;
    private double _literalDoubleProduct = 1.0;
    private BigDecimal _literalBigDecimalProduct = BigDecimal.ONE;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        if (arguments.size() < 2) {
            throw new IllegalArgumentException("At least 2 arguments are required for MULT transform function");
        }
        this._resultDataType = FieldSpec.DataType.DOUBLE;
        for (TransformFunction argument : arguments) {
            if (argument instanceof LiteralTransformFunction) {
                LiteralTransformFunction literalTransformFunction = (LiteralTransformFunction)argument;
                FieldSpec.DataType dataType = literalTransformFunction.getResultMetadata().getDataType();
                if (dataType == FieldSpec.DataType.BIG_DECIMAL) {
                    this._literalBigDecimalProduct = this._literalBigDecimalProduct.multiply(literalTransformFunction.getBigDecimalLiteral());
                    this._resultDataType = FieldSpec.DataType.BIG_DECIMAL;
                    continue;
                }
                this._literalDoubleProduct *= ((LiteralTransformFunction)argument).getDoubleLiteral();
                continue;
            }
            if (!argument.getResultMetadata().isSingleValue()) {
                throw new IllegalArgumentException("All the arguments of MULT transform function must be single-valued");
            }
            if (argument.getResultMetadata().getDataType() == FieldSpec.DataType.BIG_DECIMAL) {
                this._resultDataType = FieldSpec.DataType.BIG_DECIMAL;
            }
            this._transformFunctions.add(argument);
        }
        if (this._resultDataType == FieldSpec.DataType.BIG_DECIMAL) {
            this._literalBigDecimalProduct = this._literalBigDecimalProduct.multiply(BigDecimal.valueOf(this._literalDoubleProduct));
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        if (this._resultDataType == FieldSpec.DataType.BIG_DECIMAL) {
            return BIG_DECIMAL_SV_NO_DICTIONARY_METADATA;
        }
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initDoubleValuesSV(length);
        if (this._resultDataType == FieldSpec.DataType.BIG_DECIMAL) {
            BigDecimal[] values = this.transformToBigDecimalValuesSV(valueBlock);
            ArrayCopyUtils.copy((BigDecimal[])values, (double[])this._doubleValuesSV, (int)length);
        } else {
            Arrays.fill(this._doubleValuesSV, 0, length, this._literalDoubleProduct);
            for (TransformFunction transformFunction : this._transformFunctions) {
                double[] values = transformFunction.transformToDoubleValuesSV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    int n = i;
                    this._doubleValuesSV[n] = this._doubleValuesSV[n] * values[i];
                }
            }
        }
        return this._doubleValuesSV;
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initBigDecimalValuesSV(length);
        if (this._resultDataType == FieldSpec.DataType.DOUBLE) {
            double[] values = this.transformToDoubleValuesSV(valueBlock);
            ArrayCopyUtils.copy((double[])values, (BigDecimal[])this._bigDecimalValuesSV, (int)length);
        } else {
            Arrays.fill(this._bigDecimalValuesSV, 0, length, this._literalBigDecimalProduct);
            for (TransformFunction transformFunction : this._transformFunctions) {
                BigDecimal[] values = transformFunction.transformToBigDecimalValuesSV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    this._bigDecimalValuesSV[i] = this._bigDecimalValuesSV[i].multiply(values[i]);
                }
            }
        }
        return this._bigDecimalValuesSV;
    }
}

