/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.function.InTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;

public class NotInTransformFunction
extends InTransformFunction {
    @Override
    public String getName() {
        return TransformFunctionType.NOT_IN.getName();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        int[] intValuesSV = super.transformToIntValuesSV(valueBlock);
        for (int i = 0; i < intValuesSV.length; ++i) {
            intValuesSV[i] = 1 - intValuesSV[i];
        }
        return intValuesSV;
    }

    @Override
    protected boolean mainFunctionNotContainedInValues(int value) {
        return value == 1;
    }
}

