/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.spi.data.FieldSpec;

public class NotOperatorTransformFunction
extends BaseTransformFunction {
    private TransformFunction _argument;

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0, (Object)"Exact 1 argument1 is required for not transform function");
        TransformResultMetadata argumentMetadata = arguments.get(0).getResultMetadata();
        FieldSpec.DataType storedType = argumentMetadata.getDataType().getStoredType();
        Preconditions.checkState((argumentMetadata.isSingleValue() && storedType.isNumeric() || storedType.isUnknown() ? 1 : 0) != 0, (Object)"Unsupported argument type. Expecting single-valued boolean/number");
        this._argument = arguments.get(0);
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BOOLEAN_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public String getName() {
        return TransformFunctionType.NOT.getName();
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initIntValuesSV(numDocs);
        int[] intValues = this._argument.transformToIntValuesSV(valueBlock);
        for (int i = 0; i < numDocs; ++i) {
            this._intValuesSV[i] = NotOperatorTransformFunction.getLogicalNegate(intValues[i]);
        }
        return this._intValuesSV;
    }

    private static int getLogicalNegate(int val) {
        if (val == 0) {
            return 1;
        }
        return 0;
    }
}

