/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.spi.data.FieldSpec;

public class RoundDecimalTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "roundDecimal";
    private TransformFunction _leftTransformFunction;
    private TransformFunction _rightTransformFunction;
    private int _scale;
    private boolean _fixedScale;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        int numArguments = arguments.size();
        if (numArguments < 1 || numArguments > 2) {
            throw new IllegalArgumentException("roundDecimal transform function supports either 1 or 2 arguments. Num arguments provided: " + numArguments);
        }
        this._fixedScale = false;
        this._leftTransformFunction = arguments.get(0);
        if (numArguments > 1) {
            this._rightTransformFunction = arguments.get(1);
            if (this._rightTransformFunction instanceof LiteralTransformFunction) {
                this._scale = ((LiteralTransformFunction)this._rightTransformFunction).getIntLiteral();
                this._fixedScale = true;
            }
            Preconditions.checkArgument((this._rightTransformFunction.getResultMetadata().isSingleValue() && this.isIntegralResultDatatype(this._rightTransformFunction) ? 1 : 0) != 0, (String)"Argument must be single-valued with type INT or LONG for transform function: %s", (Object)this.getName());
        } else {
            this._rightTransformFunction = null;
        }
        Preconditions.checkArgument((boolean)this._leftTransformFunction.getResultMetadata().isSingleValue(), (String)"Argument must be single-valued for transform function: %s", (Object)this.getName());
    }

    private boolean isIntegralResultDatatype(TransformFunction transformFunction) {
        return transformFunction.getResultMetadata().getDataType().getStoredType() == FieldSpec.DataType.INT || transformFunction.getResultMetadata().getDataType().getStoredType() == FieldSpec.DataType.LONG;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initDoubleValuesSV(length);
        double[] leftValues = this._leftTransformFunction.transformToDoubleValuesSV(valueBlock);
        if (this._fixedScale) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = BigDecimal.valueOf(leftValues[i]).setScale(this._scale, RoundingMode.HALF_UP).doubleValue();
            }
        } else if (this._rightTransformFunction != null) {
            int[] rightValues = this._rightTransformFunction.transformToIntValuesSV(valueBlock);
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = BigDecimal.valueOf(leftValues[i]).setScale(rightValues[i], RoundingMode.HALF_UP).doubleValue();
            }
        } else {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.round(leftValues[i]);
            }
        }
        return this._doubleValuesSV;
    }
}

