/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.spi.data.FieldSpec;

public abstract class SelectTupleElementTransformFunction
extends BaseTransformFunction {
    private static final EnumSet<FieldSpec.DataType> SUPPORTED_DATATYPES = EnumSet.of(FieldSpec.DataType.INT, new FieldSpec.DataType[]{FieldSpec.DataType.LONG, FieldSpec.DataType.FLOAT, FieldSpec.DataType.DOUBLE, FieldSpec.DataType.BIG_DECIMAL, FieldSpec.DataType.TIMESTAMP, FieldSpec.DataType.STRING, FieldSpec.DataType.UNKNOWN});
    private static final EnumMap<FieldSpec.DataType, EnumSet<FieldSpec.DataType>> ACCEPTABLE_COMBINATIONS = SelectTupleElementTransformFunction.createAcceptableCombinations();
    private final String _name;
    protected List<TransformFunction> _arguments;
    private TransformResultMetadata _resultMetadata;

    public SelectTupleElementTransformFunction(String name) {
        this._name = name;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap, boolean nullHandlingEnabled) {
        super.init(arguments, columnContextMap, nullHandlingEnabled);
        if (arguments.isEmpty()) {
            throw new IllegalArgumentException(this._name + " takes at least one argument");
        }
        FieldSpec.DataType dataType = null;
        for (int i = 0; i < arguments.size(); ++i) {
            TransformFunction argument = arguments.get(i);
            TransformResultMetadata metadata = argument.getResultMetadata();
            if (!metadata.isSingleValue()) {
                throw new IllegalArgumentException(argument.getName() + " at position " + i + " is not single value");
            }
            FieldSpec.DataType argumentType = metadata.getDataType();
            if (!SUPPORTED_DATATYPES.contains(argumentType)) {
                throw new IllegalArgumentException(argumentType + " not supported. Required one of " + SUPPORTED_DATATYPES);
            }
            if (dataType == null) {
                dataType = argumentType;
                continue;
            }
            if (dataType.isUnknown() || argumentType.isUnknown() || ACCEPTABLE_COMBINATIONS.get(dataType).contains(argumentType)) {
                dataType = SelectTupleElementTransformFunction.getLowestCommonDenominatorType(dataType, argumentType);
                continue;
            }
            throw new IllegalArgumentException("combination " + argumentType + " not supported. Required one of " + ACCEPTABLE_COMBINATIONS.get(dataType));
        }
        this._resultMetadata = new TransformResultMetadata(dataType, true, false);
        this._arguments = arguments;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public String getName() {
        return this._name;
    }

    private static FieldSpec.DataType getLowestCommonDenominatorType(FieldSpec.DataType left, FieldSpec.DataType right) {
        if (left == null || left == right) {
            return right;
        }
        if (left == FieldSpec.DataType.BIG_DECIMAL || right == FieldSpec.DataType.BIG_DECIMAL) {
            return FieldSpec.DataType.BIG_DECIMAL;
        }
        if (left == FieldSpec.DataType.DOUBLE || left == FieldSpec.DataType.FLOAT || right == FieldSpec.DataType.DOUBLE || right == FieldSpec.DataType.FLOAT) {
            return FieldSpec.DataType.DOUBLE;
        }
        return FieldSpec.DataType.LONG;
    }

    private static EnumMap<FieldSpec.DataType, EnumSet<FieldSpec.DataType>> createAcceptableCombinations() {
        EnumMap<FieldSpec.DataType, EnumSet<FieldSpec.DataType>> combinations = new EnumMap<FieldSpec.DataType, EnumSet<FieldSpec.DataType>>(FieldSpec.DataType.class);
        EnumSet<FieldSpec.DataType> numericTypes = EnumSet.of(FieldSpec.DataType.INT, FieldSpec.DataType.LONG, FieldSpec.DataType.FLOAT, FieldSpec.DataType.DOUBLE, FieldSpec.DataType.BIG_DECIMAL);
        for (FieldSpec.DataType numericType : numericTypes) {
            combinations.put(numericType, numericTypes);
        }
        combinations.put(FieldSpec.DataType.TIMESTAMP, EnumSet.of(FieldSpec.DataType.TIMESTAMP));
        combinations.put(FieldSpec.DataType.STRING, EnumSet.of(FieldSpec.DataType.STRING));
        return combinations;
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initIntValuesSV(numDocs);
        int[] values = this._arguments.get(0).transformToIntValuesSV(valueBlock);
        System.arraycopy(values, 0, this._intValuesSV, 0, numDocs);
        for (int i = 1; i < this._arguments.size(); ++i) {
            values = this._arguments.get(i).transformToIntValuesSV(valueBlock);
            int j = 0;
            while (j < numDocs & j < values.length) {
                this._intValuesSV[j] = this.binaryFunction(this._intValuesSV[j], values[j]);
                ++j;
            }
        }
        return this._intValuesSV;
    }

    protected abstract int binaryFunction(int var1, int var2);

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initLongValuesSV(numDocs);
        long[] values = this._arguments.get(0).transformToLongValuesSV(valueBlock);
        System.arraycopy(values, 0, this._longValuesSV, 0, numDocs);
        for (int i = 1; i < this._arguments.size(); ++i) {
            values = this._arguments.get(i).transformToLongValuesSV(valueBlock);
            int j = 0;
            while (j < numDocs & j < values.length) {
                this._longValuesSV[j] = this.binaryFunction(this._longValuesSV[j], values[j]);
                ++j;
            }
        }
        return this._longValuesSV;
    }

    protected abstract long binaryFunction(long var1, long var3);

    @Override
    public float[] transformToFloatValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initFloatValuesSV(numDocs);
        float[] values = this._arguments.get(0).transformToFloatValuesSV(valueBlock);
        System.arraycopy(values, 0, this._floatValuesSV, 0, numDocs);
        for (int i = 1; i < this._arguments.size(); ++i) {
            values = this._arguments.get(i).transformToFloatValuesSV(valueBlock);
            int j = 0;
            while (j < numDocs & j < values.length) {
                this._floatValuesSV[j] = this.binaryFunction(this._floatValuesSV[j], values[j]);
                ++j;
            }
        }
        return this._floatValuesSV;
    }

    protected abstract float binaryFunction(float var1, float var2);

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initDoubleValuesSV(numDocs);
        double[] values = this._arguments.get(0).transformToDoubleValuesSV(valueBlock);
        System.arraycopy(values, 0, this._doubleValuesSV, 0, numDocs);
        for (int i = 1; i < this._arguments.size(); ++i) {
            values = this._arguments.get(i).transformToDoubleValuesSV(valueBlock);
            int j = 0;
            while (j < numDocs & j < values.length) {
                this._doubleValuesSV[j] = this.binaryFunction(this._doubleValuesSV[j], values[j]);
                ++j;
            }
        }
        return this._doubleValuesSV;
    }

    protected abstract double binaryFunction(double var1, double var3);

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initBigDecimalValuesSV(numDocs);
        BigDecimal[] values = this._arguments.get(0).transformToBigDecimalValuesSV(valueBlock);
        System.arraycopy(values, 0, this._bigDecimalValuesSV, 0, numDocs);
        for (int i = 1; i < this._arguments.size(); ++i) {
            values = this._arguments.get(i).transformToBigDecimalValuesSV(valueBlock);
            int j = 0;
            while (j < numDocs & j < values.length) {
                this._bigDecimalValuesSV[j] = this.binaryFunction(this._bigDecimalValuesSV[j], values[j]);
                ++j;
            }
        }
        return this._bigDecimalValuesSV;
    }

    protected abstract BigDecimal binaryFunction(BigDecimal var1, BigDecimal var2);

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initStringValuesSV(numDocs);
        String[] values = this._arguments.get(0).transformToStringValuesSV(valueBlock);
        System.arraycopy(values, 0, this._stringValuesSV, 0, numDocs);
        for (int i = 1; i < this._arguments.size(); ++i) {
            values = this._arguments.get(i).transformToStringValuesSV(valueBlock);
            int j = 0;
            while (j < numDocs & j < values.length) {
                this._stringValuesSV[j] = this.binaryFunction(this._stringValuesSV[j], values[j]);
                ++j;
            }
        }
        return this._stringValuesSV;
    }

    protected abstract String binaryFunction(String var1, String var2);
}

