/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionRegistry;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.LiteralContext;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.core.geospatial.transform.function.GeoToH3Function;
import org.apache.pinot.core.geospatial.transform.function.StAreaFunction;
import org.apache.pinot.core.geospatial.transform.function.StAsBinaryFunction;
import org.apache.pinot.core.geospatial.transform.function.StAsTextFunction;
import org.apache.pinot.core.geospatial.transform.function.StContainsFunction;
import org.apache.pinot.core.geospatial.transform.function.StDistanceFunction;
import org.apache.pinot.core.geospatial.transform.function.StEqualsFunction;
import org.apache.pinot.core.geospatial.transform.function.StGeogFromTextFunction;
import org.apache.pinot.core.geospatial.transform.function.StGeogFromWKBFunction;
import org.apache.pinot.core.geospatial.transform.function.StGeomFromTextFunction;
import org.apache.pinot.core.geospatial.transform.function.StGeomFromWKBFunction;
import org.apache.pinot.core.geospatial.transform.function.StGeometryTypeFunction;
import org.apache.pinot.core.geospatial.transform.function.StPointFunction;
import org.apache.pinot.core.geospatial.transform.function.StPolygonFunction;
import org.apache.pinot.core.geospatial.transform.function.StWithinFunction;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.transform.function.AdditionTransformFunction;
import org.apache.pinot.core.operator.transform.function.AndOperatorTransformFunction;
import org.apache.pinot.core.operator.transform.function.ArrayAverageTransformFunction;
import org.apache.pinot.core.operator.transform.function.ArrayLengthTransformFunction;
import org.apache.pinot.core.operator.transform.function.ArrayLiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.ArrayMaxTransformFunction;
import org.apache.pinot.core.operator.transform.function.ArrayMinTransformFunction;
import org.apache.pinot.core.operator.transform.function.ArraySumTransformFunction;
import org.apache.pinot.core.operator.transform.function.CLPDecodeTransformFunction;
import org.apache.pinot.core.operator.transform.function.CaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.CastTransformFunction;
import org.apache.pinot.core.operator.transform.function.ClpEncodedVarsMatchTransformFunction;
import org.apache.pinot.core.operator.transform.function.CoalesceTransformFunction;
import org.apache.pinot.core.operator.transform.function.DateTimeConversionHopTransformFunction;
import org.apache.pinot.core.operator.transform.function.DateTimeConversionTransformFunction;
import org.apache.pinot.core.operator.transform.function.DateTimeTransformFunction;
import org.apache.pinot.core.operator.transform.function.DateTruncTransformFunction;
import org.apache.pinot.core.operator.transform.function.DivisionTransformFunction;
import org.apache.pinot.core.operator.transform.function.EqualsTransformFunction;
import org.apache.pinot.core.operator.transform.function.ExtractTransformFunction;
import org.apache.pinot.core.operator.transform.function.GreaterThanOrEqualTransformFunction;
import org.apache.pinot.core.operator.transform.function.GreaterThanTransformFunction;
import org.apache.pinot.core.operator.transform.function.GreatestTransformFunction;
import org.apache.pinot.core.operator.transform.function.GroovyTransformFunction;
import org.apache.pinot.core.operator.transform.function.IdentifierTransformFunction;
import org.apache.pinot.core.operator.transform.function.InIdSetTransformFunction;
import org.apache.pinot.core.operator.transform.function.InTransformFunction;
import org.apache.pinot.core.operator.transform.function.IsDistinctFromTransformFunction;
import org.apache.pinot.core.operator.transform.function.IsFalseTransformFunction;
import org.apache.pinot.core.operator.transform.function.IsNotDistinctFromTransformFunction;
import org.apache.pinot.core.operator.transform.function.IsNotFalseTransformFunction;
import org.apache.pinot.core.operator.transform.function.IsNotNullTransformFunction;
import org.apache.pinot.core.operator.transform.function.IsNotTrueTransformFunction;
import org.apache.pinot.core.operator.transform.function.IsNullTransformFunction;
import org.apache.pinot.core.operator.transform.function.IsTrueTransformFunction;
import org.apache.pinot.core.operator.transform.function.JsonExtractIndexTransformFunction;
import org.apache.pinot.core.operator.transform.function.JsonExtractKeyTransformFunction;
import org.apache.pinot.core.operator.transform.function.JsonExtractScalarTransformFunction;
import org.apache.pinot.core.operator.transform.function.LeastTransformFunction;
import org.apache.pinot.core.operator.transform.function.LessThanOrEqualTransformFunction;
import org.apache.pinot.core.operator.transform.function.LessThanTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.LookupTransformFunction;
import org.apache.pinot.core.operator.transform.function.MapValueTransformFunction;
import org.apache.pinot.core.operator.transform.function.ModuloTransformFunction;
import org.apache.pinot.core.operator.transform.function.MultiplicationTransformFunction;
import org.apache.pinot.core.operator.transform.function.NotEqualsTransformFunction;
import org.apache.pinot.core.operator.transform.function.NotInTransformFunction;
import org.apache.pinot.core.operator.transform.function.NotOperatorTransformFunction;
import org.apache.pinot.core.operator.transform.function.OrOperatorTransformFunction;
import org.apache.pinot.core.operator.transform.function.PowerTransformFunction;
import org.apache.pinot.core.operator.transform.function.RegexpExtractTransformFunction;
import org.apache.pinot.core.operator.transform.function.RoundDecimalTransformFunction;
import org.apache.pinot.core.operator.transform.function.ScalarTransformFunctionWrapper;
import org.apache.pinot.core.operator.transform.function.SingleParamMathTransformFunction;
import org.apache.pinot.core.operator.transform.function.SubtractionTransformFunction;
import org.apache.pinot.core.operator.transform.function.TimeConversionTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.operator.transform.function.TrigonometricTransformFunctions;
import org.apache.pinot.core.operator.transform.function.TruncateDecimalTransformFunction;
import org.apache.pinot.core.operator.transform.function.ValueInTransformFunction;
import org.apache.pinot.core.operator.transform.function.VectorTransformFunctions;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextConverterUtils;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.apache.pinot.sql.parsers.CalciteSqlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformFunctionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformFunctionFactory.class);
    private static final Map<String, Class<? extends TransformFunction>> TRANSFORM_FUNCTION_MAP = TransformFunctionFactory.createRegistry();

    private TransformFunctionFactory() {
    }

    private static Map<String, Class<? extends TransformFunction>> createRegistry() {
        EnumMap<TransformFunctionType, Class<VectorTransformFunctions.VectorNormTransformFunction>> typeToImplementation = new EnumMap<TransformFunctionType, Class<VectorTransformFunctions.VectorNormTransformFunction>>(TransformFunctionType.class);
        typeToImplementation.put(TransformFunctionType.ADD, AdditionTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.SUB, SubtractionTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.MULT, MultiplicationTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.DIV, DivisionTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.MOD, ModuloTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.ABS, SingleParamMathTransformFunction.AbsTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.CEIL, SingleParamMathTransformFunction.CeilTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.EXP, SingleParamMathTransformFunction.ExpTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.FLOOR, SingleParamMathTransformFunction.FloorTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.LOG, SingleParamMathTransformFunction.LnTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.LOG2, SingleParamMathTransformFunction.Log2TransformFunction.class);
        typeToImplementation.put(TransformFunctionType.LOG10, SingleParamMathTransformFunction.Log10TransformFunction.class);
        typeToImplementation.put(TransformFunctionType.SQRT, SingleParamMathTransformFunction.SqrtTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.SIGN, SingleParamMathTransformFunction.SignTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.POWER, PowerTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.ROUND_DECIMAL, RoundDecimalTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.TRUNCATE, TruncateDecimalTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.CAST, CastTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.JSON_EXTRACT_SCALAR, JsonExtractScalarTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.JSON_EXTRACT_KEY, JsonExtractKeyTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.TIME_CONVERT, TimeConversionTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.DATE_TIME_CONVERT, DateTimeConversionTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.DATE_TIME_CONVERT_WINDOW_HOP, DateTimeConversionHopTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.DATE_TRUNC, DateTruncTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.JSON_EXTRACT_INDEX, JsonExtractIndexTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.YEAR, DateTimeTransformFunction.Year.class);
        typeToImplementation.put(TransformFunctionType.YEAR_OF_WEEK, DateTimeTransformFunction.YearOfWeek.class);
        typeToImplementation.put(TransformFunctionType.QUARTER, DateTimeTransformFunction.Quarter.class);
        typeToImplementation.put(TransformFunctionType.MONTH_OF_YEAR, DateTimeTransformFunction.Month.class);
        typeToImplementation.put(TransformFunctionType.WEEK_OF_YEAR, DateTimeTransformFunction.WeekOfYear.class);
        typeToImplementation.put(TransformFunctionType.DAY_OF_YEAR, DateTimeTransformFunction.DayOfYear.class);
        typeToImplementation.put(TransformFunctionType.DAY_OF_MONTH, DateTimeTransformFunction.DayOfMonth.class);
        typeToImplementation.put(TransformFunctionType.DAY_OF_WEEK, DateTimeTransformFunction.DayOfWeek.class);
        typeToImplementation.put(TransformFunctionType.HOUR, DateTimeTransformFunction.Hour.class);
        typeToImplementation.put(TransformFunctionType.MINUTE, DateTimeTransformFunction.Minute.class);
        typeToImplementation.put(TransformFunctionType.SECOND, DateTimeTransformFunction.Second.class);
        typeToImplementation.put(TransformFunctionType.MILLISECOND, DateTimeTransformFunction.Millisecond.class);
        typeToImplementation.put(TransformFunctionType.ARRAY_LENGTH, ArrayLengthTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.VALUE_IN, ValueInTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.MAP_VALUE, MapValueTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.IN_ID_SET, InIdSetTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.LOOKUP, LookupTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.CLP_DECODE, CLPDecodeTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.CLP_ENCODED_VARS_MATCH, ClpEncodedVarsMatchTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.EXTRACT, ExtractTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.REGEXP_EXTRACT, RegexpExtractTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.ARRAY_AVERAGE, ArrayAverageTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.ARRAY_MAX, ArrayMaxTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.ARRAY_MIN, ArrayMinTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.ARRAY_SUM, ArraySumTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.ARRAY_VALUE_CONSTRUCTOR, ArrayLiteralTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.GROOVY, GroovyTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.CASE, CaseTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.EQUALS, EqualsTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.NOT_EQUALS, NotEqualsTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.GREATER_THAN, GreaterThanTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.GREATER_THAN_OR_EQUAL, GreaterThanOrEqualTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.LESS_THAN, LessThanTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.LESS_THAN_OR_EQUAL, LessThanOrEqualTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.IN, InTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.NOT_IN, NotInTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.AND, AndOperatorTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.OR, OrOperatorTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.NOT, NotOperatorTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.ST_GEOG_FROM_TEXT, StGeogFromTextFunction.class);
        typeToImplementation.put(TransformFunctionType.ST_GEOG_FROM_WKB, StGeogFromWKBFunction.class);
        typeToImplementation.put(TransformFunctionType.ST_GEOM_FROM_TEXT, StGeomFromTextFunction.class);
        typeToImplementation.put(TransformFunctionType.ST_GEOM_FROM_WKB, StGeomFromWKBFunction.class);
        typeToImplementation.put(TransformFunctionType.ST_POINT, StPointFunction.class);
        typeToImplementation.put(TransformFunctionType.ST_POLYGON, StPolygonFunction.class);
        typeToImplementation.put(TransformFunctionType.ST_AREA, StAreaFunction.class);
        typeToImplementation.put(TransformFunctionType.ST_DISTANCE, StDistanceFunction.class);
        typeToImplementation.put(TransformFunctionType.ST_GEOMETRY_TYPE, StGeometryTypeFunction.class);
        typeToImplementation.put(TransformFunctionType.ST_AS_BINARY, StAsBinaryFunction.class);
        typeToImplementation.put(TransformFunctionType.ST_AS_TEXT, StAsTextFunction.class);
        typeToImplementation.put(TransformFunctionType.ST_CONTAINS, StContainsFunction.class);
        typeToImplementation.put(TransformFunctionType.ST_EQUALS, StEqualsFunction.class);
        typeToImplementation.put(TransformFunctionType.ST_WITHIN, StWithinFunction.class);
        typeToImplementation.put(TransformFunctionType.GEO_TO_H3, GeoToH3Function.class);
        typeToImplementation.put(TransformFunctionType.LEAST, LeastTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.GREATEST, GreatestTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.IS_TRUE, IsTrueTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.IS_NOT_TRUE, IsNotTrueTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.IS_FALSE, IsFalseTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.IS_NOT_FALSE, IsNotFalseTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.IS_NULL, IsNullTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.IS_NOT_NULL, IsNotNullTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.COALESCE, CoalesceTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.IS_DISTINCT_FROM, IsDistinctFromTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.IS_NOT_DISTINCT_FROM, IsNotDistinctFromTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.SIN, TrigonometricTransformFunctions.SinTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.COS, TrigonometricTransformFunctions.CosTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.TAN, TrigonometricTransformFunctions.TanTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.COT, TrigonometricTransformFunctions.CotTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.ASIN, TrigonometricTransformFunctions.AsinTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.ACOS, TrigonometricTransformFunctions.AcosTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.ATAN, TrigonometricTransformFunctions.AtanTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.ATAN2, TrigonometricTransformFunctions.Atan2TransformFunction.class);
        typeToImplementation.put(TransformFunctionType.SINH, TrigonometricTransformFunctions.SinhTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.COSH, TrigonometricTransformFunctions.CoshTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.TANH, TrigonometricTransformFunctions.TanhTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.DEGREES, TrigonometricTransformFunctions.DegreesTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.RADIANS, TrigonometricTransformFunctions.RadiansTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.COSINE_DISTANCE, VectorTransformFunctions.CosineDistanceTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.INNER_PRODUCT, VectorTransformFunctions.InnerProductTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.L1_DISTANCE, VectorTransformFunctions.L1DistanceTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.L2_DISTANCE, VectorTransformFunctions.L2DistanceTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.VECTOR_DIMS, VectorTransformFunctions.VectorDimsTransformFunction.class);
        typeToImplementation.put(TransformFunctionType.VECTOR_NORM, VectorTransformFunctions.VectorNormTransformFunction.class);
        HashMap<String, Class<? extends TransformFunction>> registry = new HashMap<String, Class<? extends TransformFunction>>(HashUtil.getHashMapCapacity((int)typeToImplementation.size()));
        for (Map.Entry entry : typeToImplementation.entrySet()) {
            for (String alias : ((TransformFunctionType)entry.getKey()).getAlternativeNames()) {
                registry.put(TransformFunctionFactory.canonicalize(alias), (Class)entry.getValue());
            }
        }
        return registry;
    }

    public static void init(Set<Class<TransformFunction>> transformFunctionClasses) {
        for (Class<TransformFunction> transformFunctionClass : transformFunctionClasses) {
            TransformFunction transformFunction;
            try {
                transformFunction = transformFunctionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while instantiating transform function from class: " + transformFunctionClass, e);
            }
            String transformFunctionName = TransformFunctionFactory.canonicalize(transformFunction.getName());
            if (TRANSFORM_FUNCTION_MAP.put(transformFunctionName, transformFunctionClass) == null) {
                LOGGER.info("Registering function: {} with class: {}", (Object)transformFunctionName, transformFunctionClass);
                continue;
            }
            LOGGER.info("Replacing function: {} with class: {}", (Object)transformFunctionName, transformFunctionClass);
        }
    }

    public static TransformFunction get(ExpressionContext expression, Map<String, ColumnContext> columnContextMap, QueryContext queryContext) {
        switch (expression.getType()) {
            case FUNCTION: {
                TransformFunction transformFunction;
                FunctionContext function = expression.getFunction();
                String functionName = TransformFunctionFactory.canonicalize(function.getFunctionName());
                List arguments = function.getArguments();
                int numArguments = arguments.size();
                if (functionName.equalsIgnoreCase("arrayValueConstructor")) {
                    return queryContext.getOrComputeSharedValue(ArrayLiteralTransformFunction.class, expression.getFunction().getArguments(), ArrayLiteralTransformFunction::new);
                }
                Class<? extends TransformFunction> transformFunctionClass = TRANSFORM_FUNCTION_MAP.get(functionName);
                if (transformFunctionClass != null) {
                    try {
                        transformFunction = transformFunctionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Caught exception while constructing transform function: " + functionName, e);
                    }
                } else {
                    FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo((String)functionName, (int)numArguments);
                    if (functionInfo == null) {
                        if (FunctionRegistry.containsFunction((String)functionName)) {
                            throw new BadQueryRequestException(String.format("Unsupported function: %s with %d parameters", functionName, numArguments));
                        }
                        throw new BadQueryRequestException(String.format("Unsupported function: %s not found", functionName));
                    }
                    transformFunction = new ScalarTransformFunctionWrapper(functionInfo);
                }
                ArrayList<TransformFunction> transformFunctionArguments = new ArrayList<TransformFunction>(numArguments);
                for (ExpressionContext argument : arguments) {
                    transformFunctionArguments.add(TransformFunctionFactory.get(argument, columnContextMap, queryContext));
                }
                try {
                    transformFunction.init(transformFunctionArguments, columnContextMap, queryContext.isNullHandlingEnabled());
                }
                catch (Exception e) {
                    throw new BadQueryRequestException("Caught exception while initializing transform function: " + functionName, (Throwable)e);
                }
                return transformFunction;
            }
            case IDENTIFIER: {
                String columnName = expression.getIdentifier();
                return new IdentifierTransformFunction(columnName, columnContextMap.get(columnName));
            }
            case LITERAL: {
                LiteralContext literal = expression.getLiteral();
                if (literal.isSingleValue()) {
                    return queryContext.getOrComputeSharedValue(LiteralTransformFunction.class, literal, LiteralTransformFunction::new);
                }
                return queryContext.getOrComputeSharedValue(ArrayLiteralTransformFunction.class, literal, ArrayLiteralTransformFunction::new);
            }
        }
        throw new IllegalStateException();
    }

    @VisibleForTesting
    public static TransformFunction get(ExpressionContext expression, Map<String, DataSource> dataSourceMap) {
        HashMap<String, ColumnContext> columnContextMap = new HashMap<String, ColumnContext>(HashUtil.getHashMapCapacity((int)dataSourceMap.size()));
        dataSourceMap.forEach((k, v) -> columnContextMap.put((String)k, ColumnContext.fromDataSource(v)));
        QueryContext dummy = QueryContextConverterUtils.getQueryContext(CalciteSqlParser.compileToPinotQuery((String)"SELECT * from testTable;"));
        return TransformFunctionFactory.get(expression, columnContextMap, dummy);
    }

    @VisibleForTesting
    public static TransformFunction getNullHandlingEnabled(ExpressionContext expression, Map<String, DataSource> dataSourceMap) {
        HashMap<String, ColumnContext> columnContextMap = new HashMap<String, ColumnContext>(HashUtil.getHashMapCapacity((int)dataSourceMap.size()));
        dataSourceMap.forEach((k, v) -> columnContextMap.put((String)k, ColumnContext.fromDataSource(v)));
        QueryContext dummy = QueryContextConverterUtils.getQueryContext(CalciteSqlParser.compileToPinotQuery((String)"SET enableNullHandling = true; SELECT * from testTable;"));
        return TransformFunctionFactory.get(expression, columnContextMap, dummy);
    }

    public static String canonicalize(String functionName) {
        return StringUtils.remove((String)functionName, (char)'_').toLowerCase();
    }
}

