/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.transformer.datetimehop;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.core.operator.transform.transformer.DataTransformer;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeFormatUnitSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

public abstract class BaseDateTimeWindowHopTransformer<I, O>
implements DataTransformer<I, O> {
    protected final long _hopWindowSizeMillis;
    private final int _inputTimeSize;
    private final TimeUnit _inputTimeUnit;
    private final DateTimeFormatter _inputDateTimeFormatter;
    private final int _outputTimeSize;
    private final DateTimeFormatUnitSpec.DateTimeTransformUnit _outputTimeUnit;
    private final DateTimeFormatter _outputDateTimeFormatter;
    private final long _outputGranularityMillis;

    public BaseDateTimeWindowHopTransformer(DateTimeFormatSpec inputFormat, DateTimeFormatSpec outputFormat, DateTimeGranularitySpec outputGranularity, DateTimeGranularitySpec hopWindowSize) {
        this._inputTimeSize = inputFormat.getColumnSize();
        this._inputTimeUnit = inputFormat.getColumnUnit();
        this._inputDateTimeFormatter = inputFormat.getDateTimeFormatter();
        this._outputTimeSize = outputFormat.getColumnSize();
        this._outputTimeUnit = outputFormat.getColumnDateTimeTransformUnit();
        this._outputDateTimeFormatter = outputFormat.getDateTimeFormatter();
        this._outputGranularityMillis = outputGranularity.granularityToMillis();
        this._hopWindowSizeMillis = hopWindowSize.granularityToMillis();
    }

    protected long transformEpochToMillis(long epochTime) {
        return this._inputTimeUnit.toMillis(epochTime * (long)this._inputTimeSize);
    }

    protected long transformSDFToMillis(String sdfTime) {
        return this._inputDateTimeFormatter.parseMillis(sdfTime);
    }

    protected long transformMillisToEpoch(long millisSinceEpoch) {
        return this._outputTimeUnit.fromMillis(millisSinceEpoch) / (long)this._outputTimeSize;
    }

    protected String transformMillisToSDF(long millisSinceEpoch) {
        return this._outputDateTimeFormatter.print((ReadableInstant)new DateTime(millisSinceEpoch));
    }

    protected long transformToOutputGranularity(long millisSinceEpoch) {
        return millisSinceEpoch / this._outputGranularityMillis * this._outputGranularityMillis;
    }

    protected List<Long> hopWindows(long millisSinceEpoch) {
        long adjustedMillis;
        ArrayList<Long> hops = new ArrayList<Long>();
        long totalHopMillis = this._hopWindowSizeMillis;
        long granularityMillis = this._outputGranularityMillis;
        for (long currentMillis = adjustedMillis = millisSinceEpoch / granularityMillis * granularityMillis; currentMillis > millisSinceEpoch - totalHopMillis; currentMillis -= granularityMillis) {
            hops.add(currentMillis);
        }
        return hops;
    }
}

