/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.transformer.datetimehop;

import org.apache.pinot.core.operator.transform.transformer.datetimehop.BaseDateTimeWindowHopTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetimehop.EpochToEpochWindowHopTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetimehop.EpochToSDFHopWindowTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetimehop.SDFToEpochWindowHopTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetimehop.SDFToSDFWindowHopTransformer;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;

public class DateTimeWindowHopTransformerFactory {
    private static final DateTimeFieldSpec.TimeFormat EPOCH = DateTimeFieldSpec.TimeFormat.EPOCH;
    private static final DateTimeFieldSpec.TimeFormat TIMESTAMP = DateTimeFieldSpec.TimeFormat.TIMESTAMP;

    private DateTimeWindowHopTransformerFactory() {
    }

    public static BaseDateTimeWindowHopTransformer getDateTimeTransformer(String inputFormatStr, String outputFormatStr, String outputGranularityStr, String hopSizeStr) {
        DateTimeFormatSpec inputFormatSpec = new DateTimeFormatSpec(inputFormatStr);
        DateTimeFormatSpec outputFormatSpec = new DateTimeFormatSpec(outputFormatStr);
        DateTimeGranularitySpec outputGranularity = new DateTimeGranularitySpec(outputGranularityStr);
        DateTimeGranularitySpec hopSizeFormat = new DateTimeGranularitySpec(hopSizeStr);
        DateTimeFieldSpec.TimeFormat inputFormat = inputFormatSpec.getTimeFormat();
        DateTimeFieldSpec.TimeFormat outputFormat = outputFormatSpec.getTimeFormat();
        if (DateTimeWindowHopTransformerFactory.isEpochOrTimestamp(inputFormat) && DateTimeWindowHopTransformerFactory.isEpochOrTimestamp(outputFormat)) {
            return new EpochToEpochWindowHopTransformer(inputFormatSpec, outputFormatSpec, outputGranularity, hopSizeFormat);
        }
        if (DateTimeWindowHopTransformerFactory.isEpochOrTimestamp(inputFormat) && DateTimeWindowHopTransformerFactory.isStringFormat(outputFormat)) {
            return new EpochToSDFHopWindowTransformer(inputFormatSpec, outputFormatSpec, outputGranularity, hopSizeFormat);
        }
        if (DateTimeWindowHopTransformerFactory.isStringFormat(inputFormat) && DateTimeWindowHopTransformerFactory.isEpochOrTimestamp(outputFormat)) {
            return new SDFToEpochWindowHopTransformer(inputFormatSpec, outputFormatSpec, outputGranularity, hopSizeFormat);
        }
        if (DateTimeWindowHopTransformerFactory.isStringFormat(inputFormat) && DateTimeWindowHopTransformerFactory.isStringFormat(outputFormat)) {
            return new SDFToSDFWindowHopTransformer(inputFormatSpec, outputFormatSpec, outputGranularity, hopSizeFormat);
        }
        throw new IllegalArgumentException("Wrong inputFormat: " + inputFormat + " outputFormat: " + outputFormat);
    }

    private static boolean isEpochOrTimestamp(DateTimeFieldSpec.TimeFormat format) {
        return format == EPOCH || format == TIMESTAMP;
    }

    private static boolean isStringFormat(DateTimeFieldSpec.TimeFormat format) {
        return format == DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT;
    }
}

