/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.periodictask;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.core.periodictask.PeriodicTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BasePeriodicTask
implements PeriodicTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePeriodicTask.class);
    private static final String DEFAULT_REQUEST_ID = "auto";
    private static final long MAX_PERIODIC_TASK_STOP_TIME_MILLIS = 30000L;
    protected final String _taskName;
    protected final long _intervalInSeconds;
    protected final long _initialDelayInSeconds;
    protected final ReentrantLock _runLock;
    private volatile boolean _started;
    private volatile boolean _running;
    private static final Properties DEFAULT_PERIODIC_TASK_PROPERTIES = new Properties();

    public BasePeriodicTask(String taskName, long runFrequencyInSeconds, long initialDelayInSeconds) {
        this._taskName = taskName;
        this._intervalInSeconds = runFrequencyInSeconds;
        this._initialDelayInSeconds = initialDelayInSeconds;
        this._runLock = new ReentrantLock();
    }

    @Override
    public String getTaskName() {
        return this._taskName;
    }

    @Override
    public long getIntervalInSeconds() {
        return this._intervalInSeconds;
    }

    @Override
    public long getInitialDelayInSeconds() {
        return this._initialDelayInSeconds;
    }

    public final boolean isStarted() {
        return this._started;
    }

    public final boolean isRunning() {
        return this._running;
    }

    @Override
    public final synchronized void start() {
        if (this._started) {
            LOGGER.warn("Task: {} is already started", (Object)this._taskName);
            return;
        }
        try {
            this.setUpTask();
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while setting up task: {}", (Object)this._taskName, (Object)e);
        }
        this._started = true;
    }

    protected void setUpTask() {
    }

    @Override
    public final void run() {
        this.run(DEFAULT_PERIODIC_TASK_PROPERTIES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run(Properties periodicTaskProperties) {
        block6: {
            try {
                this._runLock.lock();
                this._running = true;
                String periodicTaskRequestId = periodicTaskProperties.getProperty("requestId");
                if (this._started) {
                    long startTime = System.currentTimeMillis();
                    LOGGER.info("[TaskRequestId: {}] Start running task: {}", (Object)periodicTaskRequestId, (Object)this._taskName);
                    try {
                        this.runTask(periodicTaskProperties);
                    }
                    catch (Exception e) {
                        LOGGER.error("[TaskRequestId: {}] Caught exception while running task: {}", new Object[]{periodicTaskRequestId, this._taskName, e});
                    }
                    LOGGER.info("[TaskRequestId: {}] Finish running task: {} in {}ms", new Object[]{periodicTaskRequestId, this._taskName, System.currentTimeMillis() - startTime});
                    break block6;
                }
                LOGGER.warn("[TaskRequestId: {}] Task: {} is skipped because it is not started or already stopped", (Object)periodicTaskRequestId, (Object)this._taskName);
            }
            finally {
                this._runLock.unlock();
                this._running = false;
            }
        }
    }

    protected abstract void runTask(Properties var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void stop() {
        if (!this._started) {
            LOGGER.warn("Task: {} is not started", (Object)this._taskName);
            return;
        }
        long startTimeMs = System.currentTimeMillis();
        this._started = false;
        try {
            if (!this._runLock.tryLock(30000L, TimeUnit.MILLISECONDS)) {
                LOGGER.warn("Task {} could not be stopped within timeout of {}ms", (Object)this._taskName, (Object)30000L);
            } else {
                LOGGER.info("Task {} successfully stopped in {}ms", (Object)this._taskName, (Object)(System.currentTimeMillis() - startTimeMs));
            }
        }
        catch (InterruptedException ie) {
            LOGGER.error("Caught InterruptedException while waiting for task: {} to finish", (Object)this._taskName);
            Thread.currentThread().interrupt();
        }
        finally {
            if (this._runLock.isHeldByCurrentThread()) {
                this._runLock.unlock();
            }
        }
        try {
            this.cleanUpTask();
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while cleaning up task: {}", (Object)this._taskName, (Object)e);
        }
    }

    protected void cleanUpTask() {
    }

    public String toString() {
        return String.format("Task: %s, Interval: %ds, Initial Delay: %ds", this._taskName, this._intervalInSeconds, this._initialDelayInSeconds);
    }

    static {
        DEFAULT_PERIODIC_TASK_PROPERTIES.put("requestId", DEFAULT_REQUEST_ID);
    }
}

