/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.EnumSet;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.results.AggregationResultsBlock;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.query.AggregationOperator;
import org.apache.pinot.core.operator.query.FastFilteredCountOperator;
import org.apache.pinot.core.operator.query.FilteredAggregationOperator;
import org.apache.pinot.core.operator.query.NonScanBasedAggregationOperator;
import org.apache.pinot.core.plan.FilterPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.SegmentContext;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class AggregationPlanNode
implements PlanNode {
    private static final EnumSet<AggregationFunctionType> DICTIONARY_BASED_FUNCTIONS = EnumSet.of(AggregationFunctionType.MIN, new AggregationFunctionType[]{AggregationFunctionType.MINMV, AggregationFunctionType.MAX, AggregationFunctionType.MAXMV, AggregationFunctionType.MINMAXRANGE, AggregationFunctionType.MINMAXRANGEMV, AggregationFunctionType.DISTINCTCOUNT, AggregationFunctionType.DISTINCTCOUNTMV, AggregationFunctionType.DISTINCTCOUNTHLL, AggregationFunctionType.DISTINCTCOUNTHLLMV, AggregationFunctionType.DISTINCTCOUNTRAWHLL, AggregationFunctionType.DISTINCTCOUNTRAWHLLMV, AggregationFunctionType.SEGMENTPARTITIONEDDISTINCTCOUNT, AggregationFunctionType.DISTINCTCOUNTSMARTHLL, AggregationFunctionType.DISTINCTSUM, AggregationFunctionType.DISTINCTAVG, AggregationFunctionType.DISTINCTSUMMV, AggregationFunctionType.DISTINCTAVGMV, AggregationFunctionType.DISTINCTCOUNTHLLPLUS, AggregationFunctionType.DISTINCTCOUNTHLLPLUSMV, AggregationFunctionType.DISTINCTCOUNTRAWHLLPLUS, AggregationFunctionType.DISTINCTCOUNTRAWHLLPLUSMV});
    private static final EnumSet<AggregationFunctionType> METADATA_BASED_FUNCTIONS = EnumSet.of(AggregationFunctionType.COUNT, new AggregationFunctionType[]{AggregationFunctionType.MIN, AggregationFunctionType.MINMV, AggregationFunctionType.MAX, AggregationFunctionType.MAXMV, AggregationFunctionType.MINMAXRANGE, AggregationFunctionType.MINMAXRANGEMV});
    private final IndexSegment _indexSegment;
    private final SegmentContext _segmentContext;
    private final QueryContext _queryContext;

    public AggregationPlanNode(SegmentContext segmentContext, QueryContext queryContext) {
        this._indexSegment = segmentContext.getIndexSegment();
        this._segmentContext = segmentContext;
        this._queryContext = queryContext;
    }

    public Operator<AggregationResultsBlock> run() {
        assert (this._queryContext.getAggregationFunctions() != null);
        return this._queryContext.hasFilteredAggregations() ? this.buildFilteredAggOperator() : this.buildNonFilteredAggOperator();
    }

    private FilteredAggregationOperator buildFilteredAggOperator() {
        return new FilteredAggregationOperator(this._queryContext, AggregationFunctionUtils.buildFilteredAggregationInfos(this._segmentContext, this._queryContext), this._indexSegment.getSegmentMetadata().getTotalDocs());
    }

    public Operator<AggregationResultsBlock> buildNonFilteredAggOperator() {
        AggregationFunction[] aggregationFunctions = this._queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null);
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        FilterPlanNode filterPlanNode = new FilterPlanNode(this._segmentContext, this._queryContext);
        BaseFilterOperator filterOperator = filterPlanNode.run();
        if (!this._queryContext.isNullHandlingEnabled()) {
            if (AggregationPlanNode.canOptimizeFilteredCount(filterOperator, aggregationFunctions)) {
                return new FastFilteredCountOperator(this._queryContext, filterOperator, this._indexSegment.getSegmentMetadata());
            }
            if (filterOperator.isResultMatchingAll() && AggregationPlanNode.isFitForNonScanBasedPlan(aggregationFunctions, this._indexSegment)) {
                DataSource[] dataSources = new DataSource[aggregationFunctions.length];
                for (int i = 0; i < aggregationFunctions.length; ++i) {
                    List<ExpressionContext> inputExpressions = aggregationFunctions[i].getInputExpressions();
                    if (inputExpressions.isEmpty()) continue;
                    String column = inputExpressions.get(0).getIdentifier();
                    dataSources[i] = this._indexSegment.getDataSource(column);
                }
                return new NonScanBasedAggregationOperator(this._queryContext, dataSources, numTotalDocs);
            }
        }
        AggregationFunctionUtils.AggregationInfo aggregationInfo = AggregationFunctionUtils.buildAggregationInfo(this._segmentContext, this._queryContext, aggregationFunctions, this._queryContext.getFilter(), filterOperator, filterPlanNode.getPredicateEvaluators());
        return new AggregationOperator(this._queryContext, aggregationInfo, numTotalDocs);
    }

    private static boolean isFitForNonScanBasedPlan(AggregationFunction[] aggregationFunctions, IndexSegment indexSegment) {
        for (AggregationFunction aggregationFunction : aggregationFunctions) {
            if (aggregationFunction.getType() == AggregationFunctionType.COUNT) continue;
            ExpressionContext argument = aggregationFunction.getInputExpressions().get(0);
            if (argument.getType() != ExpressionContext.Type.IDENTIFIER) {
                return false;
            }
            DataSource dataSource = indexSegment.getDataSource(argument.getIdentifier());
            if (DICTIONARY_BASED_FUNCTIONS.contains(aggregationFunction.getType()) && dataSource.getDictionary() != null || METADATA_BASED_FUNCTIONS.contains(aggregationFunction.getType()) && dataSource.getDataSourceMetadata().getMaxValue() != null && dataSource.getDataSourceMetadata().getMinValue() != null) continue;
            return false;
        }
        return true;
    }

    private static boolean canOptimizeFilteredCount(BaseFilterOperator filterOperator, AggregationFunction[] aggregationFunctions) {
        return aggregationFunctions.length == 1 && aggregationFunctions[0].getType() == AggregationFunctionType.COUNT && filterOperator.canOptimizeCount();
    }
}

