/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.common.Block;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.combine.AggregationCombineOperator;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.operator.combine.DistinctCombineOperator;
import org.apache.pinot.core.operator.combine.GroupByCombineOperator;
import org.apache.pinot.core.operator.combine.MinMaxValueBasedSelectionOrderByCombineOperator;
import org.apache.pinot.core.operator.combine.SelectionOnlyCombineOperator;
import org.apache.pinot.core.operator.combine.SelectionOrderByCombineOperator;
import org.apache.pinot.core.operator.streaming.StreamingSelectionOnlyCombineOperator;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.executor.ResultsBlockStreamer;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;
import org.apache.pinot.core.util.QueryMultiThreadingUtils;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.apache.pinot.spi.exception.QueryCancelledException;
import org.apache.pinot.spi.trace.InvocationRecording;
import org.apache.pinot.spi.trace.InvocationScope;
import org.apache.pinot.spi.trace.Tracing;

public class CombinePlanNode
implements PlanNode {
    private static final int TARGET_NUM_PLANS_PER_THREAD = 10;
    private final List<PlanNode> _planNodes;
    private final QueryContext _queryContext;
    private final ExecutorService _executorService;
    private final ResultsBlockStreamer _streamer;

    public CombinePlanNode(List<PlanNode> planNodes, QueryContext queryContext, ExecutorService executorService, @Nullable ResultsBlockStreamer streamer) {
        this._planNodes = planNodes;
        this._queryContext = queryContext;
        this._executorService = executorService;
        this._streamer = streamer;
    }

    public BaseCombineOperator run() {
        try (InvocationScope ignored = Tracing.getTracer().createScope(CombinePlanNode.class);){
            BaseCombineOperator baseCombineOperator = this.getCombineOperator();
            return baseCombineOperator;
        }
    }

    private BaseCombineOperator getCombineOperator() {
        InvocationRecording recording = Tracing.activeRecording();
        int numPlanNodes = this._planNodes.size();
        recording.setNumChildren(numPlanNodes);
        ArrayList<Operator> operators = new ArrayList<Operator>(numPlanNodes);
        if (numPlanNodes <= 10) {
            for (PlanNode planNode : this._planNodes) {
                operators.add(planNode.run());
            }
        } else {
            int numTasks = QueryMultiThreadingUtils.getNumTasks(numPlanNodes, 10, this._queryContext.getMaxExecutionThreads());
            recording.setNumTasks(numTasks);
            QueryMultiThreadingUtils.runTasksWithDeadline(numTasks, index -> {
                ArrayList<Operator<? extends Block>> ops = new ArrayList<Operator<? extends Block>>();
                for (int i = index.intValue(); i < numPlanNodes; i += numTasks) {
                    ops.add(this._planNodes.get(i).run());
                }
                return ops;
            }, taskRes -> {
                if (taskRes != null) {
                    operators.addAll((Collection<Operator>)taskRes);
                }
            }, e -> {
                Throwable cause = e.getCause();
                if (cause instanceof BadQueryRequestException) {
                    throw (BadQueryRequestException)cause;
                }
                if (e instanceof InterruptedException) {
                    throw new QueryCancelledException("Cancelled while running CombinePlanNode", (Throwable)e);
                }
                throw new RuntimeException("Caught exception while running CombinePlanNode.", (Throwable)e);
            }, this._executorService, this._queryContext.getEndTimeMs());
        }
        if (this._streamer != null && QueryContextUtils.isSelectionOnlyQuery(this._queryContext) && this._queryContext.getLimit() != 0) {
            return new StreamingSelectionOnlyCombineOperator(operators, this._queryContext, this._executorService);
        }
        if (QueryContextUtils.isAggregationQuery(this._queryContext)) {
            if (this._queryContext.getGroupByExpressions() == null) {
                return new AggregationCombineOperator(operators, this._queryContext, this._executorService);
            }
            return new GroupByCombineOperator(operators, this._queryContext, this._executorService);
        }
        if (QueryContextUtils.isSelectionQuery(this._queryContext)) {
            if (this._queryContext.getLimit() == 0 || this._queryContext.getOrderByExpressions() == null) {
                return new SelectionOnlyCombineOperator(operators, this._queryContext, this._executorService);
            }
            List<OrderByExpressionContext> orderByExpressions = this._queryContext.getOrderByExpressions();
            assert (orderByExpressions != null);
            if (orderByExpressions.get(0).getExpression().getType() == ExpressionContext.Type.IDENTIFIER) {
                return new MinMaxValueBasedSelectionOrderByCombineOperator(operators, this._queryContext, this._executorService);
            }
            return new SelectionOrderByCombineOperator(operators, this._queryContext, this._executorService);
        }
        assert (QueryContextUtils.isDistinctQuery(this._queryContext));
        return new DistinctCombineOperator(operators, this._queryContext, this._executorService);
    }
}

