/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.results.GroupByResultsBlock;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.query.FilteredGroupByOperator;
import org.apache.pinot.core.operator.query.GroupByOperator;
import org.apache.pinot.core.plan.FilterPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.SegmentContext;

public class GroupByPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final SegmentContext _segmentContext;
    private final QueryContext _queryContext;

    public GroupByPlanNode(SegmentContext segmentContext, QueryContext queryContext) {
        this._indexSegment = segmentContext.getIndexSegment();
        this._segmentContext = segmentContext;
        this._queryContext = queryContext;
    }

    public Operator<GroupByResultsBlock> run() {
        assert (this._queryContext.getAggregationFunctions() != null && this._queryContext.getGroupByExpressions() != null);
        return this._queryContext.hasFilteredAggregations() ? this.buildFilteredGroupByPlan() : this.buildNonFilteredGroupByPlan();
    }

    private FilteredGroupByOperator buildFilteredGroupByPlan() {
        return new FilteredGroupByOperator(this._queryContext, AggregationFunctionUtils.buildFilteredAggregationInfos(this._segmentContext, this._queryContext), this._indexSegment.getSegmentMetadata().getTotalDocs());
    }

    private GroupByOperator buildNonFilteredGroupByPlan() {
        FilterPlanNode filterPlanNode = new FilterPlanNode(this._segmentContext, this._queryContext);
        BaseFilterOperator filterOperator = filterPlanNode.run();
        AggregationFunctionUtils.AggregationInfo aggregationInfo = AggregationFunctionUtils.buildAggregationInfo(this._segmentContext, this._queryContext, this._queryContext.getAggregationFunctions(), this._queryContext.getFilter(), filterOperator, filterPlanNode.getPredicateEvaluators());
        return new GroupByOperator(this._queryContext, aggregationInfo, this._indexSegment.getSegmentMetadata().getTotalDocs());
    }
}

