/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.DocIdSetOperator;
import org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.core.operator.ProjectionOperatorUtils;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.SegmentContext;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class ProjectPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final SegmentContext _segmentContext;
    private final QueryContext _queryContext;
    private final Collection<ExpressionContext> _expressions;
    private final int _maxDocsPerCall;
    private final BaseFilterOperator _filterOperator;

    public ProjectPlanNode(SegmentContext segmentContext, QueryContext queryContext, Collection<ExpressionContext> expressions, int maxDocsPerCall, @Nullable BaseFilterOperator filterOperator) {
        this._indexSegment = segmentContext.getIndexSegment();
        this._segmentContext = segmentContext;
        this._queryContext = queryContext;
        this._expressions = expressions;
        this._maxDocsPerCall = maxDocsPerCall;
        this._filterOperator = filterOperator;
    }

    public ProjectPlanNode(SegmentContext segmentContext, QueryContext queryContext, Collection<ExpressionContext> expressions, int maxDocsPerCall) {
        this(segmentContext, queryContext, expressions, maxDocsPerCall, null);
    }

    public BaseProjectOperator<?> run() {
        HashSet projectionColumns = new HashSet();
        boolean hasNonIdentifierExpression = false;
        for (ExpressionContext expression : this._expressions) {
            expression.getColumns(projectionColumns);
            if (expression.getType() == ExpressionContext.Type.IDENTIFIER) continue;
            hasNonIdentifierExpression = true;
        }
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>(HashUtil.getHashMapCapacity((int)projectionColumns.size()));
        projectionColumns.forEach(column -> dataSourceMap.put((String)column, this._indexSegment.getDataSource(column)));
        DocIdSetOperator docIdSetOperator = this._maxDocsPerCall > 0 ? new DocIdSetPlanNode(this._segmentContext, this._queryContext, this._maxDocsPerCall, this._filterOperator).run() : null;
        ProjectionOperator projectionOperator = ProjectionOperatorUtils.getProjectionOperator(dataSourceMap, docIdSetOperator);
        return hasNonIdentifierExpression ? new TransformOperator(this._queryContext, projectionOperator, this._expressions) : projectionOperator;
    }
}

