/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.operator.query.EmptySelectionOperator;
import org.apache.pinot.core.operator.query.SelectionOnlyOperator;
import org.apache.pinot.core.operator.query.SelectionOrderByOperator;
import org.apache.pinot.core.operator.query.SelectionPartiallyOrderedByAscOperator;
import org.apache.pinot.core.operator.query.SelectionPartiallyOrderedByDescOperation;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.ProjectPlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.SegmentContext;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;

public class SelectionPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final SegmentContext _segmentContext;
    private final QueryContext _queryContext;

    public SelectionPlanNode(SegmentContext segmentContext, QueryContext queryContext) {
        this._indexSegment = segmentContext.getIndexSegment();
        this._segmentContext = segmentContext;
        this._queryContext = queryContext;
    }

    public Operator<SelectionResultsBlock> run() {
        List<ExpressionContext> expressions = SelectionOperatorUtils.extractExpressions(this._queryContext, this._indexSegment);
        int limit = this._queryContext.getLimit();
        if (limit == 0) {
            Operator projectOperator = new ProjectPlanNode(this._segmentContext, this._queryContext, expressions, 0).run();
            return new EmptySelectionOperator(this._indexSegment, this._queryContext, expressions, (BaseProjectOperator<?>)projectOperator);
        }
        List<OrderByExpressionContext> orderByExpressions = this._queryContext.getOrderByExpressions();
        if (orderByExpressions == null) {
            int maxDocsPerCall = Math.min(limit, 10000);
            Operator projectOperator = new ProjectPlanNode(this._segmentContext, this._queryContext, expressions, maxDocsPerCall).run();
            return new SelectionOnlyOperator(this._indexSegment, this._queryContext, expressions, (BaseProjectOperator<?>)projectOperator);
        }
        int numOrderByExpressions = orderByExpressions.size();
        int sortedColumnsPrefixSize = this.getSortedColumnsPrefix(orderByExpressions, this._queryContext.isNullHandlingEnabled());
        OrderByAlgorithm orderByAlgorithm = OrderByAlgorithm.fromQueryContext(this._queryContext);
        if (sortedColumnsPrefixSize > 0 && orderByAlgorithm != OrderByAlgorithm.NAIVE) {
            int maxDocsPerCall = 10000;
            if (orderByExpressions.get(0).isAsc()) {
                if (sortedColumnsPrefixSize == orderByExpressions.size()) {
                    maxDocsPerCall = Math.min(limit + this._queryContext.getOffset(), 10000);
                }
                Operator projectOperator = new ProjectPlanNode(this._segmentContext, this._queryContext, expressions, maxDocsPerCall).run();
                return new SelectionPartiallyOrderedByAscOperator(this._indexSegment, this._queryContext, expressions, (BaseProjectOperator<?>)projectOperator, sortedColumnsPrefixSize);
            }
            Operator projectOperator = new ProjectPlanNode(this._segmentContext, this._queryContext, expressions, maxDocsPerCall).run();
            return new SelectionPartiallyOrderedByDescOperation(this._indexSegment, this._queryContext, expressions, (BaseProjectOperator<?>)projectOperator, sortedColumnsPrefixSize);
        }
        if (numOrderByExpressions == expressions.size()) {
            Operator projectOperator = new ProjectPlanNode(this._segmentContext, this._queryContext, expressions, 10000).run();
            return new SelectionOrderByOperator(this._indexSegment, this._queryContext, expressions, (BaseProjectOperator<?>)projectOperator);
        }
        ArrayList<ExpressionContext> expressionsToTransform = new ArrayList<ExpressionContext>(numOrderByExpressions);
        for (OrderByExpressionContext orderByExpression : orderByExpressions) {
            expressionsToTransform.add(orderByExpression.getExpression());
        }
        Operator projectOperator = new ProjectPlanNode(this._segmentContext, this._queryContext, expressionsToTransform, 10000).run();
        return new SelectionOrderByOperator(this._indexSegment, this._queryContext, expressions, (BaseProjectOperator<?>)projectOperator);
    }

    private int getSortedColumnsPrefix(List<OrderByExpressionContext> orderByExpressions, boolean isNullHandlingEnabled) {
        boolean asc = orderByExpressions.get(0).isAsc();
        for (int i = 0; i < orderByExpressions.size(); ++i) {
            if (this.isSorted(orderByExpressions.get(i), asc, isNullHandlingEnabled)) continue;
            return i;
        }
        return orderByExpressions.size();
    }

    private boolean isSorted(OrderByExpressionContext orderByExpression, boolean asc, boolean isNullHandlingEnabled) {
        switch (orderByExpression.getExpression().getType()) {
            case LITERAL: {
                return true;
            }
            case IDENTIFIER: {
                NullValueVectorReader nullValueVector;
                if (!orderByExpression.isAsc() == asc) {
                    return false;
                }
                String column = orderByExpression.getExpression().getIdentifier();
                DataSource dataSource = this._indexSegment.getDataSource(column);
                if (isNullHandlingEnabled && (nullValueVector = dataSource.getNullValueVector()) != null && !nullValueVector.getNullBitmap().isEmpty()) {
                    return false;
                }
                return dataSource.getDataSourceMetadata().isSorted();
            }
        }
        return false;
    }

    public static enum OrderByAlgorithm {
        NAIVE;


        @Nullable
        public static OrderByAlgorithm fromQueryContext(QueryContext queryContext) {
            String orderByAlgorithm = QueryOptionsUtils.getOrderByAlgorithm(queryContext.getQueryOptions());
            if (orderByAlgorithm == null) {
                return null;
            }
            return OrderByAlgorithm.valueOf(orderByAlgorithm.toUpperCase());
        }
    }
}

