/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.AvgAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class AvgMVAggregationFunction
extends AvgAggregationFunction {
    public AvgMVAggregationFunction(List<ExpressionContext> arguments) {
        super(AvgMVAggregationFunction.verifySingleArgument(arguments, "AVG_MV"), false);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.AVGMV;
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[][] valuesArray = blockValSetMap.get(this._expression).getDoubleValuesMV();
        double sum = 0.0;
        long count = 0L;
        for (int i = 0; i < length; ++i) {
            double[] values;
            for (double value : values = valuesArray[i]) {
                sum += value;
            }
            count += (long)values.length;
        }
        this.setAggregationResult(aggregationResultHolder, sum, count);
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[][] valuesArray = blockValSetMap.get(this._expression).getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            this.aggregateOnGroupKey(groupKeyArray[i], groupByResultHolder, valuesArray[i]);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[][] valuesArray = blockValSetMap.get(this._expression).getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            double[] values = valuesArray[i];
            for (int groupKey : groupKeysArray[i]) {
                this.aggregateOnGroupKey(groupKey, groupByResultHolder, values);
            }
        }
    }

    private void aggregateOnGroupKey(int groupKey, GroupByResultHolder groupByResultHolder, double[] values) {
        double sum = 0.0;
        for (double value : values) {
            sum += value;
        }
        long count = values.length;
        this.setGroupByResult(groupKey, groupByResultHolder, sum, count);
    }
}

