/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.IntAggregateResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.IntGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public abstract class BaseBooleanAggregationFunction
extends BaseSingleInputAggregationFunction<Integer, Integer> {
    private final BooleanMerge _merger;
    private final boolean _nullHandlingEnabled;

    protected BaseBooleanAggregationFunction(ExpressionContext expression, boolean nullHandlingEnabled, BooleanMerge merger) {
        super(expression);
        this._nullHandlingEnabled = nullHandlingEnabled;
        this._merger = merger;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return this._nullHandlingEnabled ? new ObjectAggregationResultHolder() : new IntAggregateResultHolder(this._merger.getDefaultValue());
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return this._nullHandlingEnabled ? new ObjectGroupByResultHolder(initialCapacity, maxCapacity) : new IntGroupByResultHolder(initialCapacity, maxCapacity, this._merger.getDefaultValue());
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (blockValSet.getValueType() != FieldSpec.DataType.BOOLEAN) {
            throw new IllegalArgumentException(String.format("Unsupported data type %s for %s", this.getType().getName(), blockValSet.getValueType()));
        }
        int[] bools = blockValSet.getIntValuesSV();
        if (this._nullHandlingEnabled) {
            int agg = this.getInt((Integer)aggregationResultHolder.getResult());
            if (this._merger.isTerminal(agg)) {
                return;
            }
            RoaringBitmap nullBitmap = blockValSet.getNullBitmap();
            if (nullBitmap == null) {
                nullBitmap = new RoaringBitmap();
            } else if (nullBitmap.getCardinality() > length) {
                return;
            }
            for (int i = 0; i < length; ++i) {
                if (nullBitmap.contains(i)) continue;
                agg = this._merger.merge(agg, bools[i]);
                aggregationResultHolder.setValue((Object)agg);
            }
        } else {
            int agg = aggregationResultHolder.getIntResult();
            if (this._merger.isTerminal(agg)) {
                return;
            }
            for (int i = 0; i < length; ++i) {
                agg = this._merger.merge(agg, bools[i]);
                aggregationResultHolder.setValue(agg);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (blockValSet.getValueType() != FieldSpec.DataType.BOOLEAN) {
            throw new IllegalArgumentException(String.format("Unsupported data type %s for %s", this.getType().getName(), blockValSet.getValueType()));
        }
        int[] bools = blockValSet.getIntValuesSV();
        if (this._nullHandlingEnabled) {
            RoaringBitmap nullBitmap = blockValSet.getNullBitmap();
            if (nullBitmap == null) {
                nullBitmap = new RoaringBitmap();
            } else if (nullBitmap.getCardinality() > length) {
                return;
            }
            for (int i = 0; i < length; ++i) {
                if (nullBitmap.contains(i)) continue;
                int groupByKey = groupKeyArray[i];
                int agg = this.getInt((Integer)groupByResultHolder.getResult(groupByKey));
                groupByResultHolder.setValueForKey(groupByKey, (Object)this._merger.merge(agg, bools[i]));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                int groupByKey = groupKeyArray[i];
                int agg = groupByResultHolder.getIntResult(groupByKey);
                groupByResultHolder.setValueForKey(groupByKey, this._merger.merge(agg, bools[i]));
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        int[] valueArray = blockValSetMap.get(this._expression).getIntValuesSV();
        for (int i = 0; i < length; ++i) {
            for (int groupKey : groupKeysArray[i]) {
                int agg = groupByResultHolder.getIntResult(groupKey);
                groupByResultHolder.setValueForKey(groupKey, this._merger.merge(agg, valueArray[i]));
            }
        }
    }

    @Override
    public Integer extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        if (this._nullHandlingEnabled) {
            return (Integer)aggregationResultHolder.getResult();
        }
        return aggregationResultHolder.getIntResult();
    }

    @Override
    public Integer extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        if (this._nullHandlingEnabled) {
            return (Integer)groupByResultHolder.getResult(groupKey);
        }
        return groupByResultHolder.getIntResult(groupKey);
    }

    @Override
    public Integer merge(Integer intermediateResult1, Integer intermediateResult2) {
        if (this._nullHandlingEnabled) {
            if (intermediateResult1 == null) {
                return intermediateResult2;
            }
            if (intermediateResult2 == null) {
                return intermediateResult1;
            }
        }
        return this._merger.merge(intermediateResult1, intermediateResult2);
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.INT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.BOOLEAN;
    }

    @Override
    public Integer extractFinalResult(Integer intermediateResult) {
        return intermediateResult;
    }

    @Override
    public Integer mergeFinalResult(Integer finalResult1, Integer finalResult2) {
        return this.merge(finalResult1, finalResult2);
    }

    private int getInt(Integer val) {
        return val == null ? this._merger.getDefaultValue() : val.intValue();
    }

    protected static enum BooleanMerge {
        AND{

            @Override
            int merge(int left, int right) {
                return left & right;
            }

            @Override
            boolean isTerminal(int agg) {
                return agg == 0;
            }

            @Override
            int getDefaultValue() {
                return 1;
            }
        }
        ,
        OR{

            @Override
            int merge(int left, int right) {
                return left | right;
            }

            @Override
            boolean isTerminal(int agg) {
                return agg > 0;
            }

            @Override
            int getDefaultValue() {
                return 0;
            }
        };


        abstract int merge(int var1, int var2);

        abstract boolean isTerminal(int var1);

        abstract int getDefaultValue();
    }
}

