/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.trace.Tracing;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public abstract class BaseDistinctAggregateAggregationFunction<T extends Comparable>
extends BaseSingleInputAggregationFunction<Set, T> {
    private final AggregationFunctionType _functionType;
    private final boolean _nullHandlingEnabled;

    protected BaseDistinctAggregateAggregationFunction(ExpressionContext expression, AggregationFunctionType aggregationFunctionType, boolean nullHandlingEnabled) {
        super(expression);
        this._functionType = aggregationFunctionType;
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    @Override
    public AggregationFunctionType getType() {
        return this._functionType;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public Set extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        Object result = aggregationResultHolder.getResult();
        if (result == null) {
            return new IntOpenHashSet();
        }
        if (result instanceof DictIdsWrapper) {
            return BaseDistinctAggregateAggregationFunction.convertToValueSet((DictIdsWrapper)result);
        }
        return (Set)result;
    }

    @Override
    public Set extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        Object result = groupByResultHolder.getResult(groupKey);
        if (result == null) {
            return new IntOpenHashSet();
        }
        if (result instanceof DictIdsWrapper) {
            return BaseDistinctAggregateAggregationFunction.convertToValueSet((DictIdsWrapper)result);
        }
        return (Set)result;
    }

    @Override
    public Set merge(Set intermediateResult1, Set intermediateResult2) {
        if (intermediateResult1.isEmpty()) {
            return intermediateResult2;
        }
        if (intermediateResult2.isEmpty()) {
            return intermediateResult1;
        }
        Tracing.ThreadAccountantOps.sampleAndCheckInterruption();
        intermediateResult1.addAll(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    protected static RoaringBitmap getDictIdBitmap(AggregationResultHolder aggregationResultHolder, Dictionary dictionary) {
        DictIdsWrapper dictIdsWrapper = (DictIdsWrapper)aggregationResultHolder.getResult();
        if (dictIdsWrapper == null) {
            dictIdsWrapper = new DictIdsWrapper(dictionary);
            aggregationResultHolder.setValue(dictIdsWrapper);
        }
        return dictIdsWrapper._dictIdBitmap;
    }

    protected void svAggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        RoaringBitmap nullBitmap = null;
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            if (this._nullHandlingEnabled) {
                nullBitmap = blockValSet.getNullBitmap();
            }
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            if (nullBitmap != null && !nullBitmap.isEmpty()) {
                RoaringBitmap dictIdBitmap = BaseDistinctAggregateAggregationFunction.getDictIdBitmap(aggregationResultHolder, dictionary);
                for (int i = 0; i < length; ++i) {
                    if (nullBitmap.contains(i)) continue;
                    dictIdBitmap.add(dictIds[i]);
                }
            } else {
                BaseDistinctAggregateAggregationFunction.getDictIdBitmap(aggregationResultHolder, dictionary).addN(dictIds, 0, length);
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        Set valueSet = BaseDistinctAggregateAggregationFunction.getValueSet(aggregationResultHolder, storedType);
        switch (storedType) {
            case INT: {
                IntOpenHashSet intSet = (IntOpenHashSet)valueSet;
                int[] intValues = blockValSet.getIntValuesSV();
                if (this._nullHandlingEnabled) {
                    nullBitmap = blockValSet.getNullBitmap();
                }
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        intSet.add(intValues[i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        intSet.add(intValues[i]);
                    }
                }
                break;
            }
            case LONG: {
                LongOpenHashSet longSet = (LongOpenHashSet)valueSet;
                long[] longValues = blockValSet.getLongValuesSV();
                if (this._nullHandlingEnabled) {
                    nullBitmap = blockValSet.getNullBitmap();
                }
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        longSet.add(longValues[i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        longSet.add(longValues[i]);
                    }
                }
                break;
            }
            case FLOAT: {
                FloatOpenHashSet floatSet = (FloatOpenHashSet)valueSet;
                float[] floatValues = blockValSet.getFloatValuesSV();
                if (this._nullHandlingEnabled) {
                    nullBitmap = blockValSet.getNullBitmap();
                }
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        floatSet.add(floatValues[i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        floatSet.add(floatValues[i]);
                    }
                }
                break;
            }
            case DOUBLE: {
                DoubleOpenHashSet doubleSet = (DoubleOpenHashSet)valueSet;
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                if (this._nullHandlingEnabled) {
                    nullBitmap = blockValSet.getNullBitmap();
                }
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        doubleSet.add(doubleValues[i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        doubleSet.add(doubleValues[i]);
                    }
                }
                break;
            }
            case STRING: {
                ObjectOpenHashSet stringSet = (ObjectOpenHashSet)valueSet;
                String[] stringValues = blockValSet.getStringValuesSV();
                if (this._nullHandlingEnabled) {
                    nullBitmap = blockValSet.getNullBitmap();
                }
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        stringSet.add((Object)stringValues[i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        stringSet.add((Object)stringValues[i]);
                    }
                }
                break;
            }
            case BYTES: {
                ObjectOpenHashSet bytesSet = (ObjectOpenHashSet)valueSet;
                byte[][] bytesValues = blockValSet.getBytesValuesSV();
                if (this._nullHandlingEnabled) {
                    nullBitmap = blockValSet.getNullBitmap();
                }
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        bytesSet.add((Object)new ByteArray(bytesValues[i]));
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        bytesSet.add((Object)new ByteArray(bytesValues[i]));
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for " + this._functionType.getName() + " aggregation function: " + storedType);
            }
        }
    }

    protected void mvAggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            RoaringBitmap dictIdBitmap = BaseDistinctAggregateAggregationFunction.getDictIdBitmap(aggregationResultHolder, dictionary);
            int[][] dictIds = blockValSet.getDictionaryIdsMV();
            for (int i = 0; i < length; ++i) {
                dictIdBitmap.add(dictIds[i]);
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        Set valueSet = BaseDistinctAggregateAggregationFunction.getValueSet(aggregationResultHolder, storedType);
        switch (storedType) {
            case INT: {
                IntOpenHashSet intSet = (IntOpenHashSet)valueSet;
                int[][] intValues = blockValSet.getIntValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int value : intValues[i]) {
                        intSet.add(value);
                    }
                }
                break;
            }
            case LONG: {
                LongOpenHashSet longSet = (LongOpenHashSet)valueSet;
                long[][] longValues = blockValSet.getLongValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (long value : longValues[i]) {
                        longSet.add(value);
                    }
                }
                break;
            }
            case FLOAT: {
                FloatOpenHashSet floatSet = (FloatOpenHashSet)valueSet;
                float[][] floatValues = blockValSet.getFloatValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (float value : floatValues[i]) {
                        floatSet.add(value);
                    }
                }
                break;
            }
            case DOUBLE: {
                DoubleOpenHashSet doubleSet = (DoubleOpenHashSet)valueSet;
                double[][] doubleValues = blockValSet.getDoubleValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (double value : doubleValues[i]) {
                        doubleSet.add(value);
                    }
                }
                break;
            }
            case STRING: {
                ObjectOpenHashSet stringSet = (ObjectOpenHashSet)valueSet;
                String[][] stringValues = blockValSet.getStringValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (String value : stringValues[i]) {
                        stringSet.add((Object)value);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for " + this._functionType.getName() + " aggregation function: " + storedType);
            }
        }
    }

    protected void svAggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        RoaringBitmap nullBitmap = null;
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            if (this._nullHandlingEnabled) {
                nullBitmap = blockValSet.getNullBitmap();
            }
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            if (nullBitmap != null && !nullBitmap.isEmpty()) {
                for (int i = 0; i < length; ++i) {
                    if (nullBitmap.contains(i)) continue;
                    BaseDistinctAggregateAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKeyArray[i], dictionary).add(dictIds[i]);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    BaseDistinctAggregateAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKeyArray[i], dictionary).add(dictIds[i]);
                }
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                if (this._nullHandlingEnabled) {
                    nullBitmap = blockValSet.getNullBitmap();
                }
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        ((IntOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.INT)).add(intValues[i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        ((IntOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.INT)).add(intValues[i]);
                    }
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                if (this._nullHandlingEnabled) {
                    nullBitmap = blockValSet.getNullBitmap();
                }
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        ((LongOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.LONG)).add(longValues[i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        ((LongOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.LONG)).add(longValues[i]);
                    }
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                if (this._nullHandlingEnabled) {
                    nullBitmap = blockValSet.getNullBitmap();
                }
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        ((FloatOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.FLOAT)).add(floatValues[i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        ((FloatOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.FLOAT)).add(floatValues[i]);
                    }
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                if (this._nullHandlingEnabled) {
                    nullBitmap = blockValSet.getNullBitmap();
                }
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        ((DoubleOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.DOUBLE)).add(doubleValues[i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        ((DoubleOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.DOUBLE)).add(doubleValues[i]);
                    }
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                if (this._nullHandlingEnabled) {
                    nullBitmap = blockValSet.getNullBitmap();
                }
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        ((ObjectOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.STRING)).add((Object)stringValues[i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        ((ObjectOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.STRING)).add((Object)stringValues[i]);
                    }
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSet.getBytesValuesSV();
                if (this._nullHandlingEnabled) {
                    nullBitmap = blockValSet.getNullBitmap();
                }
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        ((ObjectOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.BYTES)).add((Object)new ByteArray(bytesValues[i]));
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        ((ObjectOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.BYTES)).add((Object)new ByteArray(bytesValues[i]));
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for " + this._functionType.getName() + " aggregation function: " + storedType);
            }
        }
    }

    protected void mvAggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[][] dictIds = blockValSet.getDictionaryIdsMV();
            for (int i = 0; i < length; ++i) {
                BaseDistinctAggregateAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKeyArray[i], dictionary).add(dictIds[i]);
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                int[][] intValues = blockValSet.getIntValuesMV();
                for (int i = 0; i < length; ++i) {
                    IntOpenHashSet intSet = (IntOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.INT);
                    for (int value : intValues[i]) {
                        intSet.add(value);
                    }
                }
                break;
            }
            case LONG: {
                long[][] longValues = blockValSet.getLongValuesMV();
                for (int i = 0; i < length; ++i) {
                    LongOpenHashSet longSet = (LongOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.LONG);
                    for (long value : longValues[i]) {
                        longSet.add(value);
                    }
                }
                break;
            }
            case FLOAT: {
                float[][] floatValues = blockValSet.getFloatValuesMV();
                for (int i = 0; i < length; ++i) {
                    FloatOpenHashSet floatSet = (FloatOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.FLOAT);
                    for (float value : floatValues[i]) {
                        floatSet.add(value);
                    }
                }
                break;
            }
            case DOUBLE: {
                double[][] doubleValues = blockValSet.getDoubleValuesMV();
                for (int i = 0; i < length; ++i) {
                    DoubleOpenHashSet doubleSet = (DoubleOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.DOUBLE);
                    for (double value : doubleValues[i]) {
                        doubleSet.add(value);
                    }
                }
                break;
            }
            case STRING: {
                String[][] stringValues = blockValSet.getStringValuesMV();
                for (int i = 0; i < length; ++i) {
                    ObjectOpenHashSet stringSet = (ObjectOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.STRING);
                    for (String value : stringValues[i]) {
                        stringSet.add((Object)value);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for " + this._functionType.getName() + " aggregation function: " + storedType);
            }
        }
    }

    protected void svAggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        RoaringBitmap nullBitmap = null;
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            if (this._nullHandlingEnabled) {
                nullBitmap = blockValSet.getNullBitmap();
            }
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            if (nullBitmap != null && !nullBitmap.isEmpty()) {
                for (int i = 0; i < length; ++i) {
                    if (nullBitmap.contains(i)) continue;
                    BaseDistinctAggregateAggregationFunction.setDictIdForGroupKeys(groupByResultHolder, groupKeysArray[i], dictionary, dictIds[i]);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    BaseDistinctAggregateAggregationFunction.setDictIdForGroupKeys(groupByResultHolder, groupKeysArray[i], dictionary, dictIds[i]);
                }
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                nullBitmap = blockValSet.getNullBitmap();
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        BaseDistinctAggregateAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], intValues[i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        BaseDistinctAggregateAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], intValues[i]);
                    }
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                nullBitmap = blockValSet.getNullBitmap();
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        BaseDistinctAggregateAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], longValues[i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        BaseDistinctAggregateAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], longValues[i]);
                    }
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                nullBitmap = blockValSet.getNullBitmap();
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        BaseDistinctAggregateAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], floatValues[i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        BaseDistinctAggregateAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], floatValues[i]);
                    }
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                nullBitmap = blockValSet.getNullBitmap();
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        BaseDistinctAggregateAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], doubleValues[i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        BaseDistinctAggregateAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], doubleValues[i]);
                    }
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                nullBitmap = blockValSet.getNullBitmap();
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        BaseDistinctAggregateAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], stringValues[i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        BaseDistinctAggregateAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], stringValues[i]);
                    }
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSet.getBytesValuesSV();
                nullBitmap = blockValSet.getNullBitmap();
                if (nullBitmap != null && !nullBitmap.isEmpty()) {
                    for (int i = 0; i < length; ++i) {
                        if (nullBitmap.contains(i)) continue;
                        BaseDistinctAggregateAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], new ByteArray(bytesValues[i]));
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        BaseDistinctAggregateAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], new ByteArray(bytesValues[i]));
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for " + this._functionType.getName() + " aggregation function: " + storedType);
            }
        }
    }

    protected void mvAggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[][] dictIds = blockValSet.getDictionaryIdsMV();
            for (int i = 0; i < length; ++i) {
                for (int groupKey : groupKeysArray[i]) {
                    BaseDistinctAggregateAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKey, dictionary).add(dictIds[i]);
                }
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                int[][] intValues = blockValSet.getIntValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        IntOpenHashSet intSet = (IntOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.INT);
                        for (int value : intValues[i]) {
                            intSet.add(value);
                        }
                    }
                }
                break;
            }
            case LONG: {
                long[][] longValues = blockValSet.getLongValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        LongOpenHashSet longSet = (LongOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.LONG);
                        for (long value : longValues[i]) {
                            longSet.add(value);
                        }
                    }
                }
                break;
            }
            case FLOAT: {
                float[][] floatValues = blockValSet.getFloatValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        FloatOpenHashSet floatSet = (FloatOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.FLOAT);
                        for (float value : floatValues[i]) {
                            floatSet.add(value);
                        }
                    }
                }
                break;
            }
            case DOUBLE: {
                double[][] doubleValues = blockValSet.getDoubleValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        DoubleOpenHashSet doubleSet = (DoubleOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.DOUBLE);
                        for (double value : doubleValues[i]) {
                            doubleSet.add(value);
                        }
                    }
                }
                break;
            }
            case STRING: {
                String[][] stringValues = blockValSet.getStringValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        ObjectOpenHashSet stringSet = (ObjectOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.STRING);
                        for (String value : stringValues[i]) {
                            stringSet.add((Object)value);
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for " + this._functionType.getName() + " aggregation function: " + storedType);
            }
        }
    }

    protected static Set getValueSet(AggregationResultHolder aggregationResultHolder, FieldSpec.DataType valueType) {
        Set valueSet = (Set)aggregationResultHolder.getResult();
        if (valueSet == null) {
            valueSet = BaseDistinctAggregateAggregationFunction.getValueSet(valueType);
            aggregationResultHolder.setValue(valueSet);
        }
        return valueSet;
    }

    private static Set getValueSet(FieldSpec.DataType valueType) {
        switch (valueType) {
            case INT: {
                return new IntOpenHashSet();
            }
            case LONG: {
                return new LongOpenHashSet();
            }
            case FLOAT: {
                return new FloatOpenHashSet();
            }
            case DOUBLE: {
                return new DoubleOpenHashSet();
            }
            case STRING: 
            case BYTES: {
                return new ObjectOpenHashSet();
            }
        }
        throw new IllegalStateException("Illegal data type for DISTINCT_AGGREGATE aggregation function valueType");
    }

    protected static RoaringBitmap getDictIdBitmap(GroupByResultHolder groupByResultHolder, int groupKey, Dictionary dictionary) {
        DictIdsWrapper dictIdsWrapper = (DictIdsWrapper)groupByResultHolder.getResult(groupKey);
        if (dictIdsWrapper == null) {
            dictIdsWrapper = new DictIdsWrapper(dictionary);
            groupByResultHolder.setValueForKey(groupKey, dictIdsWrapper);
        }
        return dictIdsWrapper._dictIdBitmap;
    }

    protected static Set getValueSet(GroupByResultHolder groupByResultHolder, int groupKey, FieldSpec.DataType valueType) {
        Set valueSet = (Set)groupByResultHolder.getResult(groupKey);
        if (valueSet == null) {
            valueSet = BaseDistinctAggregateAggregationFunction.getValueSet(valueType);
            groupByResultHolder.setValueForKey(groupKey, valueSet);
        }
        return valueSet;
    }

    private static void setDictIdForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, Dictionary dictionary, int dictId) {
        for (int groupKey : groupKeys) {
            BaseDistinctAggregateAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKey, dictionary).add(dictId);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, int value) {
        for (int groupKey : groupKeys) {
            ((IntOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.INT)).add(value);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, long value) {
        for (int groupKey : groupKeys) {
            ((LongOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.LONG)).add(value);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, float value) {
        for (int groupKey : groupKeys) {
            ((FloatOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.FLOAT)).add(value);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, double value) {
        for (int groupKey : groupKeys) {
            ((DoubleOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.DOUBLE)).add(value);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, String value) {
        for (int groupKey : groupKeys) {
            ((ObjectOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.STRING)).add((Object)value);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, ByteArray value) {
        for (int groupKey : groupKeys) {
            ((ObjectOpenHashSet)BaseDistinctAggregateAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.BYTES)).add((Object)value);
        }
    }

    private static Set convertToValueSet(DictIdsWrapper dictIdsWrapper) {
        Dictionary dictionary = dictIdsWrapper._dictionary;
        RoaringBitmap dictIdBitmap = dictIdsWrapper._dictIdBitmap;
        int numValues = dictIdBitmap.getCardinality();
        PeekableIntIterator iterator = dictIdBitmap.getIntIterator();
        FieldSpec.DataType storedType = dictionary.getValueType();
        switch (storedType) {
            case INT: {
                IntOpenHashSet intSet = new IntOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    intSet.add(dictionary.getIntValue(iterator.next()));
                }
                return intSet;
            }
            case LONG: {
                LongOpenHashSet longSet = new LongOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    longSet.add(dictionary.getLongValue(iterator.next()));
                }
                return longSet;
            }
            case FLOAT: {
                FloatOpenHashSet floatSet = new FloatOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    floatSet.add(dictionary.getFloatValue(iterator.next()));
                }
                return floatSet;
            }
            case DOUBLE: {
                DoubleOpenHashSet doubleSet = new DoubleOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    doubleSet.add(dictionary.getDoubleValue(iterator.next()));
                }
                return doubleSet;
            }
            case STRING: {
                ObjectOpenHashSet stringSet = new ObjectOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    stringSet.add((Object)dictionary.getStringValue(iterator.next()));
                }
                return stringSet;
            }
            case BYTES: {
                ObjectOpenHashSet bytesSet = new ObjectOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    bytesSet.add((Object)new ByteArray(dictionary.getBytesValue(iterator.next())));
                }
                return bytesSet;
            }
        }
        throw new IllegalStateException("Illegal data type for DISTINCT_AGGREGATE aggregation function: " + storedType);
    }

    private static final class DictIdsWrapper {
        final Dictionary _dictionary;
        final RoaringBitmap _dictIdBitmap;

        private DictIdsWrapper(Dictionary dictionary) {
            this._dictionary = dictionary;
            this._dictIdBitmap = new RoaringBitmap();
        }
    }
}

