/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;

public abstract class BaseSingleInputAggregationFunction<I, F extends Comparable>
implements AggregationFunction<I, F> {
    protected final ExpressionContext _expression;

    public BaseSingleInputAggregationFunction(ExpressionContext expression) {
        this._expression = expression;
    }

    @Override
    public String getResultColumnName() {
        return this.getType().getName().toLowerCase() + "(" + this._expression + ")";
    }

    @Override
    public List<ExpressionContext> getInputExpressions() {
        return Collections.singletonList(this._expression);
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(this.getType().getName()).append('(');
        int numArguments = this.getInputExpressions().size();
        if (numArguments > 0) {
            stringBuilder.append(this.getInputExpressions().get(0).toString());
            for (int i = 1; i < numArguments; ++i) {
                stringBuilder.append(", ").append(this.getInputExpressions().get(i).toString());
            }
        }
        return stringBuilder.append(')').toString();
    }

    protected static ExpressionContext verifySingleArgument(List<ExpressionContext> arguments, String functionName) {
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0, (String)"%s expects 1 argument, got: %s", (Object)functionName, (int)arguments.size());
        return arguments.get(0);
    }

    protected static <E> E getValue(AggregationResultHolder aggregationResultHolder, Supplier<E> orCreate) {
        Object result = aggregationResultHolder.getResult();
        if (result == null) {
            result = orCreate.get();
            aggregationResultHolder.setValue(result);
        }
        return (E)result;
    }

    protected static <E> E getValue(GroupByResultHolder groupByResultHolder, int groupKey, Supplier<E> orCreate) {
        Object result = groupByResultHolder.getResult(groupKey);
        if (result == null) {
            result = orCreate.get();
            groupByResultHolder.setValueForKey(groupKey, result);
        }
        return (E)result;
    }
}

