/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseDistinctAggregateAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class DistinctAvgMVAggregationFunction
extends BaseDistinctAggregateAggregationFunction<Double> {
    public DistinctAvgMVAggregationFunction(List<ExpressionContext> arguments) {
        super(DistinctAvgMVAggregationFunction.verifySingleArgument(arguments, "DISTINCT_AVG_MV"), AggregationFunctionType.DISTINCTAVGMV, false);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        this.mvAggregate(length, aggregationResultHolder, blockValSetMap);
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        this.mvAggregateGroupBySV(length, groupKeyArray, groupByResultHolder, blockValSetMap);
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        this.mvAggregateGroupByMV(length, groupKeysArray, groupByResultHolder, blockValSetMap);
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(Set intermediateResult) {
        Double distinctSum = 0.0;
        for (Object obj : intermediateResult) {
            distinctSum = distinctSum + ((Number)obj).doubleValue();
        }
        Double distinctAvg = distinctSum / (double)intermediateResult.size();
        return distinctAvg;
    }
}

