/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public class DistinctCountHLLPlusAggregationFunction
extends BaseSingleInputAggregationFunction<HyperLogLogPlus, Long> {
    protected final int _p;
    protected final int _sp;

    public DistinctCountHLLPlusAggregationFunction(List<ExpressionContext> arguments) {
        super(arguments.get(0));
        int numExpressions = arguments.size();
        Preconditions.checkArgument((numExpressions <= 3 ? 1 : 0) != 0, (String)"DistinctCountHLLPlus expects 2 or 3 arguments, got: %s", (int)numExpressions);
        if (arguments.size() == 2) {
            this._p = arguments.get(1).getLiteral().getIntValue();
            this._sp = 0;
        } else if (arguments.size() == 3) {
            this._p = arguments.get(1).getLiteral().getIntValue();
            this._sp = arguments.get(2).getLiteral().getIntValue();
        } else {
            this._p = 14;
            this._sp = 0;
        }
    }

    public int getP() {
        return this._p;
    }

    public int getSp() {
        return this._sp;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCTCOUNTHLLPLUS;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        if (storedType == FieldSpec.DataType.BYTES) {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            try {
                HyperLogLogPlus hyperLogLogPlus = (HyperLogLogPlus)aggregationResultHolder.getResult();
                if (hyperLogLogPlus == null) {
                    hyperLogLogPlus = ObjectSerDeUtils.HYPER_LOG_LOG_PLUS_SER_DE.deserialize(bytesValues[0]);
                    aggregationResultHolder.setValue(hyperLogLogPlus);
                } else {
                    hyperLogLogPlus.addAll(ObjectSerDeUtils.HYPER_LOG_LOG_PLUS_SER_DE.deserialize(bytesValues[0]));
                }
                for (int i = 1; i < length; ++i) {
                    hyperLogLogPlus.addAll(ObjectSerDeUtils.HYPER_LOG_LOG_PLUS_SER_DE.deserialize(bytesValues[i]));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while merging HyperLogLogPlus", e);
            }
            return;
        }
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            DistinctCountHLLPlusAggregationFunction.getDictIdBitmap(aggregationResultHolder, dictionary).addN(dictIds, 0, length);
            return;
        }
        HyperLogLogPlus hyperLogLogPlus = this.getHyperLogLogPlus(aggregationResultHolder);
        switch (storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    hyperLogLogPlus.offer((Object)intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    hyperLogLogPlus.offer((Object)longValues[i]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    hyperLogLogPlus.offer((Object)Float.valueOf(floatValues[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    hyperLogLogPlus.offer((Object)doubleValues[i]);
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    hyperLogLogPlus.offer((Object)stringValues[i]);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_HLL_PLUS aggregation function: " + storedType);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        if (storedType == FieldSpec.DataType.BYTES) {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            try {
                for (int i = 0; i < length; ++i) {
                    HyperLogLogPlus value = ObjectSerDeUtils.HYPER_LOG_LOG_PLUS_SER_DE.deserialize(bytesValues[i]);
                    int groupKey = groupKeyArray[i];
                    HyperLogLogPlus hyperLogLogPlus = (HyperLogLogPlus)groupByResultHolder.getResult(groupKey);
                    if (hyperLogLogPlus != null) {
                        hyperLogLogPlus.addAll(value);
                        continue;
                    }
                    groupByResultHolder.setValueForKey(groupKey, value);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while merging HyperLogLogPlus", e);
            }
            return;
        }
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            for (int i = 0; i < length; ++i) {
                DistinctCountHLLPlusAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKeyArray[i], dictionary).add(dictIds[i]);
            }
            return;
        }
        switch (storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.getHyperLogLogPlus(groupByResultHolder, groupKeyArray[i]).offer((Object)intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.getHyperLogLogPlus(groupByResultHolder, groupKeyArray[i]).offer((Object)longValues[i]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.getHyperLogLogPlus(groupByResultHolder, groupKeyArray[i]).offer((Object)Float.valueOf(floatValues[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.getHyperLogLogPlus(groupByResultHolder, groupKeyArray[i]).offer((Object)doubleValues[i]);
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.getHyperLogLogPlus(groupByResultHolder, groupKeyArray[i]).offer((Object)stringValues[i]);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_HLL_PLUS aggregation function: " + storedType);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        if (storedType == FieldSpec.DataType.BYTES) {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            try {
                for (int i = 0; i < length; ++i) {
                    HyperLogLogPlus value = ObjectSerDeUtils.HYPER_LOG_LOG_PLUS_SER_DE.deserialize(bytesValues[i]);
                    for (int groupKey : groupKeysArray[i]) {
                        HyperLogLogPlus hyperLogLogPlus = (HyperLogLogPlus)groupByResultHolder.getResult(groupKey);
                        if (hyperLogLogPlus != null) {
                            hyperLogLogPlus.addAll(value);
                            continue;
                        }
                        groupByResultHolder.setValueForKey(groupKey, ObjectSerDeUtils.HYPER_LOG_LOG_PLUS_SER_DE.deserialize(bytesValues[i]));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while merging HyperLogLogPlus", e);
            }
            return;
        }
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            for (int i = 0; i < length; ++i) {
                DistinctCountHLLPlusAggregationFunction.setDictIdForGroupKeys(groupByResultHolder, groupKeysArray[i], dictionary, dictIds[i]);
            }
            return;
        }
        switch (storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], longValues[i]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], Float.valueOf(floatValues[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], doubleValues[i]);
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], stringValues[i]);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_HLL_PLUS aggregation function: " + storedType);
            }
        }
    }

    @Override
    public HyperLogLogPlus extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        Object result = aggregationResultHolder.getResult();
        if (result == null) {
            return new HyperLogLogPlus(this._p, this._sp);
        }
        if (result instanceof DictIdsWrapper) {
            return this.convertToHyperLogLogPlus((DictIdsWrapper)result);
        }
        return (HyperLogLogPlus)result;
    }

    @Override
    public HyperLogLogPlus extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        Object result = groupByResultHolder.getResult(groupKey);
        if (result == null) {
            return new HyperLogLogPlus(this._p, this._sp);
        }
        if (result instanceof DictIdsWrapper) {
            return this.convertToHyperLogLogPlus((DictIdsWrapper)result);
        }
        return (HyperLogLogPlus)result;
    }

    @Override
    public HyperLogLogPlus merge(HyperLogLogPlus intermediateResult1, HyperLogLogPlus intermediateResult2) {
        if (intermediateResult1.sizeof() != intermediateResult2.sizeof()) {
            if (intermediateResult1.cardinality() == 0L) {
                return intermediateResult2;
            }
            Preconditions.checkState((intermediateResult2.cardinality() == 0L ? 1 : 0) != 0, (Object)"Cannot merge HyperLogLogPlus of different sizes");
            return intermediateResult1;
        }
        try {
            intermediateResult1.addAll(intermediateResult2);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while merging HyperLogLogPlus", e);
        }
        return intermediateResult1;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.LONG;
    }

    @Override
    public Long extractFinalResult(HyperLogLogPlus intermediateResult) {
        return intermediateResult.cardinality();
    }

    @Override
    public Long mergeFinalResult(Long finalResult1, Long finalResult2) {
        return finalResult1 + finalResult2;
    }

    protected static RoaringBitmap getDictIdBitmap(AggregationResultHolder aggregationResultHolder, Dictionary dictionary) {
        DictIdsWrapper dictIdsWrapper = (DictIdsWrapper)aggregationResultHolder.getResult();
        if (dictIdsWrapper == null) {
            dictIdsWrapper = new DictIdsWrapper(dictionary);
            aggregationResultHolder.setValue(dictIdsWrapper);
        }
        return dictIdsWrapper._dictIdBitmap;
    }

    protected HyperLogLogPlus getHyperLogLogPlus(AggregationResultHolder aggregationResultHolder) {
        HyperLogLogPlus hyperLogLogPlus = (HyperLogLogPlus)aggregationResultHolder.getResult();
        if (hyperLogLogPlus == null) {
            hyperLogLogPlus = new HyperLogLogPlus(this._p, this._sp);
            aggregationResultHolder.setValue(hyperLogLogPlus);
        }
        return hyperLogLogPlus;
    }

    protected static RoaringBitmap getDictIdBitmap(GroupByResultHolder groupByResultHolder, int groupKey, Dictionary dictionary) {
        DictIdsWrapper dictIdsWrapper = (DictIdsWrapper)groupByResultHolder.getResult(groupKey);
        if (dictIdsWrapper == null) {
            dictIdsWrapper = new DictIdsWrapper(dictionary);
            groupByResultHolder.setValueForKey(groupKey, dictIdsWrapper);
        }
        return dictIdsWrapper._dictIdBitmap;
    }

    protected HyperLogLogPlus getHyperLogLogPlus(GroupByResultHolder groupByResultHolder, int groupKey) {
        HyperLogLogPlus hyperLogLogPlus = (HyperLogLogPlus)groupByResultHolder.getResult(groupKey);
        if (hyperLogLogPlus == null) {
            hyperLogLogPlus = new HyperLogLogPlus(this._p, this._sp);
            groupByResultHolder.setValueForKey(groupKey, hyperLogLogPlus);
        }
        return hyperLogLogPlus;
    }

    private static void setDictIdForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, Dictionary dictionary, int dictId) {
        for (int groupKey : groupKeys) {
            DistinctCountHLLPlusAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKey, dictionary).add(dictId);
        }
    }

    private void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, Object value) {
        for (int groupKey : groupKeys) {
            this.getHyperLogLogPlus(groupByResultHolder, groupKey).offer(value);
        }
    }

    private HyperLogLogPlus convertToHyperLogLogPlus(DictIdsWrapper dictIdsWrapper) {
        HyperLogLogPlus hyperLogLogPlus = new HyperLogLogPlus(this._p, this._sp);
        Dictionary dictionary = dictIdsWrapper._dictionary;
        RoaringBitmap dictIdBitmap = dictIdsWrapper._dictIdBitmap;
        PeekableIntIterator iterator = dictIdBitmap.getIntIterator();
        while (iterator.hasNext()) {
            hyperLogLogPlus.offer(dictionary.get(iterator.next()));
        }
        return hyperLogLogPlus;
    }

    private static final class DictIdsWrapper {
        final Dictionary _dictionary;
        final RoaringBitmap _dictIdBitmap;

        private DictIdsWrapper(Dictionary dictionary) {
            this._dictionary = dictionary;
            this._dictIdBitmap = new RoaringBitmap();
        }
    }
}

