/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public class DistinctCountSmartHLLAggregationFunction
extends BaseSingleInputAggregationFunction<Object, Integer> {
    private final int _threshold;
    private final int _log2m;

    public DistinctCountSmartHLLAggregationFunction(List<ExpressionContext> arguments) {
        super(arguments.get(0));
        if (arguments.size() > 1) {
            Parameters parameters = new Parameters(arguments.get(1).getLiteral().getStringValue());
            this._threshold = parameters._threshold;
            this._log2m = parameters._log2m;
        } else {
            this._threshold = 100000;
            this._log2m = 12;
        }
    }

    public int getThreshold() {
        return this._threshold;
    }

    public int getLog2m() {
        return this._log2m;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCTCOUNTSMARTHLL;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            RoaringBitmap dictIdBitmap = DistinctCountSmartHLLAggregationFunction.getDictIdBitmap(aggregationResultHolder, dictionary);
            if (blockValSet.isSingleValue()) {
                int[] dictIds = blockValSet.getDictionaryIdsSV();
                dictIdBitmap.addN(dictIds, 0, length);
            } else {
                int[][] dictIds = blockValSet.getDictionaryIdsMV();
                for (int i = 0; i < length; ++i) {
                    dictIdBitmap.add(dictIds[i]);
                }
            }
            return;
        }
        if (aggregationResultHolder.getResult() instanceof HyperLogLog) {
            this.aggregateIntoHLL(length, aggregationResultHolder, blockValSet);
        } else {
            this.aggregateIntoSet(length, aggregationResultHolder, blockValSet);
        }
    }

    private void aggregateIntoHLL(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet) {
        block32: {
            HyperLogLog hll;
            FieldSpec.DataType storedType;
            FieldSpec.DataType valueType;
            block31: {
                valueType = blockValSet.getValueType();
                storedType = valueType.getStoredType();
                hll = (HyperLogLog)aggregationResultHolder.getResult();
                if (!blockValSet.isSingleValue()) break block31;
                switch (storedType) {
                    case INT: {
                        int[] intValues = blockValSet.getIntValuesSV();
                        for (int i = 0; i < length; ++i) {
                            hll.offer((Object)intValues[i]);
                        }
                        break block32;
                    }
                    case LONG: {
                        long[] longValues = blockValSet.getLongValuesSV();
                        for (int i = 0; i < length; ++i) {
                            hll.offer((Object)longValues[i]);
                        }
                        break block32;
                    }
                    case FLOAT: {
                        float[] floatValues = blockValSet.getFloatValuesSV();
                        for (int i = 0; i < length; ++i) {
                            hll.offer((Object)Float.valueOf(floatValues[i]));
                        }
                        break block32;
                    }
                    case DOUBLE: {
                        double[] doubleValues = blockValSet.getDoubleValuesSV();
                        for (int i = 0; i < length; ++i) {
                            hll.offer((Object)doubleValues[i]);
                        }
                        break block32;
                    }
                    case STRING: {
                        String[] stringValues = blockValSet.getStringValuesSV();
                        for (int i = 0; i < length; ++i) {
                            hll.offer((Object)stringValues[i]);
                        }
                        break block32;
                    }
                    case BYTES: {
                        byte[][] bytesValues = blockValSet.getBytesValuesSV();
                        for (int i = 0; i < length; ++i) {
                            hll.offer((Object)bytesValues[i]);
                        }
                        break block32;
                    }
                    default: {
                        throw DistinctCountSmartHLLAggregationFunction.getIllegalDataTypeException(valueType, true);
                    }
                }
            }
            switch (storedType) {
                case INT: {
                    int[][] intValues = blockValSet.getIntValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (int value : intValues[i]) {
                            hll.offer((Object)value);
                        }
                    }
                    break;
                }
                case LONG: {
                    long[][] longValues = blockValSet.getLongValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (long value : longValues[i]) {
                            hll.offer((Object)value);
                        }
                    }
                    break;
                }
                case FLOAT: {
                    float[][] floatValues = blockValSet.getFloatValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (float value : floatValues[i]) {
                            hll.offer((Object)Float.valueOf(value));
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValues = blockValSet.getDoubleValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (double value : doubleValues[i]) {
                            hll.offer((Object)value);
                        }
                    }
                    break;
                }
                case STRING: {
                    String[][] stringValues = blockValSet.getStringValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (String value : stringValues[i]) {
                            hll.offer((Object)value);
                        }
                    }
                    break;
                }
                default: {
                    throw DistinctCountSmartHLLAggregationFunction.getIllegalDataTypeException(valueType, false);
                }
            }
        }
    }

    private void aggregateIntoSet(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet) {
        Set valueSet;
        FieldSpec.DataType storedType;
        block33: {
            FieldSpec.DataType valueType;
            block32: {
                valueType = blockValSet.getValueType();
                storedType = valueType.getStoredType();
                valueSet = DistinctCountSmartHLLAggregationFunction.getValueSet(aggregationResultHolder, storedType);
                if (!blockValSet.isSingleValue()) break block32;
                switch (storedType) {
                    case INT: {
                        IntOpenHashSet intSet = (IntOpenHashSet)valueSet;
                        int[] intValues = blockValSet.getIntValuesSV();
                        for (int i = 0; i < length; ++i) {
                            intSet.add(intValues[i]);
                        }
                        break block33;
                    }
                    case LONG: {
                        LongOpenHashSet longSet = (LongOpenHashSet)valueSet;
                        long[] longValues = blockValSet.getLongValuesSV();
                        for (int i = 0; i < length; ++i) {
                            longSet.add(longValues[i]);
                        }
                        break block33;
                    }
                    case FLOAT: {
                        FloatOpenHashSet floatSet = (FloatOpenHashSet)valueSet;
                        float[] floatValues = blockValSet.getFloatValuesSV();
                        for (int i = 0; i < length; ++i) {
                            floatSet.add(floatValues[i]);
                        }
                        break block33;
                    }
                    case DOUBLE: {
                        DoubleOpenHashSet doubleSet = (DoubleOpenHashSet)valueSet;
                        double[] doubleValues = blockValSet.getDoubleValuesSV();
                        for (int i = 0; i < length; ++i) {
                            doubleSet.add(doubleValues[i]);
                        }
                        break block33;
                    }
                    case STRING: {
                        ObjectOpenHashSet stringSet = (ObjectOpenHashSet)valueSet;
                        String[] stringValues = blockValSet.getStringValuesSV();
                        for (int i = 0; i < length; ++i) {
                            stringSet.add((Object)stringValues[i]);
                        }
                        break block33;
                    }
                    case BYTES: {
                        ObjectOpenHashSet bytesSet = (ObjectOpenHashSet)valueSet;
                        byte[][] bytesValues = blockValSet.getBytesValuesSV();
                        for (int i = 0; i < length; ++i) {
                            bytesSet.add((Object)new ByteArray(bytesValues[i]));
                        }
                        break block33;
                    }
                    default: {
                        throw DistinctCountSmartHLLAggregationFunction.getIllegalDataTypeException(valueType, true);
                    }
                }
            }
            switch (storedType) {
                case INT: {
                    IntOpenHashSet intSet = (IntOpenHashSet)valueSet;
                    int[][] intValues = blockValSet.getIntValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (int value : intValues[i]) {
                            intSet.add(value);
                        }
                    }
                    break;
                }
                case LONG: {
                    LongOpenHashSet longSet = (LongOpenHashSet)valueSet;
                    long[][] longValues = blockValSet.getLongValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (long value : longValues[i]) {
                            longSet.add(value);
                        }
                    }
                    break;
                }
                case FLOAT: {
                    FloatOpenHashSet floatSet = (FloatOpenHashSet)valueSet;
                    float[][] floatValues = blockValSet.getFloatValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (float value : floatValues[i]) {
                            floatSet.add(value);
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    DoubleOpenHashSet doubleSet = (DoubleOpenHashSet)valueSet;
                    double[][] doubleValues = blockValSet.getDoubleValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (double value : doubleValues[i]) {
                            doubleSet.add(value);
                        }
                    }
                    break;
                }
                case STRING: {
                    ObjectOpenHashSet stringSet = (ObjectOpenHashSet)valueSet;
                    String[][] stringValues = blockValSet.getStringValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (String value : stringValues[i]) {
                            stringSet.add((Object)value);
                        }
                    }
                    break;
                }
                default: {
                    throw DistinctCountSmartHLLAggregationFunction.getIllegalDataTypeException(valueType, false);
                }
            }
        }
        if (valueSet.size() > this._threshold) {
            aggregationResultHolder.setValue(this.convertSetToHLL(valueSet, storedType));
        }
    }

    protected HyperLogLog convertSetToHLL(Set valueSet, FieldSpec.DataType storedType) {
        if (storedType == FieldSpec.DataType.BYTES) {
            return this.convertByteArraySetToHLL((ObjectSet<ByteArray>)((ObjectSet)valueSet));
        }
        return this.convertNonByteArraySetToHLL(valueSet);
    }

    protected HyperLogLog convertByteArraySetToHLL(ObjectSet<ByteArray> valueSet) {
        HyperLogLog hll = new HyperLogLog(this._log2m);
        for (ByteArray value : valueSet) {
            hll.offer((Object)value.getBytes());
        }
        return hll;
    }

    protected HyperLogLog convertNonByteArraySetToHLL(Set valueSet) {
        HyperLogLog hll = new HyperLogLog(this._log2m);
        for (Object value : valueSet) {
            hll.offer(value);
        }
        return hll;
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        block37: {
            FieldSpec.DataType storedType;
            FieldSpec.DataType valueType;
            BlockValSet blockValSet;
            block36: {
                blockValSet = blockValSetMap.get(this._expression);
                Dictionary dictionary = blockValSet.getDictionary();
                if (dictionary != null) {
                    if (blockValSet.isSingleValue()) {
                        int[] dictIds = blockValSet.getDictionaryIdsSV();
                        for (int i = 0; i < length; ++i) {
                            DistinctCountSmartHLLAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKeyArray[i], dictionary).add(dictIds[i]);
                        }
                    } else {
                        int[][] dictIds = blockValSet.getDictionaryIdsMV();
                        for (int i = 0; i < length; ++i) {
                            DistinctCountSmartHLLAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKeyArray[i], dictionary).add(dictIds[i]);
                        }
                    }
                    return;
                }
                valueType = blockValSet.getValueType();
                storedType = valueType.getStoredType();
                if (!blockValSet.isSingleValue()) break block36;
                switch (storedType) {
                    case INT: {
                        int[] intValues = blockValSet.getIntValuesSV();
                        for (int i = 0; i < length; ++i) {
                            ((IntOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.INT)).add(intValues[i]);
                        }
                        break block37;
                    }
                    case LONG: {
                        long[] longValues = blockValSet.getLongValuesSV();
                        for (int i = 0; i < length; ++i) {
                            ((LongOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.LONG)).add(longValues[i]);
                        }
                        break block37;
                    }
                    case FLOAT: {
                        float[] floatValues = blockValSet.getFloatValuesSV();
                        for (int i = 0; i < length; ++i) {
                            ((FloatOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.FLOAT)).add(floatValues[i]);
                        }
                        break block37;
                    }
                    case DOUBLE: {
                        double[] doubleValues = blockValSet.getDoubleValuesSV();
                        for (int i = 0; i < length; ++i) {
                            ((DoubleOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.DOUBLE)).add(doubleValues[i]);
                        }
                        break block37;
                    }
                    case STRING: {
                        String[] stringValues = blockValSet.getStringValuesSV();
                        for (int i = 0; i < length; ++i) {
                            ((ObjectOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.STRING)).add((Object)stringValues[i]);
                        }
                        break block37;
                    }
                    case BYTES: {
                        byte[][] bytesValues = blockValSet.getBytesValuesSV();
                        for (int i = 0; i < length; ++i) {
                            ((ObjectOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.BYTES)).add((Object)new ByteArray(bytesValues[i]));
                        }
                        break block37;
                    }
                    default: {
                        throw DistinctCountSmartHLLAggregationFunction.getIllegalDataTypeException(valueType, true);
                    }
                }
            }
            switch (storedType) {
                case INT: {
                    int[][] intValues = blockValSet.getIntValuesMV();
                    for (int i = 0; i < length; ++i) {
                        IntOpenHashSet intSet = (IntOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.INT);
                        for (int value : intValues[i]) {
                            intSet.add(value);
                        }
                    }
                    break;
                }
                case LONG: {
                    long[][] longValues = blockValSet.getLongValuesMV();
                    for (int i = 0; i < length; ++i) {
                        LongOpenHashSet longSet = (LongOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.LONG);
                        for (long value : longValues[i]) {
                            longSet.add(value);
                        }
                    }
                    break;
                }
                case FLOAT: {
                    float[][] floatValues = blockValSet.getFloatValuesMV();
                    for (int i = 0; i < length; ++i) {
                        FloatOpenHashSet floatSet = (FloatOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.FLOAT);
                        for (float value : floatValues[i]) {
                            floatSet.add(value);
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValues = blockValSet.getDoubleValuesMV();
                    for (int i = 0; i < length; ++i) {
                        DoubleOpenHashSet doubleSet = (DoubleOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.DOUBLE);
                        for (double value : doubleValues[i]) {
                            doubleSet.add(value);
                        }
                    }
                    break;
                }
                case STRING: {
                    String[][] stringValues = blockValSet.getStringValuesMV();
                    for (int i = 0; i < length; ++i) {
                        ObjectOpenHashSet stringSet = (ObjectOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.STRING);
                        for (String value : stringValues[i]) {
                            stringSet.add((Object)value);
                        }
                    }
                    break;
                }
                default: {
                    throw DistinctCountSmartHLLAggregationFunction.getIllegalDataTypeException(valueType, false);
                }
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        block43: {
            FieldSpec.DataType storedType;
            FieldSpec.DataType valueType;
            BlockValSet blockValSet;
            block42: {
                blockValSet = blockValSetMap.get(this._expression);
                Dictionary dictionary = blockValSet.getDictionary();
                if (dictionary != null) {
                    if (blockValSet.isSingleValue()) {
                        int[] dictIds = blockValSet.getDictionaryIdsSV();
                        for (int i = 0; i < length; ++i) {
                            DistinctCountSmartHLLAggregationFunction.setDictIdForGroupKeys(groupByResultHolder, groupKeysArray[i], dictionary, dictIds[i]);
                        }
                    } else {
                        int[][] dictIds = blockValSet.getDictionaryIdsMV();
                        for (int i = 0; i < length; ++i) {
                            for (int groupKey : groupKeysArray[i]) {
                                DistinctCountSmartHLLAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKey, dictionary).add(dictIds[i]);
                            }
                        }
                    }
                    return;
                }
                valueType = blockValSet.getValueType();
                storedType = valueType.getStoredType();
                if (!blockValSet.isSingleValue()) break block42;
                switch (storedType) {
                    case INT: {
                        int[] intValues = blockValSet.getIntValuesSV();
                        for (int i = 0; i < length; ++i) {
                            DistinctCountSmartHLLAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], intValues[i]);
                        }
                        break block43;
                    }
                    case LONG: {
                        long[] longValues = blockValSet.getLongValuesSV();
                        for (int i = 0; i < length; ++i) {
                            DistinctCountSmartHLLAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], longValues[i]);
                        }
                        break block43;
                    }
                    case FLOAT: {
                        float[] floatValues = blockValSet.getFloatValuesSV();
                        for (int i = 0; i < length; ++i) {
                            DistinctCountSmartHLLAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], floatValues[i]);
                        }
                        break block43;
                    }
                    case DOUBLE: {
                        double[] doubleValues = blockValSet.getDoubleValuesSV();
                        for (int i = 0; i < length; ++i) {
                            DistinctCountSmartHLLAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], doubleValues[i]);
                        }
                        break block43;
                    }
                    case STRING: {
                        String[] stringValues = blockValSet.getStringValuesSV();
                        for (int i = 0; i < length; ++i) {
                            DistinctCountSmartHLLAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], stringValues[i]);
                        }
                        break block43;
                    }
                    case BYTES: {
                        byte[][] bytesValues = blockValSet.getBytesValuesSV();
                        for (int i = 0; i < length; ++i) {
                            DistinctCountSmartHLLAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], new ByteArray(bytesValues[i]));
                        }
                        break block43;
                    }
                    default: {
                        throw DistinctCountSmartHLLAggregationFunction.getIllegalDataTypeException(valueType, true);
                    }
                }
            }
            switch (storedType) {
                case INT: {
                    int[][] intValues = blockValSet.getIntValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (int groupKey : groupKeysArray[i]) {
                            IntOpenHashSet intSet = (IntOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.INT);
                            for (int value : intValues[i]) {
                                intSet.add(value);
                            }
                        }
                    }
                    break;
                }
                case LONG: {
                    long[][] longValues = blockValSet.getLongValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (int groupKey : groupKeysArray[i]) {
                            LongOpenHashSet longSet = (LongOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.LONG);
                            for (long value : longValues[i]) {
                                longSet.add(value);
                            }
                        }
                    }
                    break;
                }
                case FLOAT: {
                    float[][] floatValues = blockValSet.getFloatValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (int groupKey : groupKeysArray[i]) {
                            FloatOpenHashSet floatSet = (FloatOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.FLOAT);
                            for (float value : floatValues[i]) {
                                floatSet.add(value);
                            }
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValues = blockValSet.getDoubleValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (int groupKey : groupKeysArray[i]) {
                            DoubleOpenHashSet doubleSet = (DoubleOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.DOUBLE);
                            for (double value : doubleValues[i]) {
                                doubleSet.add(value);
                            }
                        }
                    }
                    break;
                }
                case STRING: {
                    String[][] stringValues = blockValSet.getStringValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (int groupKey : groupKeysArray[i]) {
                            ObjectOpenHashSet stringSet = (ObjectOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.STRING);
                            for (String value : stringValues[i]) {
                                stringSet.add((Object)value);
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw DistinctCountSmartHLLAggregationFunction.getIllegalDataTypeException(valueType, false);
                }
            }
        }
    }

    @Override
    public Object extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        Object result = aggregationResultHolder.getResult();
        if (result == null) {
            return new IntOpenHashSet();
        }
        if (result instanceof DictIdsWrapper) {
            DictIdsWrapper dictIdsWrapper = (DictIdsWrapper)result;
            if (dictIdsWrapper._dictIdBitmap.cardinalityExceeds((long)this._threshold)) {
                return this.convertToHLL(dictIdsWrapper);
            }
            return DistinctCountSmartHLLAggregationFunction.convertToValueSet(dictIdsWrapper);
        }
        return result;
    }

    @Override
    public Set extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        Object result = groupByResultHolder.getResult(groupKey);
        if (result == null) {
            return new IntOpenHashSet();
        }
        if (result instanceof DictIdsWrapper) {
            return DistinctCountSmartHLLAggregationFunction.convertToValueSet((DictIdsWrapper)result);
        }
        return (Set)result;
    }

    @Override
    public Object merge(Object intermediateResult1, Object intermediateResult2) {
        if (intermediateResult1 instanceof HyperLogLog) {
            return DistinctCountSmartHLLAggregationFunction.mergeIntoHLL((HyperLogLog)intermediateResult1, intermediateResult2);
        }
        if (intermediateResult2 instanceof HyperLogLog) {
            return DistinctCountSmartHLLAggregationFunction.mergeIntoHLL((HyperLogLog)intermediateResult2, intermediateResult1);
        }
        Set valueSet1 = (Set)intermediateResult1;
        Set valueSet2 = (Set)intermediateResult2;
        if (valueSet1.isEmpty()) {
            return valueSet2;
        }
        if (valueSet2.isEmpty()) {
            return valueSet1;
        }
        valueSet1.addAll(valueSet2);
        if (valueSet1.size() > this._threshold) {
            if (valueSet1 instanceof ObjectSet && valueSet1.iterator().next() instanceof ByteArray) {
                return this.convertByteArraySetToHLL((ObjectSet<ByteArray>)((ObjectSet)valueSet1));
            }
            return this.convertNonByteArraySetToHLL(valueSet1);
        }
        return valueSet1;
    }

    private static HyperLogLog mergeIntoHLL(HyperLogLog hll, Object intermediateResult) {
        block7: {
            if (intermediateResult instanceof HyperLogLog) {
                try {
                    hll.addAll((HyperLogLog)intermediateResult);
                }
                catch (CardinalityMergeException e) {
                    throw new RuntimeException("Caught exception while merging HyperLogLog", e);
                }
            }
            Set valueSet = (Set)intermediateResult;
            if (valueSet.isEmpty()) break block7;
            if (valueSet instanceof ObjectSet && valueSet.iterator().next() instanceof ByteArray) {
                for (Object value : valueSet) {
                    hll.offer((Object)((ByteArray)value).getBytes());
                }
            } else {
                for (Object value : valueSet) {
                    hll.offer(value);
                }
            }
        }
        return hll;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.INT;
    }

    @Override
    public Integer extractFinalResult(Object intermediateResult) {
        if (intermediateResult instanceof HyperLogLog) {
            return (int)((HyperLogLog)intermediateResult).cardinality();
        }
        return ((Set)intermediateResult).size();
    }

    @Override
    public Integer mergeFinalResult(Integer finalResult1, Integer finalResult2) {
        return finalResult1 + finalResult2;
    }

    protected static RoaringBitmap getDictIdBitmap(AggregationResultHolder aggregationResultHolder, Dictionary dictionary) {
        DictIdsWrapper dictIdsWrapper = (DictIdsWrapper)aggregationResultHolder.getResult();
        if (dictIdsWrapper == null) {
            dictIdsWrapper = new DictIdsWrapper(dictionary);
            aggregationResultHolder.setValue(dictIdsWrapper);
        }
        return dictIdsWrapper._dictIdBitmap;
    }

    protected static Set getValueSet(AggregationResultHolder aggregationResultHolder, FieldSpec.DataType valueType) {
        Set valueSet = (Set)aggregationResultHolder.getResult();
        if (valueSet == null) {
            valueSet = DistinctCountSmartHLLAggregationFunction.getValueSet(valueType);
            aggregationResultHolder.setValue(valueSet);
        }
        return valueSet;
    }

    private static Set getValueSet(FieldSpec.DataType valueType) {
        switch (valueType) {
            case INT: {
                return new IntOpenHashSet();
            }
            case LONG: {
                return new LongOpenHashSet();
            }
            case FLOAT: {
                return new FloatOpenHashSet();
            }
            case DOUBLE: {
                return new DoubleOpenHashSet();
            }
            case STRING: 
            case BYTES: {
                return new ObjectOpenHashSet();
            }
        }
        throw new IllegalStateException("Illegal data type for DISTINCT_COUNT aggregation function: " + valueType);
    }

    protected static RoaringBitmap getDictIdBitmap(GroupByResultHolder groupByResultHolder, int groupKey, Dictionary dictionary) {
        DictIdsWrapper dictIdsWrapper = (DictIdsWrapper)groupByResultHolder.getResult(groupKey);
        if (dictIdsWrapper == null) {
            dictIdsWrapper = new DictIdsWrapper(dictionary);
            groupByResultHolder.setValueForKey(groupKey, dictIdsWrapper);
        }
        return dictIdsWrapper._dictIdBitmap;
    }

    protected static Set getValueSet(GroupByResultHolder groupByResultHolder, int groupKey, FieldSpec.DataType valueType) {
        Set valueSet = (Set)groupByResultHolder.getResult(groupKey);
        if (valueSet == null) {
            valueSet = DistinctCountSmartHLLAggregationFunction.getValueSet(valueType);
            groupByResultHolder.setValueForKey(groupKey, valueSet);
        }
        return valueSet;
    }

    private static void setDictIdForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, Dictionary dictionary, int dictId) {
        for (int groupKey : groupKeys) {
            DistinctCountSmartHLLAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKey, dictionary).add(dictId);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, int value) {
        for (int groupKey : groupKeys) {
            ((IntOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.INT)).add(value);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, long value) {
        for (int groupKey : groupKeys) {
            ((LongOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.LONG)).add(value);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, float value) {
        for (int groupKey : groupKeys) {
            ((FloatOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.FLOAT)).add(value);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, double value) {
        for (int groupKey : groupKeys) {
            ((DoubleOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.DOUBLE)).add(value);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, String value) {
        for (int groupKey : groupKeys) {
            ((ObjectOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.STRING)).add((Object)value);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, ByteArray value) {
        for (int groupKey : groupKeys) {
            ((ObjectOpenHashSet)DistinctCountSmartHLLAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.BYTES)).add((Object)value);
        }
    }

    private static Set convertToValueSet(DictIdsWrapper dictIdsWrapper) {
        Dictionary dictionary = dictIdsWrapper._dictionary;
        RoaringBitmap dictIdBitmap = dictIdsWrapper._dictIdBitmap;
        int numValues = dictIdBitmap.getCardinality();
        PeekableIntIterator iterator = dictIdBitmap.getIntIterator();
        FieldSpec.DataType storedType = dictionary.getValueType();
        switch (storedType) {
            case INT: {
                IntOpenHashSet intSet = new IntOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    intSet.add(dictionary.getIntValue(iterator.next()));
                }
                return intSet;
            }
            case LONG: {
                LongOpenHashSet longSet = new LongOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    longSet.add(dictionary.getLongValue(iterator.next()));
                }
                return longSet;
            }
            case FLOAT: {
                FloatOpenHashSet floatSet = new FloatOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    floatSet.add(dictionary.getFloatValue(iterator.next()));
                }
                return floatSet;
            }
            case DOUBLE: {
                DoubleOpenHashSet doubleSet = new DoubleOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    doubleSet.add(dictionary.getDoubleValue(iterator.next()));
                }
                return doubleSet;
            }
            case STRING: {
                ObjectOpenHashSet stringSet = new ObjectOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    stringSet.add((Object)dictionary.getStringValue(iterator.next()));
                }
                return stringSet;
            }
            case BYTES: {
                ObjectOpenHashSet bytesSet = new ObjectOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    bytesSet.add((Object)new ByteArray(dictionary.getBytesValue(iterator.next())));
                }
                return bytesSet;
            }
        }
        throw new IllegalStateException("Illegal data type for DISTINCT_COUNT aggregation function: " + storedType);
    }

    private HyperLogLog convertToHLL(DictIdsWrapper dictIdsWrapper) {
        HyperLogLog hyperLogLog = new HyperLogLog(this._log2m);
        Dictionary dictionary = dictIdsWrapper._dictionary;
        RoaringBitmap dictIdBitmap = dictIdsWrapper._dictIdBitmap;
        PeekableIntIterator iterator = dictIdBitmap.getIntIterator();
        while (iterator.hasNext()) {
            hyperLogLog.offer(dictionary.get(iterator.next()));
        }
        return hyperLogLog;
    }

    private static IllegalStateException getIllegalDataTypeException(FieldSpec.DataType dataType, boolean singleValue) {
        return new IllegalStateException("Illegal data type for DISTINCT_COUNT_SMART_HLL aggregation function: " + dataType + (singleValue ? "" : "_MV"));
    }

    private static class Parameters {
        static final char PARAMETER_DELIMITER = ';';
        static final char PARAMETER_KEY_VALUE_SEPARATOR = '=';
        static final String THRESHOLD_KEY = "THRESHOLD";
        static final int DEFAULT_THRESHOLD = 100000;
        @Deprecated
        static final String DEPRECATED_THRESHOLD_KEY = "HLLCONVERSIONTHRESHOLD";
        static final String LOG2M_KEY = "LOG2M";
        static final int DEFAULT_LOG2M = 12;
        @Deprecated
        static final String DEPRECATED_LOG2M_KEY = "HLLLOG2M";
        int _threshold = 100000;
        int _log2m = 12;

        Parameters(String parametersString) {
            String[] keyValuePairs;
            StringUtils.deleteWhitespace((String)parametersString);
            block10: for (String keyValuePair : keyValuePairs = StringUtils.split((String)parametersString, (char)';')) {
                String[] keyAndValue = StringUtils.split((String)keyValuePair, (char)'=');
                Preconditions.checkArgument((keyAndValue.length == 2 ? 1 : 0) != 0, (String)"Invalid parameter: %s", (Object)keyValuePair);
                String key = keyAndValue[0];
                String value = keyAndValue[1];
                switch (key.toUpperCase()) {
                    case "THRESHOLD": 
                    case "HLLCONVERSIONTHRESHOLD": {
                        this._threshold = Integer.parseInt(value);
                        if (this._threshold > 0) continue block10;
                        this._threshold = Integer.MAX_VALUE;
                        continue block10;
                    }
                    case "LOG2M": 
                    case "HLLLOG2M": {
                        this._log2m = Integer.parseInt(value);
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid parameter key: " + key);
                    }
                }
            }
        }
    }

    private static final class DictIdsWrapper {
        final Dictionary _dictionary;
        final RoaringBitmap _dictIdBitmap;

        private DictIdsWrapper(Dictionary dictionary) {
            this._dictionary = dictionary;
            this._dictIdBitmap = new RoaringBitmap();
        }
    }
}

