/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.function.LastWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.local.customobject.LongLongPair;
import org.apache.pinot.segment.local.customobject.ValueLongPair;
import org.roaringbitmap.IntIterator;

public class LastLongValueWithTimeAggregationFunction
extends LastWithTimeAggregationFunction<Long> {
    private static final ValueLongPair<Long> DEFAULT_VALUE_TIME_PAIR = new LongLongPair(Long.valueOf(Long.MIN_VALUE), Long.MIN_VALUE);

    public LastLongValueWithTimeAggregationFunction(ExpressionContext dataCol, ExpressionContext timeCol, boolean nullHandlingEnabled) {
        super(dataCol, timeCol, ObjectSerDeUtils.LONG_LONG_PAIR_SER_DE, nullHandlingEnabled);
    }

    @Override
    public ValueLongPair<Long> constructValueLongPair(Long value, long time) {
        return new LongLongPair(value, time);
    }

    @Override
    public ValueLongPair<Long> getDefaultValueTimePair() {
        return DEFAULT_VALUE_TIME_PAIR;
    }

    @Override
    public Long readCell(BlockValSet block, int docId) {
        return block.getLongValuesSV()[docId];
    }

    @Override
    public void aggregateGroupResultWithRawDataSv(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        long[] longValues = blockValSet.getLongValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        IntIterator nullIdxIterator = this.orNullIterator(blockValSet, timeValSet);
        this.forEachNotNull(length, nullIdxIterator, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                long data = longValues[i];
                long time = timeValues[i];
                this.setGroupByResult(groupKeyArray[i], groupByResultHolder, data, time);
            }
        });
    }

    @Override
    public void aggregateGroupResultWithRawDataMv(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        long[] longValues = blockValSet.getLongValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        IntIterator nullIdxIterator = this.orNullIterator(blockValSet, timeValSet);
        this.forEachNotNull(length, nullIdxIterator, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                long value = longValues[i];
                long time = timeValues[i];
                for (int groupKey : groupKeysArray[i]) {
                    this.setGroupByResult(groupKey, groupByResultHolder, value, time);
                }
            }
        });
    }

    @Override
    public String getResultColumnName() {
        return this.getType().getName().toLowerCase() + "(" + this._expression + "," + this._timeCol + ",'LONG')";
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.LONG;
    }
}

