/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.function.LastWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.local.customobject.StringLongPair;
import org.apache.pinot.segment.local.customobject.ValueLongPair;
import org.roaringbitmap.IntIterator;

public class LastStringValueWithTimeAggregationFunction
extends LastWithTimeAggregationFunction<String> {
    private static final ValueLongPair<String> DEFAULT_VALUE_TIME_PAIR = new StringLongPair("", Long.MIN_VALUE);

    public LastStringValueWithTimeAggregationFunction(ExpressionContext dataCol, ExpressionContext timeCol, boolean nullHandlingEnabled) {
        super(dataCol, timeCol, ObjectSerDeUtils.STRING_LONG_PAIR_SER_DE, nullHandlingEnabled);
    }

    @Override
    public ValueLongPair<String> constructValueLongPair(String value, long time) {
        return new StringLongPair(value, time);
    }

    @Override
    public ValueLongPair<String> getDefaultValueTimePair() {
        return DEFAULT_VALUE_TIME_PAIR;
    }

    @Override
    public String readCell(BlockValSet block, int docId) {
        return block.getStringValuesSV()[docId];
    }

    @Override
    public void aggregateGroupResultWithRawDataSv(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        String[] stringValues = blockValSet.getStringValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        IntIterator nullIdxIterator = this.orNullIterator(blockValSet, timeValSet);
        this.forEachNotNull(length, nullIdxIterator, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                String data = stringValues[i];
                long time = timeValues[i];
                this.setGroupByResult(groupKeyArray[i], groupByResultHolder, data, time);
            }
        });
    }

    @Override
    public void aggregateGroupResultWithRawDataMv(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        String[] stringValues = blockValSet.getStringValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        IntIterator nullIdxIterator = this.orNullIterator(blockValSet, timeValSet);
        this.forEachNotNull(length, nullIdxIterator, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                String value = stringValues[i];
                long time = timeValues[i];
                for (int groupKey : groupKeysArray[i]) {
                    this.setGroupByResult(groupKey, groupByResultHolder, value, time);
                }
            }
        });
    }

    @Override
    public String getResultColumnName() {
        return this.getType().getName().toLowerCase() + "(" + this._expression + "," + this._timeCol + ",'STRING')";
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.STRING;
    }
}

