/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.MinAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class MinMVAggregationFunction
extends MinAggregationFunction {
    public MinMVAggregationFunction(List<ExpressionContext> arguments) {
        super(MinMVAggregationFunction.verifySingleArgument(arguments, "MIN_MV"), false);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.MINMV;
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[][] valuesArray = blockValSetMap.get(this._expression).getDoubleValuesMV();
        double min = aggregationResultHolder.getDoubleResult();
        for (int i = 0; i < length; ++i) {
            for (double value : valuesArray[i]) {
                if (!(value < min)) continue;
                min = value;
            }
        }
        aggregationResultHolder.setValue(min);
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[][] valuesArray = blockValSetMap.get(this._expression).getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            int groupKey = groupKeyArray[i];
            double min = groupByResultHolder.getDoubleResult(groupKey);
            for (double value : valuesArray[i]) {
                if (!(value < min)) continue;
                min = value;
            }
            groupByResultHolder.setValueForKey(groupKey, min);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[][] valuesArray = blockValSetMap.get(this._expression).getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            double[] values = valuesArray[i];
            for (int groupKey : groupKeysArray[i]) {
                double min = groupByResultHolder.getDoubleResult(groupKey);
                for (double value : values) {
                    if (!(value < min)) continue;
                    min = value;
                }
                groupByResultHolder.setValueForKey(groupKey, min);
            }
        }
    }
}

