/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.utils.ParentAggregationFunctionResultObject;

public abstract class ParentAggregationFunction<I, F extends ParentAggregationFunctionResultObject>
implements AggregationFunction<I, F> {
    protected static final int PARENT_AGGREGATION_FUNCTION_ID_OFFSET = 0;
    protected List<ExpressionContext> _arguments;

    ParentAggregationFunction(List<ExpressionContext> arguments) {
        this._arguments = arguments;
    }

    @Override
    public final DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public final String getResultColumnName() {
        return "pinotparentagg" + this.getType().getName().toLowerCase() + this._arguments.get(0).getLiteral().getIntValue();
    }

    @Override
    public final String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder("pinotparentagg").append("_").append(this.getType().getName()).append('(');
        int numArguments = this._arguments.size();
        if (numArguments > 0) {
            stringBuilder.append(this._arguments.get(0).toString());
            for (int i = 1; i < numArguments; ++i) {
                stringBuilder.append(", ").append(this._arguments.get(i).toString());
            }
        }
        return stringBuilder.append(')').toString();
    }
}

