/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.NullableSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.local.customobject.QuantileDigest;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class PercentileEstAggregationFunction
extends NullableSingleInputAggregationFunction<QuantileDigest, Long> {
    public static final double DEFAULT_MAX_ERROR = 0.05;
    protected final int _version;
    protected final double _percentile;

    public PercentileEstAggregationFunction(ExpressionContext expression, int percentile, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
        this._version = 0;
        this._percentile = percentile;
    }

    public PercentileEstAggregationFunction(ExpressionContext expression, double percentile, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
        this._version = 1;
        this._percentile = percentile;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILEEST;
    }

    @Override
    public String getResultColumnName() {
        return this._version == 0 ? AggregationFunctionType.PERCENTILEEST.getName().toLowerCase() + (int)this._percentile + "(" + this._expression + ")" : AggregationFunctionType.PERCENTILEEST.getName().toLowerCase() + "(" + this._expression + ", " + this._percentile + ")";
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (blockValSet.getValueType() != FieldSpec.DataType.BYTES) {
            long[] longValues = blockValSet.getLongValuesSV();
            QuantileDigest quantileDigest = PercentileEstAggregationFunction.getDefaultQuantileDigest(aggregationResultHolder);
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    quantileDigest.add(longValues[i]);
                }
            });
        } else {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            this.foldNotNull(length, blockValSet, (QuantileDigest)aggregationResultHolder.getResult(), (A quantile, int from, int toEx) -> {
                QuantileDigest quantileDigest;
                int start;
                if (quantile != null) {
                    start = from;
                    quantileDigest = quantile;
                } else {
                    start = from + 1;
                    quantileDigest = ObjectSerDeUtils.QUANTILE_DIGEST_SER_DE.deserialize(bytesValues[from]);
                    aggregationResultHolder.setValue(quantileDigest);
                }
                for (int i = start; i < toEx; ++i) {
                    quantileDigest.merge(ObjectSerDeUtils.QUANTILE_DIGEST_SER_DE.deserialize(bytesValues[i]));
                }
                return quantileDigest;
            });
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (blockValSet.getValueType() != FieldSpec.DataType.BYTES) {
            long[] longValues = blockValSet.getLongValuesSV();
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    PercentileEstAggregationFunction.getDefaultQuantileDigest(groupByResultHolder, groupKeyArray[i]).add(longValues[i]);
                }
            });
        } else {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    QuantileDigest value = ObjectSerDeUtils.QUANTILE_DIGEST_SER_DE.deserialize(bytesValues[i]);
                    int groupKey = groupKeyArray[i];
                    QuantileDigest quantileDigest = (QuantileDigest)groupByResultHolder.getResult(groupKey);
                    if (quantileDigest != null) {
                        quantileDigest.merge(value);
                        continue;
                    }
                    groupByResultHolder.setValueForKey(groupKey, value);
                }
            });
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (blockValSet.getValueType() != FieldSpec.DataType.BYTES) {
            long[] longValues = blockValSet.getLongValuesSV();
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    long value = longValues[i];
                    for (int groupKey : groupKeysArray[i]) {
                        PercentileEstAggregationFunction.getDefaultQuantileDigest(groupByResultHolder, groupKey).add(value);
                    }
                }
            });
        } else {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    QuantileDigest value = ObjectSerDeUtils.QUANTILE_DIGEST_SER_DE.deserialize(bytesValues[i]);
                    for (int groupKey : groupKeysArray[i]) {
                        QuantileDigest quantileDigest = (QuantileDigest)groupByResultHolder.getResult(groupKey);
                        if (quantileDigest != null) {
                            quantileDigest.merge(value);
                            continue;
                        }
                        groupByResultHolder.setValueForKey(groupKey, ObjectSerDeUtils.QUANTILE_DIGEST_SER_DE.deserialize(bytesValues[i]));
                    }
                }
            });
        }
    }

    @Override
    public QuantileDigest extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        QuantileDigest quantileDigest = (QuantileDigest)aggregationResultHolder.getResult();
        if (quantileDigest == null) {
            return new QuantileDigest(0.05);
        }
        return quantileDigest;
    }

    @Override
    public QuantileDigest extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        QuantileDigest quantileDigest = (QuantileDigest)groupByResultHolder.getResult(groupKey);
        if (quantileDigest == null) {
            return new QuantileDigest(0.05);
        }
        return quantileDigest;
    }

    @Override
    public QuantileDigest merge(QuantileDigest intermediateResult1, QuantileDigest intermediateResult2) {
        if (intermediateResult1.getCount() == 0.0) {
            return intermediateResult2;
        }
        if (intermediateResult2.getCount() == 0.0) {
            return intermediateResult1;
        }
        intermediateResult1.merge(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.LONG;
    }

    @Override
    public Long extractFinalResult(QuantileDigest intermediateResult) {
        if (intermediateResult.getCount() == 0.0 && this._nullHandlingEnabled) {
            return null;
        }
        return intermediateResult.getQuantile(this._percentile / 100.0);
    }

    protected static QuantileDigest getDefaultQuantileDigest(AggregationResultHolder aggregationResultHolder) {
        QuantileDigest quantileDigest = (QuantileDigest)aggregationResultHolder.getResult();
        if (quantileDigest == null) {
            quantileDigest = new QuantileDigest(0.05);
            aggregationResultHolder.setValue(quantileDigest);
        }
        return quantileDigest;
    }

    protected static QuantileDigest getDefaultQuantileDigest(GroupByResultHolder groupByResultHolder, int groupKey) {
        QuantileDigest quantileDigest = (QuantileDigest)groupByResultHolder.getResult(groupKey);
        if (quantileDigest == null) {
            quantileDigest = new QuantileDigest(0.05);
            groupByResultHolder.setValueForKey(groupKey, quantileDigest);
        }
        return quantileDigest;
    }
}

